/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLuggage
extends TamableAnimal {
    private int soundCooldown = 15;
    private static final TicketType<Integer> LUGGAGE_UNLOAD = TicketType.create((String)"luggage_unload", Integer::compareTo, (int)20);

    protected AbstractLuggage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.LEAVES, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.1, 7.0f, 1.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 0.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void aiStep() {
        super.aiStep();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive()) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(Items.NAME_TAG)) {
                return InteractionResult.PASS;
            }
            if (player.isShiftKeyDown()) {
                if (this.getOwner() == player) {
                    if (!this.level().isClientSide()) {
                        ItemStack luggageItem = this.createItem();
                        Component nameTag = this.getCustomName();
                        if (nameTag != null && !nameTag.getString().isEmpty()) {
                            luggageItem.set(DataComponents.CUSTOM_NAME, (Object)nameTag);
                        }
                        if (player.getInventory().add(luggageItem)) {
                            this.discard();
                            this.playSound(SoundEvents.ITEM_PICKUP, 0.5f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                player.displayClientMessage((Component)Component.translatable((String)"entity.luggage.player_doesnt_own").withStyle(ChatFormatting.DARK_RED), true);
                return InteractionResult.CONSUME;
            }
            this.onOpenMenu(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void onRemovedFromLevel() {
        Level level;
        if (this.level() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!this.isInSittingPose() && this.getOwner() != null) {
                server.getChunkSource().addRegionTicket(LUGGAGE_UNLOAD, new ChunkPos(this.blockPosition()), 2, (Object)this.getId());
            }
        }
        super.onRemovedFromLevel();
    }

    public int getSoundCooldown() {
        return this.soundCooldown;
    }

    public void setSoundCooldown(int cooldown) {
        this.soundCooldown = cooldown;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public void tame(Player player) {
        this.setTame(true, false);
        this.setOwnerUUID(player.getUUID());
    }

    public boolean wantsToAttack(LivingEntity owner, LivingEntity target) {
        return false;
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return true;
    }

    public void setHealth(float health) {
    }

    public boolean onClimbable() {
        return false;
    }

    public void knockback(double x, double y, double z) {
    }

    protected void pushEntities() {
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        return false;
    }

    public boolean causeFallDamage(float dist, float mult, DamageSource source) {
        return false;
    }

    public void checkDespawn() {
    }

    public boolean attackable() {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    public double getFluidJumpThreshold() {
        return 0.2f;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isSteppingCarefully() {
        return true;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)LuggageRegistries.LUGGAGE_STEP.get(), 0.1f, 0.7f + this.getRandom().nextFloat() * 0.5f);
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.distanceToSqr((Entity)this.getOwner()) >= 1600.0;
    }

    public abstract ItemStack createItem();

    public abstract void onOpenMenu(Player var1);

    public abstract ItemStack getPickResult();
}

