/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.item.LuggageItem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LuggageTooltipComponent
implements ClientTooltipComponent {
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/background");
    private static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/bundle/slot");
    private final NonNullList<ItemStack> items;
    private final boolean extended;

    public LuggageTooltipComponent(LuggageItem.Tooltip tooltip) {
        this.items = tooltip.stacks();
        this.extended = tooltip.stack().has(LuggageRegistries.EXTENDED);
    }

    public int getHeight() {
        return this.backgroundHeight() + 4;
    }

    public int getWidth(Font font) {
        return this.backgroundWidth();
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 18 + 4;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int gridX = this.gridSizeX();
        int gridY = this.gridSizeY();
        graphics.blitSprite(BACKGROUND_SPRITE, x, y, this.backgroundWidth(), this.backgroundHeight());
        int slot = 0;
        for (int yOffset = 0; yOffset < gridY; ++yOffset) {
            for (int xOffset = 0; xOffset < gridX; ++xOffset) {
                int slotX = x + xOffset * 18 + 1;
                int slotY = y + yOffset * 18 + 1;
                this.renderSlot(slotX, slotY, slot++, graphics, font);
            }
        }
    }

    private void renderSlot(int x, int y, int slot, GuiGraphics graphics, Font font) {
        graphics.blitSprite(SLOT_SPRITE, x, y, 0, 18, 20);
        if (slot < this.items.size()) {
            ItemStack itemstack = (ItemStack)this.items.get(slot);
            graphics.renderItem(itemstack, x + 1, y + 1, slot);
            graphics.renderItemDecorations(font, itemstack, x + 1, y + 1);
        }
    }

    private int gridSizeX() {
        return 9;
    }

    private int gridSizeY() {
        return this.extended ? 6 : 3;
    }
}

