/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.entity.Luggage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityCache {
    private static final Map<EntityType<?>, Entity> ENTITY_MAP = new HashMap();
    private static final Set<EntityType<?>> IGNORED_ENTITIES = new HashSet();

    @Nullable
    public static LivingEntity fetchEntity(EntityType<?> type, @Nullable Level level, boolean charged) {
        if (level != null && !IGNORED_ENTITIES.contains(type)) {
            Object entity = type == EntityType.PLAYER ? Minecraft.getInstance().player : ENTITY_MAP.computeIfAbsent(type, t -> {
                Entity created = t.create(level);
                if (created != null) {
                    created.setYRot(0.0f);
                    created.setYHeadRot(0.0f);
                    created.setYBodyRot(0.0f);
                    created.hasImpulse = false;
                    if (created instanceof Mob) {
                        Mob mob = (Mob)created;
                        mob.setNoAi(true);
                    }
                }
                return created;
            });
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (entity instanceof Luggage) {
                    Luggage luggage = (Luggage)((Object)entity);
                    luggage.setExtendedInventory(charged);
                }
                return living;
            }
            IGNORED_ENTITIES.add(type);
            ENTITY_MAP.remove(type);
        }
        return null;
    }
}

