/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.ItemTooltipEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.api.Kitchen;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.ModRenderers;
import net.blay09.mods.cookingforblockheads.client.ModScreens;
import net.blay09.mods.cookingforblockheads.client.gui.screen.KitchenScreen;
import net.blay09.mods.cookingforblockheads.crafting.RecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftableListingFakeSlot;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class CookingForBlockheadsClient {
    private static final Set<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();

    public static void initialize() {
        ModRenderers.initialize(BalmClient.getRenderers());
        ModScreens.initialize(BalmClient.getScreens());
        ModModels.initialize(BalmClient.getModels());
        Balm.getEvents().onEvent(ItemTooltipEvent.class, event -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (!(patt0$temp instanceof KitchenScreen)) return;
            KitchenScreen screen = (KitchenScreen)patt0$temp;
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            KitchenMenu menu = (KitchenMenu)screen.getMenu();
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
            if (hoverSlot instanceof CraftableListingFakeSlot) {
                CraftableListingFakeSlot listingSlot = (CraftableListingFakeSlot)hoverSlot;
                if (event.getItemStack() == hoverSlot.getItem()) {
                    Kitchen kitchen = menu.getKitchen();
                    RecipeWithStatus selectedRecipeWithStatus = menu.getSelectedRecipe();
                    if (selectedRecipeWithStatus == null) {
                        return;
                    }
                    Recipe selectedRecipe = selectedRecipeWithStatus.recipe(player).value();
                    if (menu.isSelectedSlot(listingSlot) && kitchen.canProcess(RecipeType.CRAFTING)) {
                        if (selectedRecipe.getType() == RecipeType.SMELTING) {
                            if (!kitchen.canProcess(RecipeType.SMELTING)) {
                                event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.missing_oven").withStyle(ChatFormatting.RED));
                                return;
                            }
                            if (Screen.hasShiftDown()) {
                                event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_smelt_stack").withStyle(ChatFormatting.GREEN));
                                return;
                            }
                            event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_smelt_one").withStyle(ChatFormatting.GREEN));
                            return;
                        }
                        List<Ingredient> missingIngredients = selectedRecipeWithStatus.missingIngredients();
                        if (selectedRecipeWithStatus.isMissingUtensils()) {
                            event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.missing_tools").withStyle(ChatFormatting.RED));
                            return;
                        }
                        if (!missingIngredients.isEmpty()) {
                            event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.missing_ingredients").withStyle(ChatFormatting.RED));
                            return;
                        }
                        if (Screen.hasShiftDown()) {
                            event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_craft_stack").withStyle(ChatFormatting.GREEN));
                            return;
                        }
                        event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_craft_one").withStyle(ChatFormatting.GREEN));
                        return;
                    }
                    event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_see_recipe").withStyle(ChatFormatting.YELLOW));
                    return;
                }
            }
            if (!(hoverSlot instanceof CraftMatrixFakeSlot)) return;
            if (event.getItemStack() != hoverSlot.getItem()) return;
            if (((CraftMatrixFakeSlot)hoverSlot).getVisibleStacks().size() <= 1) return;
            if (((CraftMatrixFakeSlot)hoverSlot).isLocked()) {
                event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_unlock").withStyle(ChatFormatting.GREEN));
            } else {
                event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.click_to_lock").withStyle(ChatFormatting.GREEN));
            }
            event.getToolTip().add(Component.translatable((String)"tooltip.cookingforblockheads.scroll_to_switch").withStyle(ChatFormatting.YELLOW));
        });
    }

    public static void setFavoriteItems(Set<ResourceLocation> favoriteItemIds) {
        CookingForBlockheadsClient.favoriteItemIds.clear();
        CookingForBlockheadsClient.favoriteItemIds.addAll(favoriteItemIds);
    }

    public static boolean isFavoriteItem(ItemStack itemStack) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        return favoriteItemIds.contains(itemId);
    }
}

