/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.network.c2s;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class CommandMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, CommandMessage> STREAM_CODEC = StreamCodec.ofMember(CommandMessage::encode, CommandMessage::new);
    public static final CustomPacketPayload.Type<CommandMessage> TYPE = Message.createType("command");
    private final Key key;
    private final double fx;
    private final double fy;
    private final double fz;

    public CustomPacketPayload.Type<CommandMessage> type() {
        return TYPE;
    }

    public CommandMessage(Key key, Vec3 velocity) {
        this.key = key;
        this.fx = velocity.x;
        this.fy = velocity.y;
        this.fz = velocity.z;
    }

    public CommandMessage(RegistryFriendlyByteBuf b) {
        this.key = Key.values()[b.readInt()];
        this.fx = b.readDouble();
        this.fy = b.readDouble();
        this.fz = b.readDouble();
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeInt(this.key.ordinal());
        b.writeDouble(this.fx);
        b.writeDouble(this.fy);
        b.writeDouble(this.fz);
    }

    @Override
    public void receiveServer(ServerPlayer e) {
        Entity entity = e.getRootVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (this.key == Key.DISMOUNT) {
                e.stopRiding();
                e.setJumping(false);
                vehicle.chill();
                vehicle.setDeltaMovement(this.fx, this.fy, this.fz);
            } else if (this.key == Key.BOOST && vehicle.canBoost()) {
                vehicle.boost();
            }
        }
    }

    public static enum Key {
        DISMOUNT,
        BOOST,
        DAMAGE;

    }
}

