/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.wasm;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.object.HiddenKey;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.wasm.WebAssemblyBuiltins;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRealm;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSWebAssembly {
    public static final TruffleString CLASS_NAME = Strings.constant("WebAssembly");
    public static final HiddenKey FUNCTION_ADDRESS = new HiddenKey("FunctionAddress");

    private JSWebAssembly() {
    }

    public static JSObject create(JSRealm realm) {
        JSObject webAssembly = JSOrdinary.createInit(realm);
        JSObjectUtil.putToStringTag(webAssembly, CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(realm, webAssembly, WebAssemblyBuiltins.BUILTINS);
        return webAssembly;
    }

    public static boolean isExportedFunction(Object function) {
        return JSDynamicObject.isJSDynamicObject(function) && JSObjectUtil.hasHiddenProperty((JSDynamicObject)function, FUNCTION_ADDRESS);
    }

    public static Object getExportedFunction(JSDynamicObject function) {
        assert (JSWebAssembly.isExportedFunction(function));
        return JSObjectUtil.getHiddenProperty(function, FUNCTION_ADDRESS);
    }

    public static Object getEmbedderData(JSRealm realm, Object wasmEntity) {
        Object embedderDataGetter = realm.getWASMEmbedderDataGet();
        try {
            return InteropLibrary.getUncached(embedderDataGetter).execute(embedderDataGetter, wasmEntity);
        }
        catch (InteropException iex) {
            throw CompilerDirectives.shouldNotReachHere(iex);
        }
    }

    public static void setEmbedderData(JSRealm realm, Object wasmEntity, Object data) {
        Object embedderDataSetter = realm.getWASMEmbedderDataSet();
        try {
            InteropLibrary.getUncached(embedderDataSetter).execute(embedderDataSetter, wasmEntity, data);
        }
        catch (InteropException iex) {
            throw CompilerDirectives.shouldNotReachHere(iex);
        }
    }
}

