/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToIndexNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSRuntime;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSToIndexNode
extends JavaScriptBaseNode {
    public static JSToIndexNode create() {
        return JSToIndexNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected long doInt(int value, @Cached @Cached.Shared(value="negativeIndexBranch") BranchProfile negativeIndexBranch) {
        if (value < 0) {
            negativeIndexBranch.enter();
            throw Errors.createRangeErrorIndexNegative(this);
        }
        return value;
    }

    @Specialization
    protected long doSafeInteger(SafeInteger value, @Cached @Cached.Shared(value="negativeIndexBranch") BranchProfile negativeIndexBranch) {
        long longValue = value.longValue();
        if (longValue < 0L) {
            negativeIndexBranch.enter();
            throw Errors.createRangeErrorIndexNegative(this);
        }
        return longValue;
    }

    @Specialization
    protected long doDouble(double value, @Cached @Cached.Shared(value="negativeIndexBranch") BranchProfile negativeIndexBranch, @Cached BranchProfile tooLargeIndexBranch) {
        long integerIndex = (long)value;
        if (integerIndex < 0L) {
            negativeIndexBranch.enter();
            throw Errors.createRangeErrorIndexNegative(this);
        }
        if (integerIndex > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            tooLargeIndexBranch.enter();
            throw Errors.createRangeErrorIndexTooLarge(this);
        }
        return integerIndex;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static long doUndefined(Object value) {
        return 0L;
    }

    @Specialization
    protected static long doObject(Object value, @Cached(value="create()") JSToNumberNode toNumberNode, @Cached(value="create()") JSToIndexNode recursiveToIndexNode) {
        Number number = (Number)toNumberNode.execute(value);
        assert (number instanceof Integer || number instanceof Double);
        return recursiveToIndexNode.executeLong(number);
    }
}

