/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Executed;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.Tag;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.IteratorToArrayNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.JSConstantNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSArray;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.Set;

public abstract class IteratorToArrayNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    @Executed
    JavaScriptNode iteratorNode;
    @Node.Child
    private IteratorGetNextValueNode iteratorStepNode;

    protected IteratorToArrayNode(JSContext context, JavaScriptNode iteratorNode, IteratorGetNextValueNode iteratorStepNode) {
        this.context = context;
        this.iteratorNode = iteratorNode;
        this.iteratorStepNode = iteratorStepNode;
    }

    public static IteratorToArrayNode create(JSContext context, JavaScriptNode iterator) {
        IteratorGetNextValueNode iteratorStep = IteratorGetNextValueNode.create(context, null, JSConstantNode.create(null), true);
        return IteratorToArrayNodeGen.create(context, iterator, iteratorStep);
    }

    @Specialization(guards={"!iteratorRecord.isDone()"})
    protected Object doIterator(VirtualFrame frame, IteratorRecord iteratorRecord, @Cached BranchProfile growProfile) {
        Object value;
        SimpleArrayList<Object> elements = new SimpleArrayList<Object>();
        while ((value = this.iteratorStepNode.execute(frame, iteratorRecord)) != null) {
            elements.add(value, growProfile);
        }
        return JSArray.createZeroBasedObjectArray(this.context, this.getRealm(), elements.toArray());
    }

    @Specialization(guards={"iteratorRecord.isDone()"})
    protected Object doDoneIterator(IteratorRecord iteratorRecord) {
        return JSArray.createEmptyZeroLength(this.context, this.getRealm());
    }

    public abstract Object execute(VirtualFrame var1, IteratorRecord var2);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorToArrayNodeGen.create(this.context, IteratorToArrayNode.cloneUninitialized(this.iteratorNode, materializedTags), IteratorToArrayNode.cloneUninitialized(this.iteratorStepNode, materializedTags));
    }
}

