/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Executed;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.instrumentation.Tag;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.object.Property;
import com.cobblemon.mod.relocations.oracle.truffle.api.object.Shape;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.BranchProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalScopeNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.GlobalScopeTDZCheckNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Dead;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.util.Set;

abstract class GlobalScopeTDZCheckNode
extends GlobalScopeNode {
    final TruffleString varName;
    @Node.Child
    @Executed
    JavaScriptNode scopeNode;

    GlobalScopeTDZCheckNode(JSContext context, TruffleString varName) {
        super(context);
        this.varName = varName;
        this.scopeNode = GlobalScopeNode.create(context);
    }

    @Specialization(guards={"scope.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="context.getPropertyCacheLimit()")
    final Object doCached(JSDynamicObject scope, @Cached(value="scope.getShape()") Shape cachedShape, @Cached(value="isDead(cachedShape)") boolean dead) {
        assert (dead == (JSDynamicObject.getOrNull(scope, this.varName) == Dead.instance()));
        if (dead) {
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    @Specialization(replaces={"doCached"})
    final Object doUncached(Object scope, @Cached(value="create(varName, context)") PropertyGetNode getNode, @Cached(value="create()") BranchProfile deadBranch) {
        if (getNode.getValue(scope) == Dead.instance()) {
            deadBranch.enter();
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    final boolean isDead(Shape shape) {
        Property property = shape.getProperty(this.varName);
        return property != null && property.getLocation().isConstant() && property.getLocation().getConstantValue() == Dead.instance();
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GlobalScopeTDZCheckNodeGen.create(this.context, this.varName);
    }
}

