/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.object.DynamicObjectLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.IsNumberNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSErrorType;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.builtins.JSError;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.JSProperty;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.objects.Undefined;

public abstract class ErrorStackTraceLimitNode
extends JavaScriptBaseNode {
    @Node.Child
    private DynamicObjectLibrary getStackTraceLimit = JSObjectUtil.createDispatched(JSError.STACK_TRACE_LIMIT_PROPERTY_NAME);
    @Node.Child
    private IsNumberNode isNumber = IsNumberNode.create();
    @Node.Child
    private JSToIntegerAsLongNode toInteger = JSToIntegerAsLongNode.create();

    protected ErrorStackTraceLimitNode() {
    }

    public static ErrorStackTraceLimitNode create() {
        return ErrorStackTraceLimitNodeGen.create();
    }

    @Specialization
    public int doInt() {
        Object value;
        JSDynamicObject errorConstructor = this.getRealm().getErrorConstructor(JSErrorType.Error);
        if (JSProperty.isData(this.getStackTraceLimit.getPropertyFlagsOrDefault(errorConstructor, JSError.STACK_TRACE_LIMIT_PROPERTY_NAME, 8)) && this.isNumber.execute(value = this.getStackTraceLimit.getOrDefault(errorConstructor, JSError.STACK_TRACE_LIMIT_PROPERTY_NAME, Undefined.instance))) {
            long limit = this.toInteger.executeLong(value);
            return (int)Math.max(0L, Math.min(limit, Integer.MAX_VALUE));
        }
        return 0;
    }

    public abstract int executeInt();
}

