/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.world.predicate;

import com.cobblemon.mod.common.world.predicate.CobblemonBlockPredicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B;\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0002\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R)\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R)\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/world/predicate/BiomePredicate;", "Lnet/minecraft/world/level/levelgen/blockpredicates/BlockPredicate;", "Ljava/util/Optional;", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/biome/Biome;", "includedBiomes", "excludedBiomes", "<init>", "(Ljava/util/Optional;Ljava/util/Optional;)V", "Lnet/minecraft/world/level/WorldGenLevel;", "world", "Lnet/minecraft/core/BlockPos;", "block", "", "test", "(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/levelgen/blockpredicates/BlockPredicateType;", "type", "()Lnet/minecraft/world/level/levelgen/blockpredicates/BlockPredicateType;", "Ljava/util/Optional;", "getIncludedBiomes", "()Ljava/util/Optional;", "getExcludedBiomes", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nBiomePredicate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomePredicate.kt\ncom/cobblemon/mod/common/world/predicate/BiomePredicate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1761#2,3:52\n1761#2,3:55\n*S KotlinDebug\n*F\n+ 1 BiomePredicate.kt\ncom/cobblemon/mod/common/world/predicate/BiomePredicate\n*L\n37#1:52,3\n38#1:55,3\n*E\n"})
public final class BiomePredicate
implements BlockPredicate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Optional<List<TagKey<Biome>>> includedBiomes;
    @NotNull
    private final Optional<List<TagKey<Biome>>> excludedBiomes;
    @NotNull
    private static final MapCodec<BiomePredicate> CODEC;

    public BiomePredicate(@NotNull Optional<List<TagKey<Biome>>> includedBiomes, @NotNull Optional<List<TagKey<Biome>>> excludedBiomes) {
        Intrinsics.checkNotNullParameter(includedBiomes, (String)"includedBiomes");
        Intrinsics.checkNotNullParameter(excludedBiomes, (String)"excludedBiomes");
        this.includedBiomes = includedBiomes;
        this.excludedBiomes = excludedBiomes;
    }

    @NotNull
    public final Optional<List<TagKey<Biome>>> getIncludedBiomes() {
        return this.includedBiomes;
    }

    @NotNull
    public final Optional<List<TagKey<Biome>>> getExcludedBiomes() {
        return this.excludedBiomes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(@NotNull WorldGenLevel world, @NotNull BlockPos block) {
        boolean bl;
        Object element$iv;
        TagKey it;
        Iterator iterator;
        boolean $i$f$any;
        Iterable $this$any$iv;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Holder biome = world.getBiome(block);
        List list = (List)OptionalsKt.getOrNull(this.includedBiomes);
        if (list != null) {
            $this$any$iv = list;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                element$iv = iterator.next();
                it = (TagKey)element$iv;
                boolean bl2 = false;
            } while (!biome.is(it));
            bl = true;
        } else {
            bl = true;
        }
        if (!bl) return false;
        List list2 = (List)OptionalsKt.getOrNull(this.excludedBiomes);
        if (list2 == null) return true;
        $this$any$iv = list2;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (TagKey)element$iv;
            boolean bl3 = false;
        } while (!biome.is(it));
        return false;
    }

    @NotNull
    public BlockPredicateType<BiomePredicate> type() {
        return CobblemonBlockPredicates.INSTANCE.getBIOME();
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)TagKey.hashedCodec((ResourceKey)Registries.BIOME).listOf().optionalFieldOf("includedBiomes").forGetter(BiomePredicate::CODEC$lambda$0$0), (App)TagKey.hashedCodec((ResourceKey)Registries.BIOME).listOf().optionalFieldOf("excludedBiomes").forGetter(BiomePredicate::CODEC$lambda$0$1)).apply((Applicative)instance, BiomePredicate::new);
    }

    private static final Optional CODEC$lambda$0$0(BiomePredicate it) {
        return it.includedBiomes;
    }

    private static final Optional CODEC$lambda$0$1(BiomePredicate it) {
        return it.excludedBiomes;
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(BiomePredicate::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/world/predicate/BiomePredicate$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/world/predicate/BiomePredicate;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<BiomePredicate> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

