/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util.collections;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\u000fB\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\fR\b\u0012\u0004\u0012\u00028\u00000\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/util/collections/RotatedIterable;", "T", "", "", "list", "", "startAt", "<init>", "(Ljava/util/List;I)V", "", "iterator", "()Ljava/util/Iterator;", "Lcom/cobblemon/mod/common/util/collections/RotatedIterable$RotatedListIterator;", "iter", "Lcom/cobblemon/mod/common/util/collections/RotatedIterable$RotatedListIterator;", "RotatedListIterator", "common"})
public final class RotatedIterable<T>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final RotatedListIterator<T> iter;

    public RotatedIterable(@NotNull List<? extends T> list, int startAt) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.iter = new RotatedListIterator<T>(list, startAt);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.iter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0004\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/util/collections/RotatedIterable$RotatedListIterator;", "T", "", "", "list", "", "startAt", "<init>", "(Lcom/cobblemon/mod/common/util/collections/RotatedIterable;Ljava/util/List;I)V", "", "hasNext", "()Z", "nextIndex", "()I", "next", "()Ljava/lang/Object;", "Ljava/util/List;", "I", "outerIdx", "common"})
    public final class RotatedListIterator<T>
    implements Iterator<T>,
    KMappedMarker {
        @NotNull
        private final List<T> list;
        private final int startAt;
        private int outerIdx;

        public RotatedListIterator(List<? extends T> list, int startAt) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.startAt = startAt;
        }

        @Override
        public boolean hasNext() {
            return this.outerIdx < this.list.size();
        }

        private final int nextIndex() {
            int idx = this.startAt + this.outerIdx;
            ++this.outerIdx;
            return idx < this.list.size() ? idx : idx - this.list.size();
        }

        @Override
        public T next() {
            return this.list.get(this.nextIndex());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

