/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.util;

import com.cobblemon.mod.common.Cobblemon;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0000*\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001b\u0010\b\u001a\u00020\u0000*\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/minecraft/resources/ResourceLocation;", "Ljava/io/File;", "directory", "", "extractTo", "(Lnet/minecraft/resources/ResourceLocation;Ljava/io/File;)V", "", "namespace", "asIdentifierDefaultingNamespace", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "Lcom/mojang/brigadier/StringReader;", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "common"})
public final class ResourceLocationExtensionsKt {
    public static final void extractTo(@NotNull ResourceLocation $this$extractTo, @NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)$this$extractTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        String string = "/assets/%s/%s";
        Object[] objectArray = new Object[]{$this$extractTo.getNamespace(), $this$extractTo.getPath()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        InputStream inputStream = Cobblemon.class.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new Exception("Could not read " + $this$extractTo);
        }
        InputStream stream = inputStream;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(stream, directory.toPath(), copyOptionArray);
        stream.close();
    }

    @NotNull
    public static final ResourceLocation asIdentifierDefaultingNamespace(@NotNull String $this$asIdentifierDefaultingNamespace, @NotNull String namespace) {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter((Object)$this$asIdentifierDefaultingNamespace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String string = $this$asIdentifierDefaultingNamespace.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String id = string;
        if (StringsKt.contains$default((CharSequence)id, (CharSequence)":", (boolean)false, (int)2, null)) {
            ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)StringsKt.substringBefore$default((String)id, (String)":", null, (int)2, null), (String)StringsKt.substringAfter$default((String)id, (String)":", null, (int)2, null));
            resourceLocation = resourceLocation2;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        } else {
            ResourceLocation resourceLocation3 = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id);
            resourceLocation = resourceLocation3;
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"fromNamespaceAndPath(...)");
        }
        return resourceLocation;
    }

    public static /* synthetic */ ResourceLocation asIdentifierDefaultingNamespace$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "cobblemon";
        }
        return ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace(string, string2);
    }

    @NotNull
    public static final ResourceLocation asIdentifierDefaultingNamespace(@NotNull StringReader $this$asIdentifierDefaultingNamespace, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)$this$asIdentifierDefaultingNamespace, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        int start = $this$asIdentifierDefaultingNamespace.getCursor();
        while ($this$asIdentifierDefaultingNamespace.canRead() && ResourceLocation.isAllowedInResourceLocation((char)$this$asIdentifierDefaultingNamespace.peek())) {
            $this$asIdentifierDefaultingNamespace.skip();
        }
        String string = $this$asIdentifierDefaultingNamespace.getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        int n = $this$asIdentifierDefaultingNamespace.getCursor();
        String string3 = string2.substring(start, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String raw = string3;
        try {
            return ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace(raw, namespace);
        }
        catch (ResourceLocationException e) {
            $this$asIdentifierDefaultingNamespace.setCursor(start);
            CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.id.invalid")).createWithContext((ImmutableStringReader)$this$asIdentifierDefaultingNamespace);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"createWithContext(...)");
            throw (Throwable)commandSyntaxException;
        }
    }

    public static /* synthetic */ ResourceLocation asIdentifierDefaultingNamespace$default(StringReader stringReader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "cobblemon";
        }
        return ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace(stringReader, string);
    }
}

