/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.serverhandling.pasture;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.ServerNetworkPacketHandler;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.api.pasture.PastureLinkManager;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.net.messages.client.pasture.ClosePasturePacket;
import com.cobblemon.mod.common.net.messages.server.pasture.PasturePokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/net/serverhandling/pasture/PasturePokemonHandler;", "Lcom/cobblemon/mod/common/api/net/ServerNetworkPacketHandler;", "Lcom/cobblemon/mod/common/net/messages/server/pasture/PasturePokemonPacket;", "<init>", "()V", "packet", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "handle", "(Lcom/cobblemon/mod/common/net/messages/server/pasture/PasturePokemonPacket;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/level/ServerPlayer;)V", "common"})
public final class PasturePokemonHandler
implements ServerNetworkPacketHandler<PasturePokemonPacket> {
    @NotNull
    public static final PasturePokemonHandler INSTANCE = new PasturePokemonHandler();

    private PasturePokemonHandler() {
    }

    @Override
    public void handle(@NotNull PasturePokemonPacket packet, @NotNull MinecraftServer server, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PastureLink pastureLink = PastureLinkManager.getLinkByPlayer(player);
        if (pastureLink == null) {
            return;
        }
        PastureLink pastureLink2 = pastureLink;
        if (!Intrinsics.areEqual((Object)pastureLink2.getLinkId(), (Object)packet.getPastureId())) {
            CobblemonNetwork.INSTANCE.sendPacket(player, new ClosePasturePacket());
            return;
        }
        PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
        UUID uUID = pastureLink2.getPcId();
        RegistryAccess registryAccess = player.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        PCStore pc = pokemonStoreManager.getPC(uUID, registryAccess);
        Pokemon pokemon = pc.get(packet.getPokemonId());
        if (pokemon == null) {
            return;
        }
        Pokemon pokemon2 = pokemon;
        BlockEntity blockEntity = player.level().getBlockEntity(pastureLink2.getPos());
        PokemonPastureBlockEntity pokemonPastureBlockEntity = blockEntity instanceof PokemonPastureBlockEntity ? (PokemonPastureBlockEntity)blockEntity : null;
        if (pokemonPastureBlockEntity == null) {
            return;
        }
        PokemonPastureBlockEntity pastureBlockEntity = pokemonPastureBlockEntity;
        BlockState state = player.level().getBlockState(pastureLink2.getPos());
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        if (pokemon2.getTetheringId() != null) {
            return;
        }
        int maxPerPlayer = pastureLink2.getPermissions().getMaxPokemon();
        if (pastureBlockEntity.canAddPokemon(player, pokemon2, maxPerPlayer)) {
            Intrinsics.checkNotNull((Object)direction);
            pastureBlockEntity.tether(player, pokemon2, direction);
        }
    }
}

