/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.spawn;

import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.entity.npc.NPCPlayerModelType;
import com.cobblemon.mod.common.entity.npc.NPCPlayerTexture;
import com.cobblemon.mod.common.net.messages.client.spawn.SpawnExtraDataEntityPacket;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b:\u0018\u0000 b2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001bB\u0095\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0015\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eB\u0019\b\u0016\u0012\u0006\u0010\u001f\u001a\u00020\u0002\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010 J\u0017\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020&H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020)H\u0016\u00a2\u0006\u0004\b*\u0010+R\"\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010,\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R(\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u00103\u001a\u0004\b=\u00105\"\u0004\b>\u00107R\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010S\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\"\u0010\u0017\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010S\u001a\u0004\bX\u0010U\"\u0004\bY\u0010WR\"\u0010\u0018\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010S\u001a\u0004\bZ\u0010U\"\u0004\b[\u0010WR\"\u0010\u0019\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010S\u001a\u0004\b\\\u0010U\"\u0004\b]\u0010WR\"\u0010\u001a\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010S\u001a\u0004\b^\u0010U\"\u0004\b_\u0010WR\u001a\u0010`\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b`\u0010,\u001a\u0004\ba\u0010.\u00a8\u0006c"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/spawn/SpawnNPCPacket;", "Lcom/cobblemon/mod/common/net/messages/client/spawn/SpawnExtraDataEntityPacket;", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "Lnet/minecraft/resources/ResourceLocation;", "npcClass", "resourceIdentifier", "", "", "aspects", "", "level", "Ljava/util/UUID;", "battleIds", "Lnet/minecraft/network/chat/Component;", "name", "Lcom/cobblemon/mod/common/entity/PoseType;", "poseType", "Lcom/cobblemon/mod/common/entity/npc/NPCPlayerTexture;", "texture", "", "hideNameTag", "", "hitboxWidth", "hitboxHeight", "hitboxEyesHeight", "hitboxScale", "renderScale", "Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;", "vanillaSpawnPacket", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Ljava/util/Set;ILjava/util/Set;Lnet/minecraft/network/chat/Component;Lcom/cobblemon/mod/common/entity/PoseType;Lcom/cobblemon/mod/common/entity/npc/NPCPlayerTexture;ZFFFFFLnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V", "entity", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encodeEntityData", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "Lnet/minecraft/client/multiplayer/ClientLevel;", "applyData", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;Lnet/minecraft/client/multiplayer/ClientLevel;)V", "Lnet/minecraft/world/entity/Entity;", "checkType", "(Lnet/minecraft/world/entity/Entity;)Z", "Lnet/minecraft/resources/ResourceLocation;", "getNpcClass", "()Lnet/minecraft/resources/ResourceLocation;", "setNpcClass", "(Lnet/minecraft/resources/ResourceLocation;)V", "getResourceIdentifier", "setResourceIdentifier", "Ljava/util/Set;", "getAspects", "()Ljava/util/Set;", "setAspects", "(Ljava/util/Set;)V", "I", "getLevel", "()I", "setLevel", "(I)V", "getBattleIds", "setBattleIds", "Lnet/minecraft/network/chat/Component;", "getName", "()Lnet/minecraft/network/chat/Component;", "setName", "(Lnet/minecraft/network/chat/Component;)V", "Lcom/cobblemon/mod/common/entity/PoseType;", "getPoseType", "()Lcom/cobblemon/mod/common/entity/PoseType;", "setPoseType", "(Lcom/cobblemon/mod/common/entity/PoseType;)V", "Lcom/cobblemon/mod/common/entity/npc/NPCPlayerTexture;", "getTexture", "()Lcom/cobblemon/mod/common/entity/npc/NPCPlayerTexture;", "setTexture", "(Lcom/cobblemon/mod/common/entity/npc/NPCPlayerTexture;)V", "Z", "getHideNameTag", "()Z", "setHideNameTag", "(Z)V", "F", "getHitboxWidth", "()F", "setHitboxWidth", "(F)V", "getHitboxHeight", "setHitboxHeight", "getHitboxEyesHeight", "setHitboxEyesHeight", "getHitboxScale", "setHitboxScale", "getRenderScale", "setRenderScale", "id", "getId", "Companion", "common"})
public final class SpawnNPCPacket
extends SpawnExtraDataEntityPacket<SpawnNPCPacket, NPCEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ResourceLocation npcClass;
    @NotNull
    private ResourceLocation resourceIdentifier;
    @NotNull
    private Set<String> aspects;
    private int level;
    @NotNull
    private Set<UUID> battleIds;
    @NotNull
    private Component name;
    @NotNull
    private PoseType poseType;
    @NotNull
    private NPCPlayerTexture texture;
    private boolean hideNameTag;
    private float hitboxWidth;
    private float hitboxHeight;
    private float hitboxEyesHeight;
    private float hitboxScale;
    private float renderScale;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final ResourceLocation ID = MiscUtilsKt.cobblemonResource("spawn_npc_entity");

    public SpawnNPCPacket(@NotNull ResourceLocation npcClass, @NotNull ResourceLocation resourceIdentifier, @NotNull Set<String> aspects2, int level, @NotNull Set<UUID> battleIds, @NotNull Component name, @NotNull PoseType poseType, @NotNull NPCPlayerTexture texture, boolean hideNameTag, float hitboxWidth, float hitboxHeight, float hitboxEyesHeight, float hitboxScale, float renderScale, @NotNull ClientboundAddEntityPacket vanillaSpawnPacket) {
        Intrinsics.checkNotNullParameter((Object)npcClass, (String)"npcClass");
        Intrinsics.checkNotNullParameter((Object)resourceIdentifier, (String)"resourceIdentifier");
        Intrinsics.checkNotNullParameter(aspects2, (String)"aspects");
        Intrinsics.checkNotNullParameter(battleIds, (String)"battleIds");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)poseType), (String)"poseType");
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter((Object)vanillaSpawnPacket, (String)"vanillaSpawnPacket");
        super(vanillaSpawnPacket);
        this.npcClass = npcClass;
        this.resourceIdentifier = resourceIdentifier;
        this.aspects = aspects2;
        this.level = level;
        this.battleIds = battleIds;
        this.name = name;
        this.poseType = poseType;
        this.texture = texture;
        this.hideNameTag = hideNameTag;
        this.hitboxWidth = hitboxWidth;
        this.hitboxHeight = hitboxHeight;
        this.hitboxEyesHeight = hitboxEyesHeight;
        this.hitboxScale = hitboxScale;
        this.renderScale = renderScale;
        this.id = ID;
    }

    public /* synthetic */ SpawnNPCPacket(ResourceLocation resourceLocation, ResourceLocation resourceLocation2, Set set, int n, Set set2, Component component, PoseType poseType, NPCPlayerTexture nPCPlayerTexture, boolean bl, float f, float f2, float f3, float f4, float f5, ClientboundAddEntityPacket clientboundAddEntityPacket, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x200) != 0) {
            f = 0.6f;
        }
        if ((n2 & 0x400) != 0) {
            f2 = 1.8f;
        }
        if ((n2 & 0x800) != 0) {
            f3 = 1.62f;
        }
        if ((n2 & 0x1000) != 0) {
            f4 = 1.0f;
        }
        if ((n2 & 0x2000) != 0) {
            f5 = 1.0f;
        }
        this(resourceLocation, resourceLocation2, set, n, set2, component, poseType, nPCPlayerTexture, bl, f, f2, f3, f4, f5, clientboundAddEntityPacket);
    }

    @NotNull
    public final ResourceLocation getNpcClass() {
        return this.npcClass;
    }

    public final void setNpcClass(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.npcClass = resourceLocation;
    }

    @NotNull
    public final ResourceLocation getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final void setResourceIdentifier(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.resourceIdentifier = resourceLocation;
    }

    @NotNull
    public final Set<String> getAspects() {
        return this.aspects;
    }

    public final void setAspects(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.aspects = set;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int n) {
        this.level = n;
    }

    @NotNull
    public final Set<UUID> getBattleIds() {
        return this.battleIds;
    }

    public final void setBattleIds(@NotNull Set<UUID> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.battleIds = set;
    }

    @NotNull
    public final Component getName() {
        return this.name;
    }

    public final void setName(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
        this.name = component;
    }

    @NotNull
    public final PoseType getPoseType() {
        return this.poseType;
    }

    public final void setPoseType(@NotNull PoseType poseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)poseType), (String)"<set-?>");
        this.poseType = poseType;
    }

    @NotNull
    public final NPCPlayerTexture getTexture() {
        return this.texture;
    }

    public final void setTexture(@NotNull NPCPlayerTexture nPCPlayerTexture) {
        Intrinsics.checkNotNullParameter((Object)nPCPlayerTexture, (String)"<set-?>");
        this.texture = nPCPlayerTexture;
    }

    public final boolean getHideNameTag() {
        return this.hideNameTag;
    }

    public final void setHideNameTag(boolean bl) {
        this.hideNameTag = bl;
    }

    public final float getHitboxWidth() {
        return this.hitboxWidth;
    }

    public final void setHitboxWidth(float f) {
        this.hitboxWidth = f;
    }

    public final float getHitboxHeight() {
        return this.hitboxHeight;
    }

    public final void setHitboxHeight(float f) {
        this.hitboxHeight = f;
    }

    public final float getHitboxEyesHeight() {
        return this.hitboxEyesHeight;
    }

    public final void setHitboxEyesHeight(float f) {
        this.hitboxEyesHeight = f;
    }

    public final float getHitboxScale() {
        return this.hitboxScale;
    }

    public final void setHitboxScale(float f) {
        this.hitboxScale = f;
    }

    public final float getRenderScale() {
        return this.renderScale;
    }

    public final void setRenderScale(float f) {
        this.renderScale = f;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    public SpawnNPCPacket(@NotNull NPCEntity entity, @NotNull ClientboundAddEntityPacket vanillaSpawnPacket) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)vanillaSpawnPacket, (String)"vanillaSpawnPacket");
        ResourceLocation resourceLocation = entity.getNpc().getId();
        ResourceLocation resourceLocation2 = entity.getResourceIdentifier();
        Set<String> set = entity.getAspects();
        int n = entity.getLevel();
        Set<UUID> set2 = entity.getBattleIds();
        Component component = entity.getName();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getName(...)");
        Object object = entity.getEntityData().get(NPCEntity.Companion.getPOSE_TYPE());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        PoseType poseType = (PoseType)((Object)object);
        Object object2 = entity.getEntityData().get(NPCEntity.Companion.getNPC_PLAYER_TEXTURE());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this(resourceLocation, resourceLocation2, set, n, set2, component, poseType, (NPCPlayerTexture)object2, entity.getHideNameTag(), entity.getHitboxWidth(), entity.getHitboxHeight(), entity.getHitboxEyesHeight(), entity.getHitboxScale(), entity.getRenderScale(), vanillaSpawnPacket);
    }

    @Override
    public void encodeEntityData(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.npcClass);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.resourceIdentifier);
        buffer.writeCollection((Collection)this.aspects, (arg_0, arg_1) -> SpawnNPCPacket.encodeEntityData$lambda$1(SpawnNPCPacket::encodeEntityData$lambda$0, arg_0, arg_1));
        buffer.writeInt(this.level);
        buffer.writeCollection((Collection)this.battleIds, (arg_0, arg_1) -> SpawnNPCPacket.encodeEntityData$lambda$3(SpawnNPCPacket::encodeEntityData$lambda$2, arg_0, arg_1));
        BufferUtilsKt.writeText(buffer, this.name);
        BufferUtilsKt.writeEnumConstant((ByteBuf)buffer, this.poseType);
        BufferUtilsKt.writeEnumConstant((ByteBuf)buffer, this.texture.getModel());
        if (this.texture.getModel() != NPCPlayerModelType.NONE) {
            buffer.writeByteArray(this.texture.getTexture());
        }
        buffer.writeBoolean(this.hideNameTag);
        buffer.writeFloat(this.hitboxWidth);
        buffer.writeFloat(this.hitboxHeight);
        buffer.writeFloat(this.hitboxEyesHeight);
        buffer.writeFloat(this.hitboxScale);
        buffer.writeFloat(this.renderScale);
    }

    @Override
    public void applyData(@NotNull NPCEntity entity, @NotNull ClientLevel level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        NPCClass nPCClass = NPCClasses.getByIdentifier(this.npcClass);
        if (nPCClass == null) {
            throw new IllegalStateException(("received unknown NPCClass: " + this.npcClass).toString());
        }
        entity.setNpc(nPCClass);
        if (!Intrinsics.areEqual((Object)entity.getResourceIdentifier(), (Object)this.resourceIdentifier)) {
            entity.setForcedResourceIdentifier(this.resourceIdentifier);
        }
        entity.setCustomName(this.name);
        entity.getEntityData().set(NPCEntity.Companion.getLEVEL(), (Object)this.level);
        entity.getEntityData().set(NPCEntity.Companion.getBATTLE_IDS(), (Object)CollectionsKt.toMutableSet((Iterable)this.battleIds));
        entity.getEntityData().set(NPCEntity.Companion.getASPECTS(), this.aspects);
        entity.getEntityData().set(NPCEntity.Companion.getPOSE_TYPE(), (Object)this.poseType);
        entity.getEntityData().set(NPCEntity.Companion.getNPC_PLAYER_TEXTURE(), (Object)this.texture);
        entity.getEntityData().set(NPCEntity.Companion.getHIDE_NAME_TAG(), (Object)this.hideNameTag);
        entity.setHitboxWidth(this.hitboxWidth);
        entity.setHitboxHeight(this.hitboxHeight);
        entity.setHitboxEyesHeight(this.hitboxEyesHeight);
        entity.setHitboxScale(this.hitboxScale);
        entity.setRenderScale(this.renderScale);
    }

    @Override
    public boolean checkType(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity instanceof NPCEntity;
    }

    private static final Unit encodeEntityData$lambda$0(FriendlyByteBuf pb, String value) {
        Intrinsics.checkNotNull((Object)pb);
        ByteBuf byteBuf = (ByteBuf)pb;
        Intrinsics.checkNotNull((Object)value);
        BufferUtilsKt.writeString(byteBuf, value);
        return Unit.INSTANCE;
    }

    private static final void encodeEntityData$lambda$1(Function2 $tmp0, Object object, String object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encodeEntityData$lambda$2(FriendlyByteBuf pb, UUID value) {
        pb.writeUUID(value);
        return Unit.INSTANCE;
    }

    private static final void encodeEntityData$lambda$3(Function2 $tmp0, Object object, UUID object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/spawn/SpawnNPCPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "Lcom/cobblemon/mod/common/net/messages/client/spawn/SpawnNPCPacket;", "decode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)Lcom/cobblemon/mod/common/net/messages/client/spawn/SpawnNPCPacket;", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public final SpawnNPCPacket decode(@NotNull RegistryFriendlyByteBuf buffer) {
            NPCPlayerTexture nPCPlayerTexture;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            ResourceLocation npc = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            ResourceLocation resourceIdentifier = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
            List list = buffer.readList(arg_0 -> Companion.decode$lambda$1(arg_0 -> Companion.decode$lambda$0(buffer, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
            Set aspects2 = CollectionsKt.toSet((Iterable)list);
            int level = buffer.readInt();
            List list2 = buffer.readList(arg_0 -> Companion.decode$lambda$3(arg_0 -> Companion.decode$lambda$2(buffer, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readList(...)");
            Set battleIds = CollectionsKt.toSet((Iterable)list2);
            Component name = BufferUtilsKt.readText(buffer);
            PoseType poseType = BufferUtilsKt.readEnumConstant((ByteBuf)buffer, PoseType.class);
            NPCPlayerModelType model = BufferUtilsKt.readEnumConstant((ByteBuf)buffer, NPCPlayerModelType.class);
            if (model != NPCPlayerModelType.NONE) {
                byte[] byArray = buffer.readByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readByteArray(...)");
                nPCPlayerTexture = new NPCPlayerTexture(byArray, model);
            } else {
                nPCPlayerTexture = new NPCPlayerTexture(new byte[0], model);
            }
            NPCPlayerTexture texture = nPCPlayerTexture;
            boolean hideNameTag = buffer.readBoolean();
            float hitboxWidth = buffer.readFloat();
            float hitboxHeight = buffer.readFloat();
            float hitboxEyesHeight = buffer.readFloat();
            float hitboxScale = buffer.readFloat();
            float renderScale = buffer.readFloat();
            ClientboundAddEntityPacket vanillaPacket = SpawnExtraDataEntityPacket.Companion.decodeVanillaPacket(buffer);
            return new SpawnNPCPacket(npc, resourceIdentifier, aspects2, level, battleIds, name, poseType, texture, hideNameTag, hitboxWidth, hitboxHeight, hitboxEyesHeight, hitboxScale, renderScale, vanillaPacket);
        }

        private static final String decode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
            return BufferUtilsKt.readString((ByteBuf)$buffer);
        }

        private static final String decode$lambda$1(Function1 $tmp0, Object object) {
            return (String)$tmp0.invoke(object);
        }

        private static final UUID decode$lambda$2(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
            return $buffer.readUUID();
        }

        private static final UUID decode$lambda$3(Function1 $tmp0, Object object) {
            return (UUID)$tmp0.invoke(object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

