/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.net.messages.client.npc.dto;

import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.net.Decodable;
import com.cobblemon.mod.common.api.net.Encodable;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.api.npc.configuration.NPCBattleConfiguration;
import com.cobblemon.mod.common.api.npc.configuration.NPCInteractConfiguration;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.net.messages.client.npc.dto.NPCConfigurationDTO;
import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0007R\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R$\u0010)\u001a\u0004\u0018\u00010(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u00100\u001a\u00020/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R$\u00107\u001a\u0004\u0018\u0001068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R(\u0010?\u001a\b\u0012\u0004\u0012\u00020>0=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR(\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001e0=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010@\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR(\u0010J\u001a\b\u0012\u0004\u0012\u00020I0H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR.\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020>0P8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010V\u00a8\u0006W"}, d2={"Lcom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO;", "Lcom/cobblemon/mod/common/api/net/Encodable;", "Lcom/cobblemon/mod/common/api/net/Decodable;", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/npc/NPCEntity;", "npcEntity", "(Lcom/cobblemon/mod/common/entity/npc/NPCEntity;)V", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "decode", "entity", "apply", "Ljava/util/UUID;", "npcUUID", "Ljava/util/UUID;", "getNpcUUID", "()Ljava/util/UUID;", "setNpcUUID", "(Ljava/util/UUID;)V", "Lnet/minecraft/network/chat/MutableComponent;", "npcName", "Lnet/minecraft/network/chat/MutableComponent;", "getNpcName", "()Lnet/minecraft/network/chat/MutableComponent;", "setNpcName", "(Lnet/minecraft/network/chat/MutableComponent;)V", "Lnet/minecraft/resources/ResourceLocation;", "npcClass", "Lnet/minecraft/resources/ResourceLocation;", "getNpcClass", "()Lnet/minecraft/resources/ResourceLocation;", "setNpcClass", "(Lnet/minecraft/resources/ResourceLocation;)V", "resourceIdentifier", "getResourceIdentifier", "setResourceIdentifier", "Lcom/cobblemon/mod/common/api/npc/configuration/NPCBattleConfiguration;", "battle", "Lcom/cobblemon/mod/common/api/npc/configuration/NPCBattleConfiguration;", "getBattle", "()Lcom/cobblemon/mod/common/api/npc/configuration/NPCBattleConfiguration;", "setBattle", "(Lcom/cobblemon/mod/common/api/npc/configuration/NPCBattleConfiguration;)V", "", "interactionInherited", "Z", "getInteractionInherited", "()Z", "setInteractionInherited", "(Z)V", "Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;", "interaction", "Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;", "getInteraction", "()Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;", "setInteraction", "(Lcom/cobblemon/mod/common/api/npc/configuration/NPCInteractConfiguration;)V", "", "", "aspects", "Ljava/util/Set;", "getAspects", "()Ljava/util/Set;", "setAspects", "(Ljava/util/Set;)V", "behaviours", "getBehaviours", "setBehaviours", "", "Lcom/cobblemon/mod/common/api/npc/configuration/MoLangConfigVariable;", "registeredVariables", "Ljava/util/List;", "getRegisteredVariables", "()Ljava/util/List;", "setRegisteredVariables", "(Ljava/util/List;)V", "", "variables", "Ljava/util/Map;", "getVariables", "()Ljava/util/Map;", "setVariables", "(Ljava/util/Map;)V", "common"})
@SourceDebugExtension(value={"SMAP\nNPCConfigurationDTO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCConfigurationDTO.kt\ncom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n126#2:124\n153#2,3:125\n216#2:128\n217#2:130\n1#3:129\n*S KotlinDebug\n*F\n+ 1 NPCConfigurationDTO.kt\ncom/cobblemon/mod/common/net/messages/client/npc/dto/NPCConfigurationDTO\n*L\n59#1:124\n59#1:125,3\n117#1:128\n117#1:130\n*E\n"})
public final class NPCConfigurationDTO
implements Encodable,
Decodable {
    @NotNull
    private UUID npcUUID;
    @NotNull
    private MutableComponent npcName;
    @NotNull
    private ResourceLocation npcClass;
    @NotNull
    private ResourceLocation resourceIdentifier;
    @Nullable
    private NPCBattleConfiguration battle;
    private boolean interactionInherited;
    @Nullable
    private NPCInteractConfiguration interaction;
    @NotNull
    private Set<String> aspects;
    @NotNull
    private Set<ResourceLocation> behaviours;
    @NotNull
    private List<MoLangConfigVariable> registeredVariables;
    @NotNull
    private Map<String, String> variables;

    @NotNull
    public final UUID getNpcUUID() {
        return this.npcUUID;
    }

    public final void setNpcUUID(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.npcUUID = uUID;
    }

    @NotNull
    public final MutableComponent getNpcName() {
        return this.npcName;
    }

    public final void setNpcName(@NotNull MutableComponent mutableComponent) {
        Intrinsics.checkNotNullParameter((Object)mutableComponent, (String)"<set-?>");
        this.npcName = mutableComponent;
    }

    @NotNull
    public final ResourceLocation getNpcClass() {
        return this.npcClass;
    }

    public final void setNpcClass(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.npcClass = resourceLocation;
    }

    @NotNull
    public final ResourceLocation getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final void setResourceIdentifier(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.resourceIdentifier = resourceLocation;
    }

    @Nullable
    public final NPCBattleConfiguration getBattle() {
        return this.battle;
    }

    public final void setBattle(@Nullable NPCBattleConfiguration nPCBattleConfiguration) {
        this.battle = nPCBattleConfiguration;
    }

    public final boolean getInteractionInherited() {
        return this.interactionInherited;
    }

    public final void setInteractionInherited(boolean bl) {
        this.interactionInherited = bl;
    }

    @Nullable
    public final NPCInteractConfiguration getInteraction() {
        return this.interaction;
    }

    public final void setInteraction(@Nullable NPCInteractConfiguration nPCInteractConfiguration) {
        this.interaction = nPCInteractConfiguration;
    }

    @NotNull
    public final Set<String> getAspects() {
        return this.aspects;
    }

    public final void setAspects(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.aspects = set;
    }

    @NotNull
    public final Set<ResourceLocation> getBehaviours() {
        return this.behaviours;
    }

    public final void setBehaviours(@NotNull Set<ResourceLocation> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.behaviours = set;
    }

    @NotNull
    public final List<MoLangConfigVariable> getRegisteredVariables() {
        return this.registeredVariables;
    }

    public final void setRegisteredVariables(@NotNull List<MoLangConfigVariable> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.registeredVariables = list;
    }

    @NotNull
    public final Map<String, String> getVariables() {
        return this.variables;
    }

    public final void setVariables(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.variables = map;
    }

    public NPCConfigurationDTO() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.npcUUID = uUID;
        this.npcName = TextKt.text("");
        this.resourceIdentifier = this.npcClass = MiscUtilsKt.cobblemonResource("default");
        this.aspects = new LinkedHashSet();
        this.behaviours = new LinkedHashSet();
        this.registeredVariables = new ArrayList();
        this.variables = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public NPCConfigurationDTO(@NotNull NPCEntity npcEntity) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)npcEntity, (String)"npcEntity");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.npcUUID = uUID;
        this.npcName = TextKt.text("");
        this.resourceIdentifier = this.npcClass = MiscUtilsKt.cobblemonResource("default");
        this.aspects = new LinkedHashSet();
        this.behaviours = new LinkedHashSet();
        this.registeredVariables = new ArrayList();
        this.variables = new LinkedHashMap();
        UUID uUID2 = npcEntity.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        this.npcUUID = uUID2;
        MutableComponent mutableComponent = npcEntity.getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        this.npcName = mutableComponent;
        this.npcClass = npcEntity.getNpc().getId();
        this.resourceIdentifier = npcEntity.getResourceIdentifier();
        this.battle = npcEntity.getBattle();
        this.interactionInherited = npcEntity.getInteraction() == null;
        NPCInteractConfiguration nPCInteractConfiguration = npcEntity.getInteraction();
        if (nPCInteractConfiguration == null) {
            nPCInteractConfiguration = npcEntity.getNpc().getInteraction();
        }
        this.interaction = nPCInteractConfiguration;
        this.aspects = npcEntity.getAppliedAspects();
        this.behaviours = CollectionsKt.toMutableSet((Iterable)npcEntity.getBehaviours());
        this.registeredVariables = CollectionsKt.toMutableList((Collection)npcEntity.getRegisteredVariables());
        Map<String, MoValue> map = npcEntity.getConfig().getMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMap(...)");
        Map<String, MoValue> map2 = map;
        NPCConfigurationDTO nPCConfigurationDTO = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)((MoValue)it.getValue()).asString()));
        }
        nPCConfigurationDTO.variables = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeUUID(this.npcUUID);
        BufferUtilsKt.writeText(buffer, (Component)this.npcName);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.npcClass);
        BufferUtilsKt.writeIdentifier((ByteBuf)buffer, this.resourceIdentifier);
        buffer.writeNullable((Object)this.battle, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$1((arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$0(buffer, arg_0, arg_1), arg_0, arg_1));
        buffer.writeBoolean(this.interactionInherited);
        buffer.writeNullable((Object)this.interaction, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$3((arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$2(buffer, arg_0, arg_1), arg_0, arg_1));
        buffer.writeCollection((Collection)this.aspects, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$4(encode.3.INSTANCE, arg_0, arg_1));
        buffer.writeCollection((Collection)this.behaviours, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$5(encode.4.INSTANCE, arg_0, arg_1));
        buffer.writeCollection((Collection)this.registeredVariables, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$7((arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$6(buffer, arg_0, arg_1), arg_0, arg_1));
        buffer.writeMap(this.variables, (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$9((arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$8(buffer, arg_0, arg_1), arg_0, arg_1), (arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$11((arg_0, arg_1) -> NPCConfigurationDTO.encode$lambda$10(buffer, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void decode(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        UUID uUID = buffer.readUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"readUUID(...)");
        this.npcUUID = uUID;
        MutableComponent mutableComponent = BufferUtilsKt.readText(buffer).copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        this.npcName = mutableComponent;
        this.npcClass = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
        this.resourceIdentifier = BufferUtilsKt.readIdentifier((ByteBuf)buffer);
        this.battle = (NPCBattleConfiguration)buffer.readNullable(arg_0 -> NPCConfigurationDTO.decode$lambda$1(arg_0 -> NPCConfigurationDTO.decode$lambda$0(buffer, arg_0), arg_0));
        this.interactionInherited = buffer.readBoolean();
        this.interaction = (NPCInteractConfiguration)buffer.readNullable(arg_0 -> NPCConfigurationDTO.decode$lambda$3(arg_0 -> NPCConfigurationDTO.decode$lambda$2(buffer, arg_0), arg_0));
        List list = buffer.readList(arg_0 -> NPCConfigurationDTO.decode$lambda$5(arg_0 -> NPCConfigurationDTO.decode$lambda$4(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readList(...)");
        this.aspects = CollectionsKt.toMutableSet((Iterable)list);
        List list2 = buffer.readList(arg_0 -> NPCConfigurationDTO.decode$lambda$7(arg_0 -> NPCConfigurationDTO.decode$lambda$6(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"readList(...)");
        this.behaviours = CollectionsKt.toMutableSet((Iterable)list2);
        List list3 = buffer.readList(arg_0 -> NPCConfigurationDTO.decode$lambda$9(arg_0 -> NPCConfigurationDTO.decode$lambda$8(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"readList(...)");
        this.registeredVariables = CollectionsKt.toMutableList((Collection)list3);
        Map map = buffer.readMap(arg_0 -> NPCConfigurationDTO.decode$lambda$11(arg_0 -> NPCConfigurationDTO.decode$lambda$10(buffer, arg_0), arg_0), arg_0 -> NPCConfigurationDTO.decode$lambda$13(arg_0 -> NPCConfigurationDTO.decode$lambda$12(buffer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"readMap(...)");
        this.variables = MapsKt.toMutableMap((Map)map);
    }

    public final void apply(@NotNull NPCEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NPCClass nPCClass = NPCClasses.getByIdentifier(this.npcClass);
        if (nPCClass == null) {
            Cobblemon.LOGGER.error("Failed to apply NPC class " + this.npcClass);
            return;
        }
        NPCClass npcClass = nPCClass;
        entity.setCustomName((Component)this.npcName.copy());
        entity.setNpc(npcClass);
        entity.setBattle(this.battle);
        if (!this.interactionInherited) {
            entity.setInteraction(this.interaction);
        } else {
            entity.setInteraction(null);
        }
        entity.getAppliedAspects().clear();
        entity.getAppliedAspects().addAll((Collection<String>)this.aspects);
        entity.updateAspects();
        Map<String, String> $this$forEach$iv = this.variables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            MoLangConfigVariable variable;
            Object v1;
            String value;
            String key;
            block5: {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                key = entry.getKey();
                value = entry.getValue();
                Iterable iterable = entity.getRegisteredVariables();
                for (Object t : iterable) {
                    MoLangConfigVariable it = (MoLangConfigVariable)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariableName(), (Object)key)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            if ((MoLangConfigVariable)v1 == null) continue;
            entity.getConfig().setDirectly(key, variable.getType().toMoValue(value));
        }
        entity.remakeBrain();
    }

    private static final Unit encode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, NPCBattleConfiguration value) {
        value.encode($buffer);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$1(Function2 $tmp0, Object object, NPCBattleConfiguration object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$2(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, NPCInteractConfiguration value) {
        BufferUtilsKt.writeString((ByteBuf)$buffer, value.getType());
        value.encode($buffer);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$3(Function2 $tmp0, Object object, NPCInteractConfiguration object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final void encode$lambda$4(Function2 $tmp0, Object object, String object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final void encode$lambda$5(Function2 $tmp0, Object object, ResourceLocation object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$6(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, MoLangConfigVariable it) {
        it.encode($buffer);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$7(Function2 $tmp0, Object object, MoLangConfigVariable object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$8(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, String it) {
        ByteBuf byteBuf = (ByteBuf)$buffer;
        Intrinsics.checkNotNull((Object)it);
        BufferUtilsKt.writeString(byteBuf, it);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$9(Function2 $tmp0, Object object, String object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final Unit encode$lambda$10(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf friendlyByteBuf, String it) {
        ByteBuf byteBuf = (ByteBuf)$buffer;
        Intrinsics.checkNotNull((Object)it);
        BufferUtilsKt.writeString(byteBuf, it);
        return Unit.INSTANCE;
    }

    private static final void encode$lambda$11(Function2 $tmp0, Object object, String object2) {
        $tmp0.invoke(object, (Object)object2);
    }

    private static final NPCBattleConfiguration decode$lambda$0(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        NPCBattleConfiguration nPCBattleConfiguration;
        NPCBattleConfiguration $this$decode_u24lambda_u240_u240 = nPCBattleConfiguration = new NPCBattleConfiguration();
        boolean bl = false;
        $this$decode_u24lambda_u240_u240.decode($buffer);
        return nPCBattleConfiguration;
    }

    private static final NPCBattleConfiguration decode$lambda$1(Function1 $tmp0, Object object) {
        return (NPCBattleConfiguration)$tmp0.invoke(object);
    }

    private static final NPCInteractConfiguration decode$lambda$2(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        NPCInteractConfiguration nPCInteractConfiguration;
        String type = BufferUtilsKt.readString((ByteBuf)$buffer);
        NPCInteractConfiguration.NPCInteractConfigurationType<? extends NPCInteractConfiguration> nPCInteractConfigurationType = NPCInteractConfiguration.Companion.getTypes().get(type);
        if (nPCInteractConfigurationType == null) {
            return null;
        }
        NPCInteractConfiguration.NPCInteractConfigurationType<? extends NPCInteractConfiguration> configType = nPCInteractConfigurationType;
        NPCInteractConfiguration it2 = nPCInteractConfiguration = configType.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
        boolean bl = false;
        it2.decode($buffer);
        return nPCInteractConfiguration;
    }

    private static final NPCInteractConfiguration decode$lambda$3(Function1 $tmp0, Object object) {
        return (NPCInteractConfiguration)$tmp0.invoke(object);
    }

    private static final String decode$lambda$4(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readString((ByteBuf)$buffer);
    }

    private static final String decode$lambda$5(Function1 $tmp0, Object object) {
        return (String)$tmp0.invoke(object);
    }

    private static final ResourceLocation decode$lambda$6(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readIdentifier((ByteBuf)$buffer);
    }

    private static final ResourceLocation decode$lambda$7(Function1 $tmp0, Object object) {
        return (ResourceLocation)$tmp0.invoke(object);
    }

    private static final MoLangConfigVariable decode$lambda$8(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return MoLangConfigVariable.Companion.decode($buffer);
    }

    private static final MoLangConfigVariable decode$lambda$9(Function1 $tmp0, Object object) {
        return (MoLangConfigVariable)$tmp0.invoke(object);
    }

    private static final String decode$lambda$10(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readString((ByteBuf)$buffer);
    }

    private static final String decode$lambda$11(Function1 $tmp0, Object object) {
        return (String)$tmp0.invoke(object);
    }

    private static final String decode$lambda$12(RegistryFriendlyByteBuf $buffer, FriendlyByteBuf it) {
        return BufferUtilsKt.readString((ByteBuf)$buffer);
    }

    private static final String decode$lambda$13(Function1 $tmp0, Object object) {
        return (String)$tmp0.invoke(object);
    }
}

