/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.DoubleJump;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.Seat;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.orientation.ServerboundUpdateOrientationPacket;
import com.cobblemon.mod.common.net.messages.server.riding.ServerboundUpdateDriverInputPacket;
import com.cobblemon.mod.common.net.messages.server.riding.ServerboundUpdateRiderRotationPacket;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer
implements OrientationControllable,
DoubleJump {
    @Unique
    Matrix3f cobblemon$lastOrientation;
    @Unique
    float cobblemon$lastRideXRot;
    @Unique
    float cobblemon$lastRideYRot;
    @Unique
    Vec3 cobblemon$lastRideEyePos;
    @Unique
    boolean cobblemon$isDoubleJumping = false;
    @Shadow
    private float jumpRidingScale;
    @Shadow
    public Input input;
    @Shadow
    private int autoJumpTime;
    @Unique
    private int cobblemon$survivalJumpTriggerTime;
    @Unique
    private boolean cobblemon$isJumping;

    public LocalPlayerMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")})
    private void cobblemon$updateRotationMatrixPassenger(CallbackInfo ci) {
        Entity entity = this.getVehicle();
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)entity;
        OrientationController vehicleController = controllableVehicle.getOrientationController();
        if (!vehicleController.isActive() || vehicleController.getOrientation() == this.cobblemon$lastOrientation) {
            return;
        }
        this.cobblemon$lastOrientation = vehicleController.getOrientation() != null ? new Matrix3f((Matrix3fc)vehicleController.getOrientation()) : null;
        CobblemonNetwork.sendToServer(new ServerboundUpdateOrientationPacket(this.getVehicle().getId(), vehicleController.getOrientation()));
    }

    @Inject(method={"rideTick()V"}, at={@At(value="HEAD")})
    private void cobblemon$updateOrientationControllerRideTick(CallbackInfo ci) {
        if (Minecraft.getInstance().player != this) {
            return;
        }
        LocalPlayer driver = (LocalPlayer)this;
        Entity vehicle = driver.getVehicle();
        Entity entity = this.getVehicle();
        if (!(entity instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllableVehicle = (OrientationControllable)entity;
        boolean shouldUseCustomOrientation = this.cobblemon$shouldUseCustomOrientation((LocalPlayer)this);
        OrientationController vehicleController = controllableVehicle.getOrientationController();
        if (!vehicleController.isActive() && shouldUseCustomOrientation) {
            RidePassenger playerRotater = (RidePassenger)driver;
            playerRotater.cobblemon$setRideXRot(Mth.wrapDegrees((float)(driver.getXRot() - vehicle.getXRot())));
            playerRotater.cobblemon$setRideYRot(Mth.wrapDegrees((float)(driver.getYRot() - vehicle.getYRot())));
        }
        vehicleController.setActive(shouldUseCustomOrientation);
    }

    @Inject(method={"rideTick()V"}, at={@At(value="HEAD")})
    private void cobblemon$updateDriverInputRideTick(CallbackInfo ci) {
        if (Minecraft.getInstance().player != this) {
            return;
        }
        Entity entity = this.getVehicle();
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        float vertInput = this.jumping ? 1.0f : (this.isShiftKeyDown() ? -1.0f : 0.0f);
        Vector3f driverInput = new Vector3f(Math.signum(this.xxa), vertInput, Math.signum(this.zza));
        Vector3f lastSentDriverInput = ((PlayerDuck)((Object)this)).getLastSentDriverInput();
        if (driverInput.equals((Object)lastSentDriverInput)) {
            return;
        }
        ((PlayerDuck)((Object)this)).setLastSentDriverInput(driverInput);
        CobblemonNetwork.sendToServer(new ServerboundUpdateDriverInputPacket(driverInput));
    }

    @Inject(method={"rideTick()V"}, at={@At(value="HEAD")})
    private void cobblemon$updateRiderRotationsRideTick(CallbackInfo ci) {
        if (Minecraft.getInstance().player != this) {
            return;
        }
        Entity entity = this.getVehicle();
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        LocalPlayer passenger = (LocalPlayer)this;
        RidePassenger playerRotater = (RidePassenger)passenger;
        float rideXRot = playerRotater.cobblemon$getRideXRot();
        float rideYRot = playerRotater.cobblemon$getRideYRot();
        Vec3 rideEyePos = playerRotater.cobblemon$getRideEyePos();
        if (this.cobblemon$lastRideXRot != rideXRot || this.cobblemon$lastRideYRot != rideYRot || this.cobblemon$lastRideEyePos != rideEyePos) {
            this.cobblemon$lastRideXRot = rideXRot;
            this.cobblemon$lastRideYRot = rideYRot;
            this.cobblemon$lastRideEyePos = rideEyePos;
            CobblemonNetwork.sendToServer(new ServerboundUpdateRiderRotationPacket(rideXRot, rideYRot, rideEyePos));
        }
    }

    @Unique
    private boolean cobblemon$shouldUseCustomOrientation(LocalPlayer player) {
        Entity playerVehicle = player.getVehicle();
        if (playerVehicle == null) {
            return false;
        }
        if (!(playerVehicle instanceof PokemonEntity)) {
            return false;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)playerVehicle;
        return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.shouldRoll(settings, state, pokemonEntity));
    }

    public void stopRiding() {
        super.stopRiding();
        if (Minecraft.getInstance().player != this) {
            return;
        }
        LocalPlayerMixin localPlayerMixin = this;
        if (!(localPlayerMixin instanceof OrientationControllable)) {
            return;
        }
        LocalPlayerMixin controllableVehicle = localPlayerMixin;
        controllableVehicle.getOrientationController().setActive(false);
    }

    @Inject(method={"getJumpRidingScale()F"}, at={@At(value="HEAD")}, cancellable=true)
    public void modifyJumpRidingScale(CallbackInfoReturnable<Float> cir) {
        PokemonEntity pokemonEntity;
        Float rideValue;
        Entity entity;
        LocalPlayer player = (LocalPlayer)this;
        if (player.isPassenger() && (entity = player.getVehicle()) instanceof PokemonEntity && (rideValue = (Float)(pokemonEntity = (PokemonEntity)entity).ifRidingAvailableSupply(null, (behaviour, settings, state) -> {
            if (behaviour.canJump(settings, state, pokemonEntity, (Player)player)) {
                return null;
            }
            return Float.valueOf(behaviour.setRideBar(settings, state, pokemonEntity, (Player)player));
        })) != null) {
            cir.setReturnValue((Object)rideValue);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    private void cobblemon$aiStep(CallbackInfo ci) {
        this.cobblemon$isDoubleJumping = false;
        this.cobblemon$isJumping = this.input.jumping;
    }

    @Inject(method={"aiStep()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSprinting()Z", shift=At.Shift.BEFORE)})
    private void cobblemon$updateDoubleJumping(CallbackInfo ci) {
        if (!this.cobblemon$isJumping && this.input.jumping && this.autoJumpTime <= 0 && !this.isSwimming()) {
            if (this.cobblemon$survivalJumpTriggerTime != 0) {
                this.cobblemon$isDoubleJumping = true;
                this.cobblemon$survivalJumpTriggerTime = 0;
            } else {
                this.cobblemon$survivalJumpTriggerTime = 12;
            }
        } else if (this.cobblemon$survivalJumpTriggerTime > 0) {
            --this.cobblemon$survivalJumpTriggerTime;
        }
    }

    @Override
    public boolean isDoubleJumping() {
        return this.cobblemon$isDoubleJumping;
    }

    @Inject(method={"isHandsBusy()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$isHandsBusy(CallbackInfoReturnable<Boolean> cir) {
        Entity vehicle = this.getVehicle();
        if (vehicle instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
            int seatIndex = pokemonEntity.getPassengers().indexOf(this);
            Seat seat = pokemonEntity.getSeats().get(seatIndex);
            cir.setReturnValue((Object)seat.getHandsBusy());
        }
    }

    public HitResult pick(double hitDistance, float partialTicks, boolean hitFluids) {
        Entity vehicle = this.getVehicle();
        if (vehicle instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)vehicle;
            LocalPlayer passenger = (LocalPlayer)this;
            RidePassenger playerRotater = (RidePassenger)passenger;
            Vec3 eyePosition = playerRotater.cobblemon$getRideEyePos();
            Vec3 viewVector = this.getViewVector(partialTicks);
            Vec3 viewDistanceVector = eyePosition.add(viewVector.x * hitDistance, viewVector.y * hitDistance, viewVector.z * hitDistance);
            return this.level().clip(new ClipContext(eyePosition, viewDistanceVector, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this));
        }
        return super.pick(hitDistance, partialTicks, hitFluids);
    }

    @Unique
    @NotNull
    private static Vector3f cobblemon$getFirstPersonOffset(PosableModel model, String locatorName) {
        Map<String, Vec3> cameraOffsets = model.getFirstPersonCameraOffset();
        if (cameraOffsets.containsKey(locatorName)) {
            return cameraOffsets.get(locatorName).toVector3f();
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

