/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.client;

import com.cobblemon.mod.common.CobblemonRecipeCategories;
import com.cobblemon.mod.common.item.crafting.CookingPotBookCategory;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientRecipeBook.class})
public abstract class ClientRecipeBookMixin {
    @Shadow
    private Map<RecipeBookCategories, List<RecipeCollection>> collectionsByTab;
    @Shadow
    private List<RecipeCollection> allCollections;

    @Shadow
    protected static Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> categorizeAndGroupRecipes(Iterable<RecipeHolder<?>> recipes) {
        return null;
    }

    @Inject(method={"getCategory(Lnet/minecraft/world/item/crafting/RecipeHolder;)Lnet/minecraft/client/RecipeBookCategories;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addCustomCategory(RecipeHolder<?> recipe, CallbackInfoReturnable<RecipeBookCategories> cir) {
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof CookingPotRecipeBase) {
            CookingPotBookCategory category = ((CookingPotRecipeBase)recipe2).getCategory();
            cir.setReturnValue((Object)(switch (category) {
                case CookingPotBookCategory.MISC -> CobblemonRecipeCategories.COOKING_POT_MISC.toVanillaCategory();
                case CookingPotBookCategory.FOODS -> CobblemonRecipeCategories.COOKING_POT_FOODS.toVanillaCategory();
                case CookingPotBookCategory.MEDICINES -> CobblemonRecipeCategories.COOKING_POT_MEDICINES.toVanillaCategory();
                case CookingPotBookCategory.COMPLEX_DISHES -> CobblemonRecipeCategories.COOKING_POT_COMPLEX_DISHES.toVanillaCategory();
                default -> throw new MatchException(null, null);
            }));
        }
    }

    @Inject(method={"setupCollections(Ljava/lang/Iterable;Lnet/minecraft/core/RegistryAccess;)V"}, at={@At(value="RETURN")})
    private void addCustomAggregateCategories(Iterable<RecipeHolder<?>> recipes, RegistryAccess registryAccess, CallbackInfo ci) {
        Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> map = ClientRecipeBookMixin.categorizeAndGroupRecipes(recipes);
        HashMap map2 = Maps.newHashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((recipeBookCategories, list) -> {
            List collections = (List)list.stream().map(listx -> new RecipeCollection(registryAccess, listx)).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList());
            map2.put(recipeBookCategories, collections);
        });
        RecipeBookCategories.AGGREGATE_CATEGORIES.forEach((recipeBookCategories, list) -> map2.put(recipeBookCategories, (List)list.stream().flatMap(recipeBookCategoriesx -> ((List)map2.getOrDefault(recipeBookCategoriesx, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        CobblemonRecipeCategories.Companion.getCustomAggregateCategories().forEach((recipeBookCategories, list) -> map2.put(recipeBookCategories, (List)list.stream().flatMap(recipeBookCategoriesx -> ((List)map2.getOrDefault(recipeBookCategoriesx, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.collectionsByTab = ImmutableMap.copyOf((Map)map2);
        this.allCollections = builder.build();
    }
}

