/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin.brewing;

import com.cobblemon.mod.common.CobblemonRecipeTypes;
import com.cobblemon.mod.common.item.crafting.brewingstand.BrewingStandInput;
import com.cobblemon.mod.common.item.crafting.brewingstand.BrewingStandRecipe;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrewingStandBlockEntity.class})
public class BrewingStandBlockEntityMixin {
    @WrapOperation(method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;doBrew(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/NonNullList;)V")})
    private static void cobblemon$doBrew(Level level, BlockPos pos, NonNullList<ItemStack> slots, Operation<Void> original) {
        BrewingStandRecipe recipe = BrewingStandBlockEntityMixin.cobblemon$fetchBrewingRecipe(slots, level);
        if (recipe == null) {
            original.call(new Object[]{level, pos, slots});
            return;
        }
        ItemStack itemStack = (ItemStack)slots.get(3);
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)slots.get(i)).isEmpty()) continue;
            slots.set(i, (Object)recipe.getResult().copy());
        }
        itemStack.shrink(1);
        if (itemStack.getItem().hasCraftingRemainingItem()) {
            ItemStack itemStack2 = new ItemStack((ItemLike)itemStack.getItem().getCraftingRemainingItem());
            if (itemStack.isEmpty()) {
                itemStack = itemStack2;
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)itemStack2);
            }
        }
        slots.set(3, (Object)itemStack);
        level.levelEvent(1035, pos, 0);
    }

    @WrapOperation(method={"serverTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrewingStandBlockEntity;isBrewable(Lnet/minecraft/world/item/alchemy/PotionBrewing;Lnet/minecraft/core/NonNullList;)Z")})
    private static boolean cobblemon$isBrewable(PotionBrewing potionBrewing, NonNullList<ItemStack> items, Operation<Boolean> original, @Local(argsOnly=true) Level level) {
        return BrewingStandBlockEntityMixin.cobblemon$fetchBrewingRecipe(items, level) != null || (Boolean)original.call(new Object[]{potionBrewing, items}) != false;
    }

    @Unique
    private static BrewingStandRecipe cobblemon$fetchBrewingRecipe(NonNullList<ItemStack> items, Level level) {
        ItemStack ingredient = (ItemStack)items.get(3);
        List bottles = items.subList(0, 3);
        boolean allBottlesEmpty = true;
        for (ItemStack bottle : bottles) {
            if (bottle.isEmpty()) continue;
            allBottlesEmpty = false;
            break;
        }
        if (ingredient.isEmpty() || allBottlesEmpty) {
            return null;
        }
        BrewingStandInput input = new BrewingStandInput(ingredient, bottles);
        RecipeManager recipeManager = level.getRecipeManager();
        Optional recipeHolder = recipeManager.getRecipeFor(CobblemonRecipeTypes.INSTANCE.getBREWING_STAND(), (RecipeInput)input, level);
        return recipeHolder.map(RecipeHolder::value).orElse(null);
    }

    @Inject(method={"canPlaceItem(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$canPlaceItem(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        BrewingStandBlockEntity self = (BrewingStandBlockEntity)this;
        Level level = self.getLevel();
        if (level != null) {
            RecipeManager rm = level.getRecipeManager();
            if (slot == 3 && BrewingStandRecipe.Companion.isInput(stack, rm)) {
                cir.setReturnValue((Object)true);
                return;
            }
            if (slot >= 0 && slot < 3 && BrewingStandRecipe.Companion.isBottle(stack, rm)) {
                if (self.getItem(slot).isEmpty()) {
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }
}

