/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.CobblemonVillagerProfessions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import kotlin.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderLayer.class})
public abstract class VillagerProfessionLayerMixin {
    @Inject(method={"renderColoredCutoutModel(Lnet/minecraft/client/model/EntityModel;Lnet/minecraft/resources/ResourceLocation;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static <T extends LivingEntity> void cobblemon$renderVillagerProfessionLayer(EntityModel<T> entityModel, ResourceLocation resourceLocation, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, int j, CallbackInfo ci) {
        if (resourceLocation.getNamespace().equals("cobblemon")) {
            VillagerProfession profession = null;
            boolean isZombie = false;
            if (livingEntity instanceof Villager) {
                profession = ((Villager)livingEntity).getVillagerData().getProfession();
            }
            if (livingEntity instanceof ZombieVillager) {
                profession = ((ZombieVillager)livingEntity).getVillagerData().getProfession();
                isZombie = true;
            }
            Pair<String, String[]> override = CobblemonVillagerProfessions.INSTANCE.getNameTagOverride(profession);
            if (profession != null && override != null) {
                String entityName = ChatFormatting.stripFormatting((String)livingEntity.getName().getString());
                boolean nameMatches = false;
                for (String name : (String[])override.getSecond()) {
                    if (!entityName.endsWith(name)) continue;
                    nameMatches = true;
                    break;
                }
                if (nameMatches && resourceLocation.equals((Object)VillagerProfessionLayerMixin.getProfessionResourceLocation(resourceLocation.getNamespace(), ResourceLocation.parse((String)profession.name()).getPath(), isZombie))) {
                    ResourceLocation textureLocation = VillagerProfessionLayerMixin.getProfessionResourceLocation(resourceLocation.getNamespace(), (String)override.getFirst(), isZombie);
                    VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)textureLocation));
                    entityModel.renderToBuffer(poseStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords(livingEntity, (float)0.0f), j);
                    ci.cancel();
                }
            }
        }
    }

    private static ResourceLocation getProfessionResourceLocation(String namespace, String profession, Boolean isZombie) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/entity/" + (isZombie != false ? "zombie_villager" : "villager") + "/profession/" + profession + ".png"));
    }
}

