/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.client.sound.BattleMusicController;
import com.cobblemon.mod.common.duck.SoundEngineDuck;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.audio.Channel;
import java.util.Map;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements SoundEngineDuck {
    @Shadow
    private boolean loaded;
    @Shadow
    private Multimap<SoundSource, SoundInstance> instanceBySource;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;

    @Shadow
    protected abstract void stop(SoundInstance var1);

    @Shadow
    public abstract boolean isActive(SoundInstance var1);

    private void resume(SoundInstance sound) {
        ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(sound);
        if (this.loaded && sourceManager != null) {
            sourceManager.execute(Channel::unpause);
        }
    }

    private void pause(SoundInstance sound) {
        ChannelAccess.ChannelHandle sourceManager = this.instanceToChannel.get(sound);
        if (this.loaded && sourceManager != null) {
            sourceManager.execute(Channel::pause);
        }
    }

    @Override
    public void resumeSounds(@Nullable ResourceLocation id, @Nullable SoundSource category) {
        if (category != null) {
            this.instanceBySource.get((Object)category).forEach(sound -> {
                if (id == null || sound.getLocation().equals((Object)id)) {
                    this.resume((SoundInstance)sound);
                }
            });
        } else if (id == null) {
            this.instanceToChannel.keySet().forEach(this::resume);
        } else {
            this.instanceToChannel.keySet().forEach(sound -> {
                if (sound.getLocation().equals((Object)id)) {
                    this.resume((SoundInstance)sound);
                }
            });
        }
    }

    @Override
    public void pauseSounds(@Nullable ResourceLocation id, @Nullable SoundSource category) {
        if (category != null) {
            this.instanceBySource.get((Object)category).forEach(sound -> {
                if (id == null || sound.getLocation().equals((Object)id)) {
                    this.pause((SoundInstance)sound);
                }
            });
        } else if (id == null) {
            this.instanceToChannel.keySet().forEach(this::pause);
        } else {
            this.instanceToChannel.keySet().forEach(sound -> {
                if (sound.getLocation().equals((Object)id)) {
                    this.pause((SoundInstance)sound);
                }
            });
        }
    }

    @Inject(method={"stop(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void stopSounds(@Nullable ResourceLocation id, @Nullable SoundSource category, CallbackInfo cb) {
        if (id == null && category != null) {
            this.instanceBySource.get((Object)category).forEach(this::stop);
            cb.cancel();
        }
    }

    @Inject(method={"resume()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void resume(CallbackInfo cb) {
        if (this.isActive((SoundInstance)BattleMusicController.INSTANCE.getMusic())) {
            this.instanceBySource.values().forEach(sound -> {
                if (sound == BattleMusicController.INSTANCE.getMusic() || !BattleMusicController.INSTANCE.getFilteredCategories().contains(sound.getSource())) {
                    this.resume((SoundInstance)sound);
                }
            });
            cb.cancel();
        }
    }
}

