/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.item.LeftoversCreatedEvent;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.duck.RidePassenger;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokedex.scanner.PokedexEntityData;
import com.cobblemon.mod.common.pokedex.scanner.ScannableEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.CompoundTagExtensionsKt;
import com.cobblemon.mod.common.util.CompoundTagUtilities;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements ScannableEntity,
OrientationControllable,
PlayerDuck,
RidePassenger {
    @Unique
    private Vector3f cobblemon$driverInput;
    @Unique
    private Vector3f cobblemon$lastSentDriverInput;
    @Shadow
    @Final
    private static Map<Pose, EntityDimensions> POSES;
    @Shadow
    @Final
    public static EntityDimensions STANDING_DIMENSIONS;
    @Shadow
    protected int jumpTriggerTime;
    @Unique
    private final OrientationController cobblemon$orientationController = new OrientationController(this);
    @Unique
    private float cobblemon$rideXRot = 0.0f;
    @Unique
    private float cobblemon$rideYRot = 0.0f;
    @Unique
    private Vec3 cobblemon$rideEyePos = Vec3.ZERO;

    @Shadow
    public abstract CompoundTag getShoulderEntityLeft();

    @Shadow
    public abstract CompoundTag getShoulderEntityRight();

    @Shadow
    public abstract void respawnEntityOnShoulder(CompoundTag var1);

    @Shadow
    public abstract void setShoulderEntityRight(CompoundTag var1);

    @Shadow
    public abstract void setShoulderEntityLeft(CompoundTag var1);

    @Shadow
    public abstract boolean isSpectator();

    @Shadow
    public abstract boolean addItem(ItemStack var1);

    @Shadow
    public abstract void displayClientMessage(Component var1, boolean var2);

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"respawnEntityOnShoulder(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;")}, cancellable=true)
    private void cobblemon$removePokemon(CompoundTag nbt, CallbackInfo ci) {
        if (CompoundTagExtensionsKt.isPokemonEntity(nbt)) {
            UUID uuidLeft;
            UUID uuidRight;
            UUID uuid = CompoundTagUtilities.getPokemonID(nbt);
            if (CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityRight()) && uuid.equals(uuidRight = CompoundTagUtilities.getPokemonID(this.getShoulderEntityRight()))) {
                this.recallPokemon(uuidRight);
                this.setShoulderEntityRight(new CompoundTag());
            }
            if (CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityLeft()) && uuid.equals(uuidLeft = CompoundTagUtilities.getPokemonID(this.getShoulderEntityLeft()))) {
                this.recallPokemon(uuidLeft);
                this.setShoulderEntityLeft(new CompoundTag());
            }
            ci.cancel();
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.getVehicle() instanceof PokemonEntity) {
            return STANDING_DIMENSIONS;
        }
        return POSES.getOrDefault(pose, STANDING_DIMENSIONS);
    }

    @Inject(method={"removeEntitiesOnShoulder()V"}, at={@At(value="JUMP", opcode=156, ordinal=0, shift=At.Shift.AFTER)}, cancellable=true)
    private void cobblemon$preventPokemonDropping(CallbackInfo ci) {
        if (this.isSpectator() || this.isDeadOrDying()) {
            return;
        }
        if (!CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityLeft())) {
            this.respawnEntityOnShoulder(this.getShoulderEntityLeft());
            this.setShoulderEntityLeft(new CompoundTag());
        }
        if (!CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityRight())) {
            this.respawnEntityOnShoulder(this.getShoulderEntityRight());
            this.setShoulderEntityRight(new CompoundTag());
        }
        ci.cancel();
    }

    private void recallPokemon(UUID uuid) {
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(this.getUUID(), this.registryAccess());
        for (Pokemon pokemon : party) {
            if (!pokemon.getUuid().equals(uuid)) continue;
            pokemon.recall();
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getFoodData()Lnet/minecraft/world/food/FoodData;", shift=At.Shift.AFTER)})
    public void onEatFood(Level world, ItemStack stack, FoodProperties foodComponent, CallbackInfoReturnable<ItemStack> cir) {
        if (!this.level().isClientSide && stack.is(CobblemonItemTags.LEAVES_LEFTOVERS) && this.level().random.nextDouble() < Cobblemon.config.getAppleLeftoversChance()) {
            ItemStack leftovers = new ItemStack((ItemLike)CobblemonItems.LEFTOVERS);
            ServerPlayer player = Objects.requireNonNull(this.getServer()).getPlayerList().getPlayer(this.uuid);
            assert (player != null);
            CobblemonEvents.LEFTOVERS_CREATED.postThen(new LeftoversCreatedEvent(player, leftovers), (Function1<LeftoversCreatedEvent, Unit>)((Function1)leftoversCreatedEvent -> null), (Function1<LeftoversCreatedEvent, Unit>)((Function1)leftoversCreatedEvent -> {
                if (!player.addItem(leftoversCreatedEvent.getLeftovers())) {
                    Vec3 itemPos = player.getLookAngle().scale(0.5).add(this.position());
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), itemPos.x(), itemPos.y(), itemPos.z(), leftoversCreatedEvent.getLeftovers()));
                }
                return null;
            }));
        }
    }

    @Inject(method={"isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInvulnerableTo(DamageSource source, CallbackInfoReturnable<Boolean> ci) {
        PlayerMixin playerMixin;
        if (!this.level().isClientSide && (playerMixin = this) instanceof ServerPlayer) {
            boolean inBattle;
            ServerPlayer player = (ServerPlayer)playerMixin;
            boolean invulnerableInBattle = this.level().getGameRules().getBoolean(CobblemonGameRules.BATTLE_INVULNERABILITY);
            Cobblemon.INSTANCE.getBattleRegistry();
            boolean bl = inBattle = BattleRegistry.getBattleByParticipatingPlayer(player) != null;
            if (invulnerableInBattle && inBattle) {
                ci.setReturnValue((Object)true);
            }
        }
    }

    @Override
    @Nullable
    public PokedexEntityData resolvePokemonScan() {
        if (CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityRight())) {
            return this.getDataFromShoulderPokemon(this.getShoulderEntityRight());
        }
        if (CompoundTagUtilities.isShoulderPokemon(this.getShoulderEntityLeft())) {
            return this.getDataFromShoulderPokemon(this.getShoulderEntityLeft());
        }
        return null;
    }

    @Unique
    @Nullable
    private PokedexEntityData getDataFromShoulderPokemon(CompoundTag shoulderTag) {
        Pokemon pokemon;
        if (this.level().isClientSide) {
            CompoundTag pokemonTag = shoulderTag.getCompound("Pokemon");
            if (pokemonTag.isEmpty()) {
                return null;
            }
            Species species = PokemonSpecies.getByIdentifier(ResourceLocation.parse((String)pokemonTag.getString("Species")));
            if (species == null) {
                return null;
            }
            String formId = pokemonTag.getString("FormId");
            FormData form = species.getStandardForm();
            List<FormData> formList = species.getForms().stream().filter(it -> it.formOnlyShowdownId().equals(formId)).toList();
            if (!formList.isEmpty()) {
                form = formList.getFirst();
            }
            if (form == null) {
                return null;
            }
            String genderString = pokemonTag.getString("Gender");
            if (genderString.isEmpty()) {
                return null;
            }
            Gender gender = Gender.valueOf(genderString);
            boolean shiny = pokemonTag.getBoolean("Shiny");
            int level = pokemonTag.getInt("Level");
            Set<String> aspects2 = shoulderTag.getList("shoulder_aspects", 8).stream().map(Tag::getAsString).collect(Collectors.toSet());
            pokemon = new Pokemon();
            pokemon.setSpecies(species);
            pokemon.setForm(form);
            pokemon.setGender(gender);
            pokemon.setShiny(shiny);
            pokemon.setLevel(level);
            pokemon.setForcedAspects(aspects2);
        } else {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(this.getUUID(), this.registryAccess());
            pokemon = party.get(shoulderTag.getUUID("shoulder_uuid"));
        }
        return pokemon == null ? null : new PokedexEntityData(pokemon, null);
    }

    @Override
    public LivingEntity resolveEntityScan() {
        return this;
    }

    public void absMoveTo(double x, double y, double z, float yaw, float pitch) {
        if (this.cobblemon$orientationController.getActive()) {
            this.absMoveTo(x, y, z);
            this.setYRot(yaw % 360.0f);
            this.setXRot(pitch % 360.0f);
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        } else {
            this.absMoveTo(x, y, z);
            this.absRotateTo(yaw, pitch);
        }
    }

    @WrapOperation(method={"rideTick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;wantsToStopRiding()Z")})
    public boolean delegateDismountToController(Player instance, Operation<Boolean> original) {
        Entity entity = this.getVehicle();
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            return pokemonEntity.ifRidingAvailableSupply(false, (behaviour, settings, state) -> behaviour.dismountOnShift(settings, state, pokemonEntity) && (Boolean)original.call(new Object[]{instance}) != false);
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Override
    public OrientationController getOrientationController() {
        return this.cobblemon$orientationController;
    }

    @Override
    public void setDriverInput(Vector3f driverInput) {
        this.cobblemon$driverInput = driverInput;
    }

    @Override
    public Vector3f getDriverInput() {
        return this.cobblemon$driverInput;
    }

    @Override
    public void setLastSentDriverInput(Vector3f lastSentDriverInput) {
        this.cobblemon$lastSentDriverInput = lastSentDriverInput;
    }

    @Override
    public Vector3f getLastSentDriverInput() {
        return this.cobblemon$lastSentDriverInput;
    }

    @Override
    public float cobblemon$getRideXRot() {
        return this.cobblemon$rideXRot;
    }

    @Override
    public void cobblemon$setRideXRot(float rideXRot) {
        this.cobblemon$rideXRot = Mth.wrapDegrees((float)rideXRot);
    }

    @Override
    public float cobblemon$getRideYRot() {
        return this.cobblemon$rideYRot;
    }

    @Override
    public void cobblemon$setRideYRot(float rideYRot) {
        this.cobblemon$rideYRot = Mth.wrapDegrees((float)rideYRot);
    }

    @Override
    public Vec3 cobblemon$getRideEyePos() {
        return this.cobblemon$rideEyePos;
    }

    @Override
    public void cobblemon$setRideEyePos(Vec3 rideEyePos) {
        this.cobblemon$rideEyePos = rideEyePos;
    }
}

