/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Comparator;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderpearlItem.class})
public abstract class EnderPearlItemMixin {
    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$use(Level level, Player player, InteractionHand usedHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        double range = player.entityInteractionRange();
        Entity closestEntity = level.getEntities((Entity)player, AABB.ofSize((Vec3)player.position(), (double)range, (double)range, (double)range)).stream().filter(entity -> this.isLookingAt(player, (Entity)entity)).min(Comparator.comparingDouble(entity -> entity.distanceTo((Entity)player))).orElse(null);
        if (closestEntity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)closestEntity;
            if (player.isCrouching() && pokemonEntity.getOwnerUUID() == player.getUUID()) {
                cir.cancel();
            }
        }
    }

    public boolean isLookingAt(Player player, Entity other) {
        float maxDistance = 10.0f;
        float stepDistance = 0.1f;
        Vec3 startPos = player.getEyePosition();
        Vec3 direction = player.getLookAngle();
        for (double step = (double)stepDistance; step <= (double)maxDistance; step += (double)stepDistance) {
            Vec3 location = startPos.add(direction.scale(step));
            if (!other.getBoundingBox().contains(location)) continue;
            return true;
        }
        return false;
    }
}

