/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.food;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.item.components.MobEffectsComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/item/food/SinisterTeaItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/LivingEntity;", "user", "finishUsingItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/UseAnim;", "getUseAnimation", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;", "Lnet/minecraft/sounds/SoundEvent;", "getDrinkingSound", "()Lnet/minecraft/sounds/SoundEvent;", "getEatingSound", "common"})
public final class SinisterTeaItem
extends Item {
    public SinisterTeaItem() {
        super(new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().alwaysEdible().nutrition(0).saturationModifier(0.0f).usingConvertsTo((ItemLike)Items.BOWL).build()));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity user) {
        MobEffectsComponent effectsComponent;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (!world.isClientSide && (effectsComponent = (MobEffectsComponent)stack.get(CobblemonItemComponents.MOB_EFFECTS)) != null) {
            for (MobEffectInstance effect : effectsComponent.getMobEffects()) {
                MobEffectInstance effectCopy = new MobEffectInstance(effect);
                user.addEffect(effectCopy);
            }
        }
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"finishUsingItem(...)");
        return itemStack;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    @NotNull
    public SoundEvent getDrinkingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }

    @NotNull
    public SoundEvent getEatingSound() {
        SoundEvent soundEvent = SoundEvents.GENERIC_DRINK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"GENERIC_DRINK");
        return soundEvent;
    }
}

