/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.crafting;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.Seasoning;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.item.components.BaitEffectsComponent;
import com.cobblemon.mod.common.item.crafting.SeasoningProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/item/crafting/BaitSeasoningProcessor;", "Lcom/cobblemon/mod/common/item/crafting/SeasoningProcessor;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "result", "", "seasoning", "", "apply", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)V", "", "consumesItem", "(Lnet/minecraft/world/item/ItemStack;)Z", "", "type", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "common"})
public final class BaitSeasoningProcessor
implements SeasoningProcessor {
    @NotNull
    public static final BaitSeasoningProcessor INSTANCE = new BaitSeasoningProcessor();
    @NotNull
    private static final String type = "spawn_bait";

    private BaitSeasoningProcessor() {
    }

    @Override
    @NotNull
    public String getType() {
        return type;
    }

    @Override
    public void apply(@NotNull ItemStack result, @NotNull List<ItemStack> seasoning) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(seasoning, (String)"seasoning");
        List baitIdentifiers = new ArrayList();
        for (ItemStack seasoningStack : seasoning) {
            Collection collection;
            Holder holder = seasoningStack.getItemHolder();
            Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"getItemHolder(...)");
            baitIdentifiers.addAll((Collection)SpawnBaitEffects.getBaitIdentifiersFromItem((Holder<Item>)holder));
            Seasoning seasoningData = Seasonings.INSTANCE.getFromItemStack(seasoningStack);
            if (seasoningData == null || (collection = (Collection)seasoningData.getBaitEffects()) == null || collection.isEmpty()) continue;
            ResourceLocation itemId = ((ResourceKey)seasoningStack.getItemHolder().unwrapKey().get()).location();
            ResourceLocation id = new ResourceLocation("seasonings", itemId.getPath());
            baitIdentifiers.add(id);
        }
        result.set(CobblemonItemComponents.BAIT_EFFECTS, (Object)new BaitEffectsComponent(CollectionsKt.toList((Iterable)baitIdentifiers)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean consumesItem(@NotNull ItemStack seasoning) {
        Intrinsics.checkNotNullParameter((Object)seasoning, (String)"seasoning");
        Seasoning seasoningData = Seasonings.INSTANCE.getFromItemStack(seasoning);
        if (seasoningData == null) return false;
        Collection collection = seasoningData.getBaitEffects();
        if (collection != null) {
            if (!collection.isEmpty()) return true;
        }
        boolean bl = true;
        if (!bl) return true;
        Holder holder = seasoning.getItemHolder();
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"getItemHolder(...)");
        if (((Collection)SpawnBaitEffects.getBaitIdentifiersFromItem((Holder<Item>)holder)).isEmpty()) return false;
        return true;
    }
}

