/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.berry;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonMechanics;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.pokemon.stats.ItemEvSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.item.berry.BerryItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010!\u001a\u0004\u0018\u00010 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/item/berry/FriendshipRaisingBerryItem;", "Lcom/cobblemon/mod/common/item/berry/BerryItem;", "Lcom/cobblemon/mod/common/api/item/PokemonSelectingItem;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "block", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "stat", "<init>", "(Lcom/cobblemon/mod/common/block/BerryBlock;Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "canUseOnPokemon", "(Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lnet/minecraft/world/InteractionResultHolder;", "applyToPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "user", "Lnet/minecraft/world/InteractionHand;", "hand", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "getStat", "()Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "", "bagItem", "Ljava/lang/Void;", "getBagItem", "()Ljava/lang/Void;", "common"})
public final class FriendshipRaisingBerryItem
extends BerryItem
implements PokemonSelectingItem {
    @NotNull
    private final Stat stat;
    @Nullable
    private final Void bagItem;

    public FriendshipRaisingBerryItem(@NotNull BerryBlock block, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        super(block);
        this.stat = stat;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @Nullable
    public Void getBagItem() {
        return this.bagItem;
    }

    @Override
    public boolean canUseOnPokemon(@NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return (pokemon.getEvs().getOrDefault(this.stat) > 0 || pokemon.getFriendship() < Cobblemon.INSTANCE.getConfig().getMaxPokemonFriendship()) && PokemonSelectingItem.super.canUseOnPokemon(stack, pokemon);
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> applyToPokemon(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull Pokemon pokemon) {
        InteractionResultHolder interactionResultHolder;
        boolean decreasedEVs;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (!this.canUseOnPokemon(stack, pokemon)) {
            InteractionResultHolder interactionResultHolder2 = InteractionResultHolder.fail((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder2, (String)"fail(...)");
            return interactionResultHolder2;
        }
        int friendshipRaiseAmount = MoLangExtensionsKt.resolveInt$default(MoLangExtensionsKt.getGenericRuntime(), CobblemonMechanics.INSTANCE.getBerries().getFriendshipRaiseAmount(), pokemon, null, 4, null);
        boolean increasedFriendship = Pokemon.incrementFriendship$default(pokemon, friendshipRaiseAmount, false, 2, null);
        int evLowerAmount = Math.max(MoLangExtensionsKt.resolveInt$default(MoLangExtensionsKt.getGenericRuntime(), CobblemonMechanics.INSTANCE.getBerries().getEvLowerAmount(), null, 2, null), 0);
        boolean bl = decreasedEVs = pokemon.getEvs().add(this.stat, -evLowerAmount, new ItemEvSource(player, stack, pokemon)) != 0;
        if (increasedFriendship || decreasedEVs) {
            Pokemon.feedPokemon$default(pokemon, 1, false, 2, null);
            stack.consume(1, (LivingEntity)player);
            InteractionResultHolder interactionResultHolder3 = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder3);
            interactionResultHolder = interactionResultHolder3;
        } else {
            InteractionResultHolder interactionResultHolder4 = InteractionResultHolder.pass((Object)stack);
            Intrinsics.checkNotNull((Object)interactionResultHolder4);
            interactionResultHolder = interactionResultHolder4;
        }
        return interactionResultHolder;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player user, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world instanceof ServerLevel && user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            ItemStack itemStack = user.getItemInHand(hand);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            return this.use(serverPlayer, itemStack);
        }
        InteractionResultHolder interactionResultHolder = super.use(world, user, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"use(...)");
        return interactionResultHolder;
    }
}

