/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.battle;

import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/item/battle/BagItemLike;", "", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/cobblemon/mod/common/item/battle/BagItem;", "getBagItem", "(Lnet/minecraft/world/item/ItemStack;)Lcom/cobblemon/mod/common/item/battle/BagItem;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "battlePokemon", "", "handleInteraction", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;Lnet/minecraft/world/item/ItemStack;)Z", "common"})
public interface BagItemLike {
    @Nullable
    public BagItem getBagItem(@NotNull ItemStack var1);

    default public boolean handleInteraction(@NotNull ServerPlayer player, @NotNull BattlePokemon battlePokemon, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        PokemonBattle battle = battlePokemon.getActor().getBattle();
        BagItem bagItem2 = this.getBagItem(stack);
        if (bagItem2 == null) {
            return false;
        }
        BagItem bagItem3 = bagItem2;
        if (!battlePokemon.getActor().canFitForcedAction()) {
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.cannot", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return false;
        }
        if (!bagItem3.canUse(stack, battle, battlePokemon)) {
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("bagitem.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return false;
        }
        battlePokemon.getActor().forceChoose(new BagItemActionResponse(bagItem3, battlePokemon, null, 4, null));
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        ResourceLocation stackName = resourceLocation;
        if (!player.hasInfiniteMaterials()) {
            stack.shrink(1);
            battlePokemon.getActor().getItemsUsed().add(bagItem3);
        }
        CobblemonCriteria.POKEMON_INTERACT.trigger(player, new PokemonInteractContext(battlePokemon.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static boolean handleInteraction(@NotNull BagItemLike $this, @NotNull ServerPlayer player, @NotNull BattlePokemon battlePokemon, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)battlePokemon, (String)"battlePokemon");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return $this.handleInteraction(player, battlePokemon, stack);
        }
    }
}

