/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item;

import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.item.CobblemonItem;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/item/PokeBallItem;", "Lcom/cobblemon/mod/common/item/CobblemonItem;", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBall", "<init>", "(Lcom/cobblemon/mod/common/pokeball/PokeBall;)V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "usedHand", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/server/level/ServerPlayer;", "", "throwPokeBall", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "getPokeBall", "()Lcom/cobblemon/mod/common/pokeball/PokeBall;", "common"})
public final class PokeBallItem
extends CobblemonItem {
    @NotNull
    private final PokeBall pokeBall;

    public PokeBallItem(@NotNull PokeBall pokeBall) {
        Item.Properties properties;
        Intrinsics.checkNotNullParameter((Object)pokeBall, (String)"pokeBall");
        Item.Properties properties2 = properties = new Item.Properties();
        PokeBallItem pokeBallItem = this;
        boolean bl = false;
        ResourceLocation resourceLocation = pokeBall.getName();
        if (Intrinsics.areEqual((Object)resourceLocation, (Object)PokeBalls.getMasterBall().getName())) {
            $this$_init__u24lambda_u240.fireResistant().rarity(Rarity.EPIC);
        } else if (Intrinsics.areEqual((Object)resourceLocation, (Object)PokeBalls.getCherishBall().getName())) {
            $this$_init__u24lambda_u240.rarity(Rarity.EPIC);
        } else if (Intrinsics.areEqual((Object)resourceLocation, (Object)PokeBalls.getAncientOriginBall().getName())) {
            $this$_init__u24lambda_u240.rarity(Rarity.EPIC);
        } else if (Intrinsics.areEqual((Object)resourceLocation, (Object)PokeBalls.getBeastBall().getName())) {
            $this$_init__u24lambda_u240.rarity(Rarity.RARE);
        }
        super(properties);
        this.pokeBall = pokeBall;
    }

    @NotNull
    public final PokeBall getPokeBall() {
        return this.pokeBall;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (DistributionUtilsKt.isServerSide(world)) {
            this.throwPokeBall(world, (ServerPlayer)player);
        }
        itemStack.consume(1, (LivingEntity)player);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"sidedSuccess(...)");
        return interactionResultHolder;
    }

    private final void throwPokeBall(Level world, ServerPlayer player) {
        EmptyPokeBallEntity emptyPokeBallEntity;
        Level level = player.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        EmptyPokeBallEntity $this$throwPokeBall_u24lambda_u240 = emptyPokeBallEntity = new EmptyPokeBallEntity(this.pokeBall, level, (LivingEntity)player, null, 8, null);
        boolean bl = false;
        float overhandFactor = player.getXRot() < 0.0f ? 5.0f * (float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(player.getXRot()))) : 5.0f;
        $this$throwPokeBall_u24lambda_u240.shootFromRotation((Entity)player, player.getXRot() - overhandFactor, player.getYRot(), 0.0f, $this$throwPokeBall_u24lambda_u240.getPokeBall().getThrowPower(), 1.0f);
        $this$throwPokeBall_u24lambda_u240.setPos($this$throwPokeBall_u24lambda_u240.position().add($this$throwPokeBall_u24lambda_u240.getDeltaMovement().normalize().scale(1.0)));
        $this$throwPokeBall_u24lambda_u240.setOwner((Entity)player);
        EmptyPokeBallEntity pokeBallEntity = emptyPokeBallEntity;
        world.addFreshEntity((Entity)pokeBallEntity);
    }
}

