/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.events;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.fishing.PokerodCastEvent;
import com.cobblemon.mod.common.api.events.fishing.PokerodReelEvent;
import com.cobblemon.mod.common.api.events.pokemon.CollectEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.LevelUpEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonGainedEvent;
import com.cobblemon.mod.common.api.events.pokemon.RidePokemonEvent;
import com.cobblemon.mod.common.api.events.pokemon.TradeEvent;
import com.cobblemon.mod.common.api.events.pokemon.evolution.EvolutionCompleteEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.events.EventHandler;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010)\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020.\u00a2\u0006\u0004\b/\u00100J\u0015\u00102\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u000201\u00a2\u0006\u0004\b2\u00103J\u0015\u00106\u001a\u0002042\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107\u00a8\u00068"}, d2={"Lcom/cobblemon/mod/common/events/StatHandler;", "Lcom/cobblemon/mod/common/events/EventHandler;", "<init>", "()V", "", "registerListeners", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "event", "onCapture", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "Lcom/cobblemon/mod/common/api/events/storage/ReleasePokemonEvent$Post;", "onRelease", "(Lcom/cobblemon/mod/common/api/events/storage/ReleasePokemonEvent$Post;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/evolution/EvolutionCompleteEvent;", "onEvolve", "(Lcom/cobblemon/mod/common/api/events/pokemon/evolution/EvolutionCompleteEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/LevelUpEvent;", "onLevelUp", "(Lcom/cobblemon/mod/common/api/events/pokemon/LevelUpEvent;)V", "Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;", "onWinBattle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleVictoryEvent;)V", "Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;", "onFleeBattle", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFledEvent;)V", "Lcom/cobblemon/mod/common/api/events/battles/BattleStartedEvent;", "onBattleStart", "(Lcom/cobblemon/mod/common/api/events/battles/BattleStartedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonGainedEvent;", "onDexEntryGain", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonGainedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/CollectEggEvent;", "onCollectEgg", "(Lcom/cobblemon/mod/common/api/events/pokemon/CollectEggEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Post;", "onHatchEgg", "(Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Post;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/TradeEvent$Post;", "onTradeCompleted", "(Lcom/cobblemon/mod/common/api/events/pokemon/TradeEvent$Post;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;", "onFossilRevived", "(Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;)V", "Lcom/cobblemon/mod/common/api/events/pokemon/RidePokemonEvent$Post;", "onRide", "(Lcom/cobblemon/mod/common/api/events/pokemon/RidePokemonEvent$Post;)V", "Lcom/cobblemon/mod/common/api/events/fishing/PokerodCastEvent$Post;", "onPokeRodCast", "(Lcom/cobblemon/mod/common/api/events/fishing/PokerodCastEvent$Post;)V", "Lcom/cobblemon/mod/common/api/events/fishing/PokerodReelEvent;", "onReelIn", "(Lcom/cobblemon/mod/common/api/events/fishing/PokerodReelEvent;)V", "Lnet/minecraft/resources/ResourceLocation;", "resourceLocation", "getStat", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/resources/ResourceLocation;", "common"})
@SourceDebugExtension(value={"SMAP\nStatHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatHandler.kt\ncom/cobblemon/mod/common/events/StatHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1374#2:152\n1460#2,2:153\n1617#2,9:155\n1869#2:164\n1870#2:166\n1626#2:167\n1462#2,3:168\n1869#2,2:171\n1869#2,2:173\n1#3:165\n*S KotlinDebug\n*F\n+ 1 StatHandler.kt\ncom/cobblemon/mod/common/events/StatHandler\n*L\n91#1:152\n91#1:153,2\n91#1:155,9\n91#1:164\n91#1:166\n91#1:167\n91#1:168,3\n92#1:171,2\n102#1:173,2\n91#1:165\n*E\n"})
public final class StatHandler
implements EventHandler {
    @NotNull
    public static final StatHandler INSTANCE = new StatHandler();

    private StatHandler() {
    }

    @Override
    public void registerListeners() {
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, (Function1<PokemonCapturedEvent, Unit>)((Function1)new Function1<PokemonCapturedEvent, Unit>((Object)this){

            public final void invoke(PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onCapture(p0);
            }
        }));
        CobblemonEvents.POKEMON_RELEASED_EVENT_POST.subscribe(Priority.NORMAL, (Function1<ReleasePokemonEvent.Post, Unit>)((Function1)new Function1<ReleasePokemonEvent.Post, Unit>((Object)this){

            public final void invoke(ReleasePokemonEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onRelease(p0);
            }
        }));
        CobblemonEvents.EVOLUTION_COMPLETE.subscribe(Priority.LOWEST, (Function1<EvolutionCompleteEvent, Unit>)((Function1)new Function1<EvolutionCompleteEvent, Unit>((Object)this){

            public final void invoke(EvolutionCompleteEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onEvolve(p0);
            }
        }));
        CobblemonEvents.LEVEL_UP_EVENT.subscribe(Priority.NORMAL, (Function1<LevelUpEvent, Unit>)((Function1)new Function1<LevelUpEvent, Unit>((Object)this){

            public final void invoke(LevelUpEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onLevelUp(p0);
            }
        }));
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, (Function1<BattleVictoryEvent, Unit>)((Function1)new Function1<BattleVictoryEvent, Unit>((Object)this){

            public final void invoke(BattleVictoryEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onWinBattle(p0);
            }
        }));
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, (Function1<BattleFledEvent, Unit>)((Function1)new Function1<BattleFledEvent, Unit>((Object)this){

            public final void invoke(BattleFledEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onFleeBattle(p0);
            }
        }));
        CobblemonEvents.BATTLE_STARTED_POST.subscribe(Priority.NORMAL, (Function1<BattleStartedEvent.Post, Unit>)((Function1)new Function1<BattleStartedEvent, Unit>((Object)this){

            public final void invoke(BattleStartedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onBattleStart(p0);
            }
        }));
        CobblemonEvents.POKEMON_GAINED.subscribe(Priority.NORMAL, (Function1<PokemonGainedEvent, Unit>)((Function1)new Function1<PokemonGainedEvent, Unit>((Object)this){

            public final void invoke(PokemonGainedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onDexEntryGain(p0);
            }
        }));
        CobblemonEvents.COLLECT_EGG.subscribe(Priority.NORMAL, (Function1<CollectEggEvent, Unit>)((Function1)new Function1<CollectEggEvent, Unit>((Object)this){

            public final void invoke(CollectEggEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onCollectEgg(p0);
            }
        }));
        CobblemonEvents.HATCH_EGG_POST.subscribe(Priority.NORMAL, (Function1<HatchEggEvent.Post, Unit>)((Function1)new Function1<HatchEggEvent.Post, Unit>((Object)this){

            public final void invoke(HatchEggEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onHatchEgg(p0);
            }
        }));
        CobblemonEvents.TRADE_EVENT_POST.subscribe(Priority.NORMAL, (Function1<TradeEvent.Post, Unit>)((Function1)new Function1<TradeEvent.Post, Unit>((Object)this){

            public final void invoke(TradeEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onTradeCompleted(p0);
            }
        }));
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.NORMAL, (Function1<FossilRevivedEvent, Unit>)((Function1)new Function1<FossilRevivedEvent, Unit>((Object)this){

            public final void invoke(FossilRevivedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onFossilRevived(p0);
            }
        }));
        CobblemonEvents.RIDE_EVENT_POST.subscribe(Priority.NORMAL, (Function1<RidePokemonEvent.Post, Unit>)((Function1)new Function1<RidePokemonEvent.Post, Unit>((Object)this){

            public final void invoke(RidePokemonEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onRide(p0);
            }
        }));
        CobblemonEvents.POKEROD_CAST_POST.subscribe(Priority.NORMAL, (Function1<PokerodCastEvent.Post, Unit>)((Function1)new Function1<PokerodCastEvent.Post, Unit>((Object)this){

            public final void invoke(PokerodCastEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onPokeRodCast(p0);
            }
        }));
        CobblemonEvents.POKEROD_REEL.subscribe(Priority.NORMAL, (Function1<PokerodReelEvent, Unit>)((Function1)new Function1<PokerodReelEvent, Unit>((Object)this){

            public final void invoke(PokerodReelEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((StatHandler)this.receiver).onReelIn(p0);
            }
        }));
    }

    public final void onCapture(@NotNull PokemonCapturedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getCAPTURED()));
        if (event.getPokemon().getShiny()) {
            event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getSHINIES_CAPTURED()));
        }
    }

    public final void onRelease(@NotNull ReleasePokemonEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getRELEASED()));
    }

    public final void onEvolve(@NotNull EvolutionCompleteEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = event.getPokemon().getOwnerPlayer();
            if (serverPlayer == null) break block0;
            serverPlayer.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getEVOLVED()));
        }
    }

    public final void onLevelUp(@NotNull LevelUpEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = event.getPokemon().getOwnerPlayer();
            if (serverPlayer == null) break block0;
            serverPlayer.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getLEVEL_UP()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onWinBattle(@NotNull BattleVictoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getWasWildCapture() && event.getBattle().isPvW()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = event.getWinners();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                BattleActor it = (BattleActor)element$iv$iv;
                boolean bl = false;
                Iterable<UUID> $this$mapNotNull$iv = it.getPlayerUUIDs();
                boolean $i$f$mapNotNull = false;
                Iterable<UUID> iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ServerPlayer it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    UUID p0 = (UUID)element$iv$iv2;
                    boolean bl3 = false;
                    if (PlayerExtensionsKt.getPlayer(p0) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ServerPlayer player = (ServerPlayer)element$iv;
                boolean bl = false;
                player.awardStat(INSTANCE.getStat(Cobblemon.INSTANCE.getStatistics().getBATTLES_WON()));
            }
        }
    }

    public final void onFleeBattle(@NotNull BattleFledEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = event.getPlayer().getEntity();
            if (serverPlayer == null) break block0;
            serverPlayer.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getBATTLES_FLED()));
        }
    }

    public final void onBattleStart(@NotNull BattleStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$forEach$iv = event.getBattle().getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            player.awardStat(INSTANCE.getStat(INSTANCE.getStat(Cobblemon.INSTANCE.getStatistics().getBATTLES_TOTAL())));
        }
    }

    public final void onDexEntryGain(@NotNull PokemonGainedEvent event) {
        block0: {
            ServerPlayer player;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = player = event.getPokemon().getOwnerPlayer();
            if (serverPlayer == null) break block0;
            serverPlayer.awardStat(this.getStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getDEX_ENTRIES())));
        }
    }

    public final void onCollectEgg(@NotNull CollectEggEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getEGGS_COLLECTED()));
    }

    public final void onHatchEgg(@NotNull HatchEggEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getEGGS_HATCHED()));
    }

    public final void onTradeCompleted(@NotNull TradeEvent.Post event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = event.getTradeParticipant1Pokemon().getOwnerPlayer();
            if (serverPlayer != null) {
                serverPlayer.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getTRADED()));
            }
            ServerPlayer serverPlayer2 = event.getTradeParticipant2Pokemon().getOwnerPlayer();
            if (serverPlayer2 == null) break block1;
            serverPlayer2.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getTRADED()));
        }
    }

    public final void onFossilRevived(@NotNull FossilRevivedEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ServerPlayer serverPlayer = event.getPlayer();
            if (serverPlayer == null) break block0;
            serverPlayer.awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getFOSSILS_REVIVED()));
        }
    }

    public final void onRide(@NotNull RidePokemonEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getTIMES_RIDDEN()));
    }

    public final void onPokeRodCast(@NotNull PokerodCastEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBobber().getOwner() instanceof ServerPlayer) {
            Entity entity = event.getBobber().getOwner();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            ((ServerPlayer)entity).awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getROD_CASTS()));
        }
    }

    public final void onReelIn(@NotNull PokerodReelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPlayer().awardStat(this.getStat(Cobblemon.INSTANCE.getStatistics().getREEL_INS()));
    }

    @NotNull
    public final ResourceLocation getStat(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        ResourceLocation stat = (ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(resourceLocation);
        if (stat == null) {
            Cobblemon.LOGGER.error("Could not find stat with id {}", (Object)resourceLocation);
        }
        ResourceLocation resourceLocation2 = stat;
        if (resourceLocation2 == null) {
            throw new NullPointerException("Could not find stat with id " + resourceLocation);
        }
        return resourceLocation2;
    }
}

