/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JS\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\"\b\b\u0000\u0010\u0005*\u00020\u00042\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011Jy\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\"\b\b\u0000\u0010\u0012*\u00020\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00042\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/FindEntityTask;", "", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "T", "Lnet/minecraft/world/entity/EntityType;", "type", "", "maxDistance", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "targetModule", "", "speed", "completionRange", "Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "create", "(Lnet/minecraft/world/entity/EntityType;ILnet/minecraft/world/entity/ai/memory/MemoryModuleType;FI)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "E", "Ljava/util/function/Predicate;", "entityPredicate", "targetPredicate", "(Lnet/minecraft/world/entity/EntityType;ILjava/util/function/Predicate;Ljava/util/function/Predicate;Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;FI)Lnet/minecraft/world/entity/ai/behavior/BehaviorControl;", "common"})
public final class FindEntityTask {
    @NotNull
    public static final FindEntityTask INSTANCE = new FindEntityTask();

    private FindEntityTask() {
    }

    @NotNull
    public final <T extends LivingEntity> BehaviorControl<LivingEntity> create(@NotNull EntityType<? extends T> type, int maxDistance, @NotNull MemoryModuleType<T> targetModule, float speed, int completionRange) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(targetModule, (String)"targetModule");
        return this.create(type, maxDistance, FindEntityTask::create$lambda$0, FindEntityTask::create$lambda$1, targetModule, speed, completionRange);
    }

    @NotNull
    public final <E extends LivingEntity, T extends LivingEntity> BehaviorControl<E> create(@NotNull EntityType<? extends T> type, int maxDistance, @NotNull Predicate<E> entityPredicate, @NotNull Predicate<T> targetPredicate, @NotNull MemoryModuleType<T> targetModule, float speed, int completionRange) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(entityPredicate, (String)"entityPredicate");
        Intrinsics.checkNotNullParameter(targetPredicate, (String)"targetPredicate");
        Intrinsics.checkNotNullParameter(targetModule, (String)"targetModule");
        int i = maxDistance * maxDistance;
        Predicate<LivingEntity> predicate = arg_0 -> FindEntityTask.create$lambda$2(type, targetPredicate, arg_0);
        OneShot oneShot = BehaviorBuilder.create(arg_0 -> FindEntityTask.create$lambda$3(targetModule, entityPredicate, predicate, i, speed, completionRange, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)oneShot, (String)"create(...)");
        return (BehaviorControl)oneShot;
    }

    private static final boolean create$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean create$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean create$lambda$2(EntityType $type, Predicate $targetPredicate, LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return Intrinsics.areEqual((Object)$type, (Object)entity.getType()) && $targetPredicate.test(entity);
    }

    private static final App create$lambda$3(MemoryModuleType $targetModule, Predicate $entityPredicate, Predicate $predicate, int $i, float $speed, int $completionRange, BehaviorBuilder.Instance context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.group((App)context.registered($targetModule), (App)context.registered(MemoryModuleType.LOOK_TARGET), (App)context.absent(MemoryModuleType.WALK_TARGET), (App)context.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (arg_0, arg_1, arg_2, arg_3) -> FindEntityTask.create$lambda$3$0(context, $entityPredicate, $predicate, $i, $speed, $completionRange, arg_0, arg_1, arg_2, arg_3));
    }

    private static final Trigger create$lambda$3$0(BehaviorBuilder.Instance $context, Predicate $entityPredicate, Predicate $predicate, int $i, float $speed, int $completionRange, MemoryAccessor targetValue, MemoryAccessor lookTarget, MemoryAccessor walkTarget, MemoryAccessor visibleMobs) {
        return (arg_0, arg_1, arg_2) -> FindEntityTask.create$lambda$3$0$0($context, visibleMobs, $entityPredicate, $predicate, $i, targetValue, lookTarget, walkTarget, $speed, $completionRange, arg_0, arg_1, arg_2);
    }

    private static final boolean create$lambda$3$0$0(BehaviorBuilder.Instance $context, MemoryAccessor $visibleMobs, Predicate $entityPredicate, Predicate $predicate, int $i, MemoryAccessor $targetValue, MemoryAccessor $lookTarget, MemoryAccessor $walkTarget, float $speed, int $completionRange, ServerLevel world, LivingEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        NearestVisibleLivingEntities livingTargetCache = (NearestVisibleLivingEntities)$context.get($visibleMobs);
        if ($entityPredicate.test(entity) && livingTargetCache.contains($predicate)) {
            Optional optional = livingTargetCache.findClosest(arg_0 -> FindEntityTask.create$lambda$3$0$0$0(entity, $i, $predicate, arg_0));
            optional.ifPresent(arg_0 -> FindEntityTask.create$lambda$3$0$0$2(arg_0 -> FindEntityTask.create$lambda$3$0$0$1($targetValue, $lookTarget, $walkTarget, $speed, $completionRange, arg_0), arg_0));
            return true;
        }
        return false;
    }

    private static final boolean create$lambda$3$0$0$0(LivingEntity $entity, int $i, Predicate $predicate, LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (double)target.distanceTo((Entity)$entity) <= (double)$i && $predicate.test(target);
    }

    private static final Unit create$lambda$3$0$0$1(MemoryAccessor $targetValue, MemoryAccessor $lookTarget, MemoryAccessor $walkTarget, float $speed, int $completionRange, LivingEntity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        $targetValue.set((Object)target);
        $lookTarget.set((Object)new EntityTracker((Entity)target, true));
        $walkTarget.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), $speed, $completionRange));
        return Unit.INSTANCE;
    }

    private static final void create$lambda$3$0$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

