/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.tasks;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0011J'\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0011J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR!\u0010\"\u001a\r\u0012\t\u0012\u00070 \u00a2\u0006\u0002\b!0\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/FertilizerTask;", "Lnet/minecraft/world/entity/ai/behavior/Behavior;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "checkExtraStartConditions", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "", "time", "canStillUse", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "", "start", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "addLookWalkTargets", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "stop", "tick", "Lnet/minecraft/world/item/ItemStack;", "createBoneMealStack", "()Lnet/minecraft/world/item/ItemStack;", "startTime", "J", "lastEndEntityAge", "", "duration", "I", "Ljava/util/Optional;", "Lnet/minecraft/core/BlockPos;", "Lkotlin/jvm/internal/EnhancedNullability;", "pos", "Ljava/util/Optional;", "Companion", "common"})
public final class FertilizerTask
extends Behavior<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long startTime;
    private long lastEndEntityAge;
    private int duration;
    @NotNull
    private Optional<BlockPos> pos;
    private static final int MAX_DURATION = 80;

    public FertilizerTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        this.pos = optional;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Optional optional = entity.getBrain().getMemory(CobblemonMemories.NEARBY_GROWABLE_CROPS);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getMemory(...)");
        this.pos = optional;
        return this.pos.isPresent();
    }

    protected boolean canStillUse(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.duration < 80 && this.pos.isPresent();
    }

    protected void start(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.addLookWalkTargets(entity);
        this.startTime = time;
        this.duration = 0;
    }

    private final void addLookWalkTargets(PokemonEntity entity) {
        this.pos.ifPresent(arg_0 -> FertilizerTask.addLookWalkTargets$lambda$1(arg_0 -> FertilizerTask.addLookWalkTargets$lambda$0(entity, arg_0), arg_0));
    }

    protected void stop(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.lastEndEntityAge = entity.getAge();
    }

    protected void tick(@NotNull ServerLevel world, @NotNull PokemonEntity entity, long time) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockPos blockPos = this.pos.get();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"get(...)");
        BlockPos blockPos2 = blockPos;
        if (time >= this.startTime && blockPos2.closerThan((Vec3i)entity.blockPosition(), 1.0)) {
            if (BoneMealItem.growCrop((ItemStack)this.createBoneMealStack(), (Level)((Level)world), (BlockPos)blockPos2)) {
                world.globalLevelEvent(1505, blockPos2, 0);
                Optional optional = entity.getBrain().getMemory(CobblemonMemories.NEARBY_GROWABLE_CROPS);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getMemory(...)");
                this.pos = optional;
                this.addLookWalkTargets(entity);
                this.startTime = time + 40L;
            }
            ++this.duration;
        }
    }

    private final ItemStack createBoneMealStack() {
        return new ItemStack((ItemLike)Items.BONE_MEAL, 1);
    }

    private static final Unit addLookWalkTargets$lambda$0(PokemonEntity $entity, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPosTracker blockPosLookTarget = new BlockPosTracker(pos);
        $entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)blockPosLookTarget);
        $entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)blockPosLookTarget, 0.5f, 1));
        return Unit.INSTANCE;
    }

    private static final void addLookWalkTargets$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/tasks/FertilizerTask$Companion;", "", "<init>", "()V", "", "MAX_DURATION", "I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

