/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.ai.ObtainableItem;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B%\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/PokemonItemSensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "", "width", "height", "maxTravelDistance", "<init>", "(DDD)V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "requires", "()Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "level", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "D", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonItemSensor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonItemSensor.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/sensors/PokemonItemSensor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1#2:68\n2423#3,14:69\n*S KotlinDebug\n*F\n+ 1 PokemonItemSensor.kt\ncom/cobblemon/mod/common/entity/pokemon/ai/sensors/PokemonItemSensor\n*L\n63#1:69,14\n*E\n"})
public final class PokemonItemSensor
extends Sensor<PokemonEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double width;
    private final double height;
    private final double maxTravelDistance;
    @NotNull
    public static final String PICKUP_ITEMS = "pickup_items";

    public PokemonItemSensor(double width, double height, double maxTravelDistance) {
        super(30);
        this.width = width;
        this.height = height;
        this.maxTravelDistance = maxTravelDistance;
    }

    public /* synthetic */ PokemonItemSensor(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 16.0;
        }
        if ((n & 2) != 0) {
            d2 = 8.0;
        }
        if ((n & 4) != 0) {
            d3 = 16.0;
        }
        this(d, d2, d3);
    }

    @NotNull
    public Set<MemoryModuleType<?>> requires() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"of(...)");
        return (Set)immutableSet;
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull PokemonEntity entity) {
        Object v5;
        Object object;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        List pickupItems = MoLangExtensionsKt.getObjectList(entity.getConfig(), PICKUP_ITEMS);
        if (!level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || !entity.getPokemon().getCanDropHeldItem$common() || BrainExtensionsKt.getMemorySafely(entity.getBrain(), CobblemonMemories.DISABLE_WALK_TO_WANTED_ITEM).orElse(false).booleanValue()) {
            return;
        }
        Collection collection = pickupItems;
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ObtainableItem obtainableItem = MiscUtilsKt.findMatchingEntry(collection, registryAccess, entity.getPokemon().heldItem());
        int heldItemValue = obtainableItem != null ? obtainableItem.getPickupPriority() : 0;
        Iterable iterable = pickupItems;
        int n = heldItemValue;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            Object it = (ObtainableItem)iterator.next();
            boolean bl = false;
            it = ((ObtainableItem)it).getPickupPriority();
            while (iterator.hasNext()) {
                Object it2 = (ObtainableItem)iterator.next();
                $i$a$-maxOfOrNull-PokemonItemSensor$doTick$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((ObtainableItem)it2).getPickupPriority())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Object object2 = object;
        Integer n2 = (Integer)object2;
        if (n >= (n2 != null ? n2 : 0)) {
            return;
        }
        List list = level.getEntitiesOfClass(ItemEntity.class, entity.getBoundingBox().inflate(this.width, this.height, this.width), arg_0 -> PokemonItemSensor.doTick$lambda$2(arg_0 -> PokemonItemSensor.doTick$lambda$1(pickupItems, entity, heldItemValue, this, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$minByOrNull$iv = list;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = minElem$iv;
            } else {
                ItemEntity it = (ItemEntity)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.distanceTo((Entity)entity);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemEntity it3 = (ItemEntity)e$iv;
                    $i$a$-minByOrNull-PokemonItemSensor$doTick$nearestItemEntity$1 = false;
                    float v$iv = it3.distanceTo((Entity)entity);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = minElem$iv;
            }
        }
        ItemEntity nearestItemEntity = v5;
        entity.getBrain().setMemory(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, Optional.ofNullable(nearestItemEntity));
    }

    private static final boolean doTick$lambda$1(List $pickupItems, PokemonEntity $entity, int $heldItemValue, PokemonItemSensor this$0, ItemEntity it) {
        Collection collection = $pickupItems;
        RegistryAccess registryAccess = $entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ItemStack itemStack = it.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ObtainableItem obtainableItem = MiscUtilsKt.findMatchingEntry(collection, registryAccess, itemStack);
        return (obtainableItem != null ? obtainableItem.getPickupPriority() : 0) > $heldItemValue && it.closerThan((Entity)$entity, this$0.maxTravelDistance) && $entity.hasLineOfSight((Entity)it);
    }

    private static final boolean doTick$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public PokemonItemSensor() {
        this(0.0, 0.0, 0.0, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/PokemonItemSensor$Companion;", "", "<init>", "()V", "", "PICKUP_ITEMS", "Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

