/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/FlowerSensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "Lnet/minecraft/core/BlockPos;", "requires", "()Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "isFlower", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "common"})
public final class FlowerSensor
extends Sensor<PokemonEntity> {
    public FlowerSensor() {
        super(120);
    }

    @NotNull
    public Set<MemoryModuleType<BlockPos>> requires() {
        return SetsKt.setOf(CobblemonMemories.NEARBY_FLOWER);
    }

    protected void doTick(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Brain<PokemonEntity> brain = entity.getBrain();
        BlockPos currPos = BrainExtensionsKt.getMemorySafely(brain, CobblemonMemories.NEARBY_FLOWER).orElse(null);
        if (currPos != null) {
            BlockState blockState = entity.level().getBlockState(currPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            if (this.isFlower(blockState) && EntityExtensionsKt.distanceTo((Entity)entity, currPos) <= 32.0) {
                return;
            }
        }
        int searchRadius = 5;
        BlockPos centerPos = entity.blockPosition();
        Ref.ObjectRef flowerPos = new Ref.ObjectRef();
        Ref.DoubleRef shortestDist = new Ref.DoubleRef();
        shortestDist.element = Double.MAX_VALUE;
        BlockPos.betweenClosedStream((BlockPos)centerPos.offset(-searchRadius, -2, -searchRadius), (BlockPos)centerPos.offset(searchRadius, 2, searchRadius)).forEach(arg_0 -> FlowerSensor.doTick$lambda$1(arg_0 -> FlowerSensor.doTick$lambda$0(world, this, centerPos, shortestDist, flowerPos, arg_0), arg_0));
        if (flowerPos.element != null) {
            brain.setMemory(CobblemonMemories.NEARBY_FLOWER, flowerPos.element);
        } else {
            brain.eraseMemory(CobblemonMemories.NEARBY_FLOWER);
        }
    }

    private final boolean isFlower(BlockState state) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            Comparable comparable = state.getValue((Property)BlockStateProperties.WATERLOGGED);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
            if (((Boolean)comparable).booleanValue()) {
                return false;
            }
        }
        if (state.is(BlockTags.FLOWERS)) {
            if (state.is(Blocks.SUNFLOWER)) {
                return state.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        return false;
    }

    private static final Unit doTick$lambda$0(ServerLevel $world, FlowerSensor this$0, BlockPos $centerPos, Ref.DoubleRef $shortestDist, Ref.ObjectRef $flowerPos, BlockPos pos) {
        double distance;
        BlockState state = $world.getBlockState(pos);
        Intrinsics.checkNotNull((Object)state);
        if (this$0.isFlower(state) && (distance = pos.distSqr(new Vec3i($centerPos.getX(), $centerPos.getY(), $centerPos.getZ()))) < $shortestDist.element) {
            $flowerPos.element = new BlockPos((Vec3i)pos);
            $shortestDist.element = distance;
        }
        return Unit.INSTANCE;
    }

    private static final void doTick$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

