/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai.sensors;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/sensors/DefendOwnerSensor;", "Lnet/minecraft/world/entity/ai/sensing/Sensor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "", "Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;", "Lnet/minecraft/world/entity/LivingEntity;", "requires", "()Ljava/util/Set;", "Lnet/minecraft/server/level/ServerLevel;", "world", "entity", "", "doTick", "(Lnet/minecraft/server/level/ServerLevel;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/entity/ai/memory/NearestVisibleLivingEntities;", "visibleMobs", "owner", "setNearestAttacker", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/ai/memory/NearestVisibleLivingEntities;Lnet/minecraft/world/entity/LivingEntity;)V", "common"})
public final class DefendOwnerSensor
extends Sensor<PokemonEntity> {
    public DefendOwnerSensor() {
        super(10);
    }

    @NotNull
    public Set<MemoryModuleType<LivingEntity>> requires() {
        return SetsKt.setOf(CobblemonMemories.NEAREST_VISIBLE_ATTACKER);
    }

    protected void doTick(@NotNull ServerLevel world, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        LivingEntity livingEntity = entity.getOwner();
        if (livingEntity == null) {
            return;
        }
        LivingEntity owner = livingEntity;
        entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).ifPresent(arg_0 -> DefendOwnerSensor.doTick$lambda$1(arg_0 -> DefendOwnerSensor.doTick$lambda$0(this, entity, owner, arg_0), arg_0));
    }

    private final void setNearestAttacker(PokemonEntity entity, NearestVisibleLivingEntities visibleMobs, LivingEntity owner) {
        Optional<LivingEntity> nearestAttacker = visibleMobs.findClosest(arg_0 -> DefendOwnerSensor.setNearestAttacker$lambda$0(owner, arg_0)).map(arg_0 -> DefendOwnerSensor.setNearestAttacker$lambda$2(DefendOwnerSensor::setNearestAttacker$lambda$1, arg_0));
        entity.getBrain().setMemory(CobblemonMemories.NEAREST_VISIBLE_ATTACKER, nearestAttacker);
    }

    private static final Unit doTick$lambda$0(DefendOwnerSensor this$0, PokemonEntity $entity, LivingEntity $owner, NearestVisibleLivingEntities visibleMobs) {
        Intrinsics.checkNotNullParameter((Object)visibleMobs, (String)"visibleMobs");
        this$0.setNearestAttacker($entity, visibleMobs, $owner);
        return Unit.INSTANCE;
    }

    private static final void doTick$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean setNearestAttacker$lambda$0(LivingEntity $owner, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            return false;
        }
        if (Intrinsics.areEqual((Object)livingEntity.getLastHurtMob(), (Object)$owner)) {
            return true;
        }
        if (livingEntity instanceof Mob && Intrinsics.areEqual((Object)((Mob)livingEntity).getTarget(), (Object)$owner)) {
            return true;
        }
        Brain brain = livingEntity.getBrain();
        Intrinsics.checkNotNullExpressionValue((Object)brain, (String)"getBrain(...)");
        MemoryModuleType memoryModuleType = MemoryModuleType.ATTACK_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)memoryModuleType, (String)"ATTACK_TARGET");
        Optional mobAttackTarget = BrainExtensionsKt.getMemorySafely(brain, memoryModuleType);
        return mobAttackTarget.isPresent() && Intrinsics.areEqual(mobAttackTarget.get(), (Object)$owner);
    }

    private static final LivingEntity setNearestAttacker$lambda$1(LivingEntity mob) {
        Intrinsics.checkNotNull((Object)mob, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        return mob;
    }

    private static final LivingEntity setNearestAttacker$lambda$2(Function1 $tmp0, Object p0) {
        return (LivingEntity)$tmp0.invoke(p0);
    }
}

