/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.pokemon.ai;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.entity.PlatformType;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.ai.FormPokemonBehaviour;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u0000 ?2\u00020\u0001:\u0001?B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\f\u00a2\u0006\u0004\b\u001d\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010(\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010,R\"\u0010-\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\"\u00103\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u00109\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u00104\u001a\u0004\b:\u00106\"\u0004\b;\u00108R\"\u0010<\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00104\u001a\u0004\b=\u00106\"\u0004\b>\u00108\u00a8\u0006@"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/PokemonMoveControl;", "Lnet/minecraft/world/entity/ai/control/MoveControl;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "forwardBlocksPerTick", "upwardsBlocksPerTick", "rightDegreesPerTick", "", "durationTicks", "", "startBanking", "(FFFI)V", "stopBanking", "()V", "tick", "", "getStableBattleFloatHeight", "()D", "", "checkInWater", "()Z", "isUnderwater", "xMovement", "zMovement", "isWalkable", "(FF)Z", "stop", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getPokemonEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "runtime", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "getRuntime", "()Lcom/bedrockk/molang/runtime/MoLangRuntime;", "waterLevel", "D", "banking", "Z", "getBanking", "setBanking", "(Z)V", "bankDurationTicks", "I", "getBankDurationTicks", "()I", "setBankDurationTicks", "(I)V", "bankForwardBlocksPerTick", "F", "getBankForwardBlocksPerTick", "()F", "setBankForwardBlocksPerTick", "(F)V", "bankUpwardsBlocksPerTick", "getBankUpwardsBlocksPerTick", "setBankUpwardsBlocksPerTick", "bankRightDegreesPerTick", "getBankRightDegreesPerTick", "setBankRightDegreesPerTick", "Companion", "common"})
public final class PokemonMoveControl
extends MoveControl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PokemonEntity pokemonEntity;
    @NotNull
    private final MoLangRuntime runtime;
    private double waterLevel;
    private boolean banking;
    private int bankDurationTicks;
    private float bankForwardBlocksPerTick;
    private float bankUpwardsBlocksPerTick;
    private float bankRightDegreesPerTick;
    public static final double VERY_CLOSE = 0.002500000277905201;

    /*
     * WARNING - void declaration
     */
    public PokemonMoveControl(@NotNull PokemonEntity pokemonEntity) {
        void it;
        MoLangRuntime moLangRuntime;
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        super((Mob)pokemonEntity);
        this.pokemonEntity = pokemonEntity;
        MoLangRuntime moLangRuntime2 = moLangRuntime = new MoLangRuntime();
        PokemonMoveControl pokemonMoveControl = this;
        boolean bl = false;
        QueryStruct queryStruct = it.getEnvironment().query;
        Intrinsics.checkNotNullExpressionValue((Object)queryStruct, (String)"query");
        QueryStruct queryStruct2 = MoLangFunctions.INSTANCE.addStandardFunctions(queryStruct);
        HashMap hashMap = ((ObjectValue)this.pokemonEntity.getStruct()).functions;
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"functions");
        MoLangFunctions.INSTANCE.addFunctions(queryStruct2, hashMap);
        pokemonMoveControl.runtime = moLangRuntime;
        this.bankDurationTicks = -1;
        this.bankForwardBlocksPerTick = 0.1f;
        this.bankRightDegreesPerTick = 1.0f;
    }

    @NotNull
    public final PokemonEntity getPokemonEntity() {
        return this.pokemonEntity;
    }

    @NotNull
    public final MoLangRuntime getRuntime() {
        return this.runtime;
    }

    public final boolean getBanking() {
        return this.banking;
    }

    public final void setBanking(boolean bl) {
        this.banking = bl;
    }

    public final int getBankDurationTicks() {
        return this.bankDurationTicks;
    }

    public final void setBankDurationTicks(int n) {
        this.bankDurationTicks = n;
    }

    public final float getBankForwardBlocksPerTick() {
        return this.bankForwardBlocksPerTick;
    }

    public final void setBankForwardBlocksPerTick(float f) {
        this.bankForwardBlocksPerTick = f;
    }

    public final float getBankUpwardsBlocksPerTick() {
        return this.bankUpwardsBlocksPerTick;
    }

    public final void setBankUpwardsBlocksPerTick(float f) {
        this.bankUpwardsBlocksPerTick = f;
    }

    public final float getBankRightDegreesPerTick() {
        return this.bankRightDegreesPerTick;
    }

    public final void setBankRightDegreesPerTick(float f) {
        this.bankRightDegreesPerTick = f;
    }

    public final void startBanking(float forwardBlocksPerTick, float upwardsBlocksPerTick, float rightDegreesPerTick, int durationTicks) {
        this.banking = true;
        this.bankForwardBlocksPerTick = forwardBlocksPerTick;
        this.bankUpwardsBlocksPerTick = upwardsBlocksPerTick;
        this.bankRightDegreesPerTick = rightDegreesPerTick;
        this.bankDurationTicks = durationTicks;
        this.operation = MoveControl.Operation.WAIT;
    }

    public static /* synthetic */ void startBanking$default(PokemonMoveControl pokemonMoveControl, float f, float f2, float f3, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = 0.0f;
        }
        if ((n2 & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 4) != 0) {
            f3 = 0.0f;
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        pokemonMoveControl.startBanking(f, f2, f3, n);
    }

    public final void stopBanking() {
        this.banking = false;
        this.bankForwardBlocksPerTick = 0.0f;
        this.bankUpwardsBlocksPerTick = 0.0f;
        this.bankRightDegreesPerTick = 0.0f;
        this.bankDurationTicks = -1;
    }

    public void tick() {
        if (this.banking && this.operation != MoveControl.Operation.WAIT) {
            this.banking = false;
        }
        if (this.pokemonEntity.isDeadOrDying()) {
            this.pokemonEntity.setSpeed(0.0f);
            this.pokemonEntity.yya = 0.0f;
            return;
        }
        if (!this.pokemonEntity.isFlying() && !this.pokemonEntity.isInLiquid() && !this.pokemonEntity.canWalk() && this.pokemonEntity.canFly()) {
            this.pokemonEntity.setFlying(true);
        }
        FormPokemonBehaviour behaviour = this.pokemonEntity.getBehaviour();
        PoseType[] poseTypeArray = new PoseType[]{PoseType.FLY, PoseType.HOVER};
        Expression expression = SetsKt.setOf((Object[])poseTypeArray).contains((Object)this.pokemonEntity.getCurrentPoseType()) ? behaviour.getMoving().getFly().getFlySpeedHorizontal() : (this.pokemonEntity.isEyeInFluid(FluidTags.WATER) || this.pokemonEntity.isEyeInFluid(FluidTags.LAVA) ? behaviour.getMoving().getSwim().getSwimSpeed() : behaviour.getMoving().getWalk().getWalkSpeed());
        Intrinsics.checkNotNull((Object)expression);
        float mediumSpeed = MoLangExtensionsKt.resolveFloat$default(this.runtime, expression, null, 2, null) * 2.5f;
        float baseSpeed = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * (float)this.speedModifier;
        float adjustedSpeed = baseSpeed * mediumSpeed;
        if (this.banking) {
            PokemonEntity pokemonEntity = this.pokemonEntity;
            pokemonEntity.setYRot(pokemonEntity.getYRot() + this.bankRightDegreesPerTick);
            Vec3 vec3 = new Vec3(0.0, (double)this.bankUpwardsBlocksPerTick, (double)this.bankForwardBlocksPerTick).scale((double)mediumSpeed);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
            this.pokemonEntity.travel(vec3);
            if (this.bankDurationTicks > 0) {
                int n = this.bankDurationTicks;
                this.bankDurationTicks = n + -1;
            }
            if (this.bankDurationTicks == 0) {
                this.banking = false;
                this.operation = MoveControl.Operation.WAIT;
            }
        }
        if (this.operation == MoveControl.Operation.STRAFE) {
            float zMovement;
            float movingDistanceTotal = Mth.sqrt((float)(this.strafeForwards * this.strafeForwards + this.strafeRight * this.strafeRight));
            if (movingDistanceTotal < 1.0f) {
                movingDistanceTotal = 1.0f;
            }
            movingDistanceTotal = adjustedSpeed / movingDistanceTotal;
            float adjustedForward = this.strafeForwards * movingDistanceTotal;
            float adjustedStrafe = this.strafeRight * movingDistanceTotal;
            float xComponent = -Mth.sin((float)AngleExtensionsKt.toRadians(Float.valueOf(this.mob.getYRot())));
            float zComponent = Mth.cos((float)AngleExtensionsKt.toRadians(Float.valueOf(this.mob.getYRot())));
            float xMovement = adjustedForward * zComponent - adjustedStrafe * xComponent;
            if (!this.isWalkable(xMovement, zMovement = adjustedStrafe * zComponent + adjustedForward * xComponent)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.mob.setSpeed(adjustedSpeed);
            this.mob.setZza(this.strafeForwards);
            this.mob.setXxa(this.strafeRight);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            boolean closeHorizontally;
            if (!this.pokemonEntity.isFlying() && !this.pokemonEntity.isInLiquid()) {
                this.operation = MoveControl.Operation.WAIT;
            }
            double xDist = this.wantedX - this.mob.getX();
            double zDist = this.wantedZ - this.mob.getZ();
            double yDist = this.wantedY - this.mob.getY();
            if (xDist * xDist + yDist * yDist + zDist * zDist < 0.002500000277905201) {
                this.mob.setZza(0.0f);
                this.mob.yya = 0.0f;
                if (this.pokemonEntity.isFlying() || this.pokemonEntity.isInLiquid()) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.mob.setDeltaMovement(Vec3.ZERO);
                }
                return;
            }
            double horizontalDistanceFromTarget = xDist * xDist + zDist * zDist;
            boolean bl = closeHorizontally = horizontalDistanceFromTarget < 0.002500000277905201;
            if (!closeHorizontally) {
                float angleToTarget = AngleExtensionsKt.toDegrees(Mth.atan2((double)zDist, (double)xDist)) - 90.0f;
                float currentMovingAngle = this.mob.getYRot();
                float steppedAngle = Mth.approachDegrees((float)currentMovingAngle, (float)angleToTarget, (float)((float)100 * mediumSpeed));
                this.mob.setYRot(steppedAngle);
            }
            Level level = this.mob.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            BlockGetter blockGetter = (BlockGetter)level;
            AABB aABB = this.mob.getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
            Pair<Boolean, Boolean> pair = WorldExtensionsKt.getWaterAndLavaIn(blockGetter, aABB);
            boolean inWater = (Boolean)pair.component1();
            boolean inLava = (Boolean)pair.component2();
            boolean inFluid = inWater || inLava;
            boolean verticalHandled = false;
            BlockPos blockPos = this.mob.blockPosition();
            BlockState blockState = this.mob.level().getBlockState(blockPos);
            VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.mob.level(), blockPos);
            if (this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING) || inFluid) {
                verticalHandled = true;
                this.mob.yya = 0.0f;
                this.mob.setSpeed(0.0f);
                Function1 refine = PokemonMoveControl::tick$lambda$0;
                Vec3 fullDistance = new Vec3(xDist, ((Number)refine.invoke((Object)(yDist + 0.05))).doubleValue(), zDist);
                Vec3 direction = fullDistance.normalize();
                double scale = Math.min((double)adjustedSpeed, fullDistance.length());
                this.mob.setDeltaMovement(direction.scale(scale));
                xDist = fullDistance.x;
                zDist = fullDistance.z;
                yDist = fullDistance.y;
            } else {
                float forwardSpeed = Math.min(adjustedSpeed, Math.max((float)horizontalDistanceFromTarget / (float)2, 0.15f));
                this.mob.setSpeed(forwardSpeed);
            }
            if (!verticalHandled) {
                boolean closeEnoughToJump;
                boolean tooBigToStep = yDist > (double)this.pokemonEntity.getBehaviour().getMoving().getStepHeight();
                double xComponent = -((double)Mth.sin((float)AngleExtensionsKt.toRadians(Float.valueOf(this.mob.getYRot()))));
                double zComponent = Mth.cos((float)AngleExtensionsKt.toRadians(Float.valueOf(this.mob.getYRot())));
                Vec3 motion = new Vec3(xComponent, 0.0, zComponent).normalize();
                Vec3 offset = motion.scale((double)this.mob.getSpeed());
                boolean bl2 = closeEnoughToJump = !this.mob.isFree(offset.x, 0.0, offset.z);
                if (tooBigToStep && closeEnoughToJump || !voxelShape.isEmpty() && this.mob.getY() < voxelShape.max(Direction.Axis.Y) + (double)blockPos.getY() && !blockState.is(BlockTags.DOORS) && !blockState.is(BlockTags.FENCES)) {
                    this.mob.getJumpControl().jump();
                    this.operation = MoveControl.Operation.JUMPING;
                }
            }
            if (closeHorizontally && Math.abs(yDist) < 0.002500000277905201) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.mob.setSpeed(adjustedSpeed);
            this.mob.yya = 0.0f;
            if (this.mob.onGround() || this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else {
            this.mob.setZza(0.0f);
            this.mob.yya = 0.0f;
        }
        if (this.operation == MoveControl.Operation.WAIT && !this.mob.getNavigation().isInProgress()) {
            if (this.mob.onGround() && behaviour.getMoving().getWalk().getCanWalk() && this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
                this.pokemonEntity.setBehaviourFlag(PokemonBehaviourFlag.FLYING, false);
            }
            if (this.pokemonEntity.isBattling()) {
                if (this.pokemonEntity.getBehaviourFlag(PokemonBehaviourFlag.FLYING)) {
                    this.mob.setDeltaMovement(new Vec3(this.mob.getDeltaMovement().x, Math.min(0.01, this.mob.getDeltaMovement().y), this.mob.getDeltaMovement().z));
                }
                if (this.mob.isInWater()) {
                    float e = 0.0f;
                    FormData exposedForm = this.pokemonEntity.getExposedForm();
                    if (this.isUnderwater()) {
                        if (this.pokemonEntity.getPlatform() != PlatformType.NONE) {
                            e = 0.3f;
                        }
                    } else if (this.checkInWater()) {
                        if (this.pokemonEntity.getPlatform() != PlatformType.NONE) {
                            e = (float)((this.waterLevel - this.pokemonEntity.getY()) / (double)this.pokemonEntity.getBbHeight());
                        } else if (exposedForm.getBehaviour().getMoving().getSwim().getCanBreatheUnderwater()) {
                            e = -1.5f;
                        }
                    }
                    if ((double)Mth.abs((float)e) > 0.002500000277905201) {
                        Vec3 vec3 = this.pokemonEntity.getDeltaMovement();
                        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
                        Vec3 vec32 = vec3;
                        this.pokemonEntity.setDeltaMovement(vec32.x, (vec32.y + (double)e * (this.pokemonEntity.getGravity() / 0.65)) * 0.75, vec32.z);
                    }
                }
            }
        }
    }

    private final double getStableBattleFloatHeight() {
        AABB aABB = this.pokemonEntity.getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
        AABB aABB2 = aABB;
        return this.pokemonEntity.getExposedForm().getBehaviour().getMoving().getSwim().getCanBreatheUnderwater() ? (aABB2.maxY - aABB2.minY) / 2.0 : 0.05;
    }

    private final boolean checkInWater() {
        AABB aABB = this.mob.getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
        AABB aABB2 = aABB;
        int i = Mth.floor((double)aABB2.minX);
        int j = Mth.ceil((double)aABB2.maxX);
        int k = Mth.floor((double)aABB2.minY);
        int l = Mth.ceil((double)(aABB2.minY + 0.001));
        int m = Mth.floor((double)aABB2.minZ);
        int n = Mth.ceil((double)aABB2.maxZ);
        boolean bl = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    FluidState fluidState;
                    mutableBlockPos.set(o, p, q);
                    Intrinsics.checkNotNullExpressionValue((Object)this.mob.level().getFluidState((BlockPos)mutableBlockPos), (String)"getFluidState(...)");
                    if (!fluidState.is(FluidTags.WATER)) continue;
                    float f = (float)p + fluidState.getHeight((BlockGetter)this.mob.level(), (BlockPos)mutableBlockPos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    bl |= aABB2.minY < (double)f;
                }
            }
        }
        return bl;
    }

    private final boolean isUnderwater() {
        AABB aABB = this.pokemonEntity.getBoundingBox();
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
        AABB aABB2 = aABB;
        double d = aABB2.minY + this.getStableBattleFloatHeight();
        int i = Mth.floor((double)aABB2.minX);
        int j = Mth.ceil((double)aABB2.maxX);
        int k = Mth.floor((double)aABB2.minY);
        int l = Mth.ceil((double)aABB2.maxY);
        int m = Mth.floor((double)aABB2.minZ);
        int n = Mth.ceil((double)aABB2.maxZ);
        boolean bl = false;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int o = i; o < j; ++o) {
            for (int p = k; p < l; ++p) {
                for (int q = m; q < n; ++q) {
                    FluidState fluidState;
                    mutableBlockPos.set(o, p, q);
                    Intrinsics.checkNotNullExpressionValue((Object)this.mob.level().getFluidState((BlockPos)mutableBlockPos), (String)"getFluidState(...)");
                    if (!fluidState.is(FluidTags.WATER) || !(d < (double)((float)mutableBlockPos.getY() + fluidState.getHeight((BlockGetter)this.mob.level(), (BlockPos)mutableBlockPos)))) continue;
                    return true;
                }
            }
        }
        return bl;
    }

    private final boolean isWalkable(float xMovement, float zMovement) {
        PathNavigation entityNavigation = this.mob.getNavigation();
        NodeEvaluator pathNodeMaker = entityNavigation.getNodeEvaluator();
        return pathNodeMaker.getPathType(this.mob, new BlockPos(Mth.floor((double)(this.mob.getX() + (double)xMovement)), this.mob.getBlockY(), Mth.floor((double)(this.mob.getZ() + (double)zMovement)))) == PathType.WALKABLE;
    }

    public final void stop() {
        this.operation = MoveControl.Operation.WAIT;
        this.strafeForwards = 0.0f;
        this.strafeRight = 0.0f;
    }

    private static final double tick$lambda$0(double it) {
        return Math.abs(it) < 0.05 ? 0.0 : it;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/pokemon/ai/PokemonMoveControl$Companion;", "", "<init>", "()V", "", "VERY_CLOSE", "D", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

