/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.fishing;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.ModAPI;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.ReelInPokemonContext;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.fishing.BobberSpawnPokemonEvent;
import com.cobblemon.mod.common.api.fishing.SpawnBait;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.spawning.BestSpawner;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.fishing.FishingSpawnCause;
import com.cobblemon.mod.common.api.spawning.influence.BucketNormalizingInfluence;
import com.cobblemon.mod.common.api.spawning.influence.PlayerLevelRangeInfluence;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.FishingSpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.BasicSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.sound.EntitySoundTracker;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormParticlePacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u00c3\u00012\u00020\u0001:\b\u00c4\u0001\u00c5\u0001\u00c6\u0001\u00c3\u0001B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007BA\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u001a\u001a\u00020\u00152\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b$\u0010%J!\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010)\u001a\u00020(2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b)\u0010+J\u0019\u0010-\u001a\u00020\u00152\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\u0015\u00a2\u0006\u0004\b1\u00102J\u0017\u00105\u001a\u00020\u00152\u0006\u00104\u001a\u000203H\u0016\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b7\u00102J\u0017\u00109\u001a\u00020#2\u0006\u00108\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b;\u00102J\u0017\u0010>\u001a\u00020\u00152\u0006\u0010=\u001a\u00020<H\u0014\u00a2\u0006\u0004\b>\u0010?J\u0019\u0010B\u001a\u00020\u00152\b\u0010A\u001a\u0004\u0018\u00010@H\u0002\u00a2\u0006\u0004\bB\u0010CJ\u000f\u0010D\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\bD\u00102J\u0017\u0010F\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u001d\u0010H\u001a\u00020\u00152\u0006\u00108\u001a\u00020\b2\u0006\u0010A\u001a\u00020@\u00a2\u0006\u0004\bH\u0010IJ'\u0010L\u001a\u00020\u00152\u0006\u00108\u001a\u00020J2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010K\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bL\u0010MJ\u0017\u0010N\u001a\u00020\u00152\u0006\u00108\u001a\u00020JH\u0002\u00a2\u0006\u0004\bN\u0010OJ)\u0010R\u001a\u00020#2\u0006\u00108\u001a\u00020J2\u0006\u0010\u0011\u001a\u00020\f2\n\u0010Q\u001a\u0006\u0012\u0002\b\u00030P\u00a2\u0006\u0004\bR\u0010SJ\u0015\u0010U\u001a\u00020#2\u0006\u0010T\u001a\u00020\f\u00a2\u0006\u0004\bU\u0010VJ\u001d\u0010X\u001a\u00020\u000e2\u0006\u0010W\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\f\u00a2\u0006\u0004\bX\u0010YJ\u0015\u0010Z\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\f\u00a2\u0006\u0004\bZ\u0010GJ\u001f\u0010\\\u001a\u00020\u00152\u0006\u0010A\u001a\u00020@2\u0006\u0010[\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\\\u0010]J7\u0010b\u001a\u00020\u00152\u0006\u0010_\u001a\u00020^2\u0006\u0010`\u001a\u00020^2\u0006\u0010a\u001a\u00020^2\u0006\u0010A\u001a\u00020@2\u0006\u0010[\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bb\u0010cR(\u0010d\u001a\b\u0012\u0002\b\u0003\u0018\u00010P8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010e\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u0016\u0010k\u001a\u00020j8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010lR\u0014\u0010m\u001a\u00020j8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bm\u0010lR\u001c\u0010p\u001a\n o*\u0004\u0018\u00010n0n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u0016\u0010r\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010sR\u0016\u0010t\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010uR\u0016\u0010v\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010uR\u0016\u0010w\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010uR\u0016\u0010W\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010uR\u0016\u0010x\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010uR\u0016\u0010y\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010zR\"\u0010{\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b{\u0010s\u001a\u0004\b|\u0010}\"\u0004\b~\u0010\u007fR\u001b\u0010\u0080\u0001\u001a\u0004\u0018\u00010@8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0080\u0001\u0010\u0081\u0001R*\u0010\u0083\u0001\u001a\u00030\u0082\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R(\u0010\u0089\u0001\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u0089\u0001\u0010u\u001a\u0006\b\u008a\u0001\u0010\u008b\u0001\"\u0006\b\u008c\u0001\u0010\u008d\u0001R&\u0010K\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0004\bK\u0010u\u001a\u0006\b\u008e\u0001\u0010\u008b\u0001\"\u0006\b\u008f\u0001\u0010\u008d\u0001R\u001a\u0010\u0091\u0001\u001a\u00030\u0090\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0091\u0001\u0010\u0092\u0001R\u0016\u0010\u0093\u0001\u001a\u00020\u000e8\u0002X\u0082D\u00a2\u0006\u0007\n\u0005\b\u0093\u0001\u0010uR\u0018\u0010\u0095\u0001\u001a\u00030\u0094\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0095\u0001\u0010\u0096\u0001R)\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u000b\u0010\u0097\u0001\u001a\u0006\b\u0098\u0001\u0010\u0099\u0001\"\u0006\b\u009a\u0001\u0010\u009b\u0001R*\u0010\u009d\u0001\u001a\u00030\u009c\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u009d\u0001\u0010\u009e\u0001\u001a\u0006\b\u009f\u0001\u0010\u00a0\u0001\"\u0006\b\u00a1\u0001\u0010\u00a2\u0001R+\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a3\u0001\u0010\u0097\u0001\u001a\u0006\b\u00a4\u0001\u0010\u0099\u0001\"\u0006\b\u00a5\u0001\u0010\u009b\u0001R)\u0010\u00a6\u0001\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a6\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00a8\u0001\u0010\u00a9\u0001\"\u0006\b\u00aa\u0001\u0010\u00ab\u0001R&\u0010\u00ac\u0001\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00ac\u0001\u0010s\u001a\u0005\b\u00ac\u0001\u0010}\"\u0005\b\u00ad\u0001\u0010\u007fR(\u0010\u00ae\u0001\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u00ae\u0001\u0010z\u001a\u0006\b\u00af\u0001\u0010\u00b0\u0001\"\u0006\b\u00b1\u0001\u0010\u00b2\u0001R(\u0010\u00b3\u0001\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u00b3\u0001\u0010z\u001a\u0006\b\u00b4\u0001\u0010\u00b0\u0001\"\u0006\b\u00b5\u0001\u0010\u00b2\u0001R(\u0010\u00b6\u0001\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0005\b\u00b6\u0001\u0010z\u001a\u0006\b\u00b7\u0001\u0010\u00b0\u0001\"\u0006\b\u00b8\u0001\u0010\u00b2\u0001R,\u0010\u00ba\u0001\u001a\u0005\u0018\u00010\u00b9\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00ba\u0001\u0010\u00bb\u0001\u001a\u0006\b\u00bc\u0001\u0010\u00bd\u0001\"\u0006\b\u00be\u0001\u0010\u00bf\u0001R+\u0010\u00c0\u0001\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00c0\u0001\u0010\u00a7\u0001\u001a\u0006\b\u00c1\u0001\u0010\u00a9\u0001\"\u0006\b\u00c2\u0001\u0010\u00ab\u0001\u00a8\u0006\u00c7\u0001"}, d2={"Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity;", "Lnet/minecraft/world/entity/projectile/FishingHook;", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Lnet/minecraft/world/entity/player/Player;", "thrower", "Lnet/minecraft/resources/ResourceLocation;", "pokeRodId", "Lnet/minecraft/world/item/ItemStack;", "bait", "", "luckOfTheSea", "lure", "rodItemStack", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;IILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "builder", "", "defineSynchedData", "(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "data", "onSyncedDataUpdated", "(Lnet/minecraft/network/syncher/EntityDataAccessor;)V", "", "weight", "Lkotlin/Pair;", "calculateMinMaxCountdown", "(F)Lkotlin/Pair;", "Lnet/minecraft/core/BlockPos;", "pos", "", "isOpenOrWaterAround", "(Lnet/minecraft/core/BlockPos;)Z", "start", "end", "Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$PositionType;", "getPositionType", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$PositionType;", "(Lnet/minecraft/core/BlockPos;)Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$PositionType;", "fishingBobber", "setPlayerFishHook", "(Lnet/minecraft/world/entity/projectile/FishingHook;)V", "tickFishingLogic", "(Lnet/minecraft/core/BlockPos;)V", "stopCastingAudio", "()V", "Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;", "clientboundAddEntityPacket", "recreateFromPacket", "(Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;)V", "onClientRemoval", "player", "removeIfInvalid", "(Lnet/minecraft/world/entity/player/Player;)Z", "checkForCollision", "Lnet/minecraft/world/phys/EntityHitResult;", "entityHitResult", "onHitEntity", "(Lnet/minecraft/world/phys/EntityHitResult;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "updateHookedEntityId", "(Lnet/minecraft/world/entity/Entity;)V", "tick", "usedItem", "retrieve", "(Lnet/minecraft/world/item/ItemStack;)I", "lobPokemonTowardsTarget", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/server/level/ServerPlayer;", "lureLevel", "planSpawn", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;I)V", "noBite", "(Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "spawnAction", "spawnPokemonFromFishing", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)Z", "stack", "checkReduceBiteTime", "(Lnet/minecraft/world/item/ItemStack;)Z", "waitCountdown", "alterBiteTimeAttempt", "(ILnet/minecraft/world/item/ItemStack;)I", "getPokemonSpawnChance", "particle", "particleEntityHandler", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/resources/ResourceLocation;)V", "", "x", "y", "z", "particleCatchHandler", "(DDDLnet/minecraft/world/entity/Entity;Lnet/minecraft/resources/ResourceLocation;)V", "plannedSpawnAction", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "getPlannedSpawnAction", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "setPlannedSpawnAction", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)V", "", "lastRippleSpawnTime", "J", "rippleCooldown", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "velocityRandom", "Lnet/minecraft/util/RandomSource;", "caughtFish", "Z", "outOfOpenWaterTicks", "I", "removalTimer", "hookCountdown", "fishTravelCountdown", "fishAngle", "F", "inOpenWater", "getInOpenWater", "()Z", "setInOpenWater", "(Z)V", "hookedEntity", "Lnet/minecraft/world/entity/Entity;", "Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$State;", "state", "Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$State;", "getState", "()Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$State;", "setState", "(Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$State;)V", "luckOfTheSeaLevel", "getLuckOfTheSeaLevel", "()I", "setLuckOfTheSeaLevel", "(I)V", "getLureLevel", "setLureLevel", "Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$TypeCaught;", "typeCaught", "Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$TypeCaught;", "pokemonSpawnChance", "Lnet/minecraft/sounds/SoundEvent;", "castingSound", "Lnet/minecraft/sounds/SoundEvent;", "Lnet/minecraft/resources/ResourceLocation;", "getPokeRodId", "()Lnet/minecraft/resources/ResourceLocation;", "setPokeRodId", "(Lnet/minecraft/resources/ResourceLocation;)V", "", "lineColor", "Ljava/lang/String;", "getLineColor", "()Ljava/lang/String;", "setLineColor", "(Ljava/lang/String;)V", "usedRod", "getUsedRod", "setUsedRod", "bobberBait", "Lnet/minecraft/world/item/ItemStack;", "getBobberBait", "()Lnet/minecraft/world/item/ItemStack;", "setBobberBait", "(Lnet/minecraft/world/item/ItemStack;)V", "isCast", "setCast", "lastSpinAngle", "getLastSpinAngle", "()F", "setLastSpinAngle", "(F)V", "randomPitch", "getRandomPitch", "setRandomPitch", "randomYaw", "getRandomYaw", "setRandomYaw", "Lnet/minecraft/world/phys/Vec3;", "lastBobberPos", "Lnet/minecraft/world/phys/Vec3;", "getLastBobberPos", "()Lnet/minecraft/world/phys/Vec3;", "setLastBobberPos", "(Lnet/minecraft/world/phys/Vec3;)V", "rodStack", "getRodStack", "setRodStack", "Companion", "PositionType", "State", "TypeCaught", "common"})
@SourceDebugExtension(value={"SMAP\nPokeRodFishingBobberEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeRodFishingBobberEntity.kt\ncom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,944:1\n774#2:945\n865#2,2:946\n1761#2,3:971\n774#2:974\n865#2,2:975\n774#2:977\n865#2,2:978\n1#3:948\n40#4:949\n41#4,6:953\n47#4:961\n17#5,2:950\n19#5:960\n14#5,5:962\n19#5:970\n13805#6:952\n13806#6:959\n13805#6:967\n13806#6:969\n14#7:968\n*S KotlinDebug\n*F\n+ 1 PokeRodFishingBobberEntity.kt\ncom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity\n*L\n376#1:945\n376#1:946,2\n888#1:971,3\n894#1:974\n894#1:975,2\n907#1:977\n907#1:978,2\n676#1:949\n676#1:953,6\n676#1:961\n676#1:950,2\n676#1:960\n860#1:962,5\n860#1:970\n676#1:952\n676#1:959\n860#1:967\n860#1:969\n860#1:968\n*E\n"})
public final class PokeRodFishingBobberEntity
extends FishingHook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SpawnAction<?> plannedSpawnAction;
    private long lastRippleSpawnTime;
    private final long rippleCooldown;
    private final RandomSource velocityRandom;
    private boolean caughtFish;
    private int outOfOpenWaterTicks;
    private int removalTimer;
    private int hookCountdown;
    private int waitCountdown;
    private int fishTravelCountdown;
    private float fishAngle;
    private boolean inOpenWater;
    @Nullable
    private Entity hookedEntity;
    @NotNull
    private State state;
    private int luckOfTheSeaLevel;
    private int lureLevel;
    @NotNull
    private TypeCaught typeCaught;
    private final int pokemonSpawnChance;
    @NotNull
    private final SoundEvent castingSound;
    @Nullable
    private ResourceLocation pokeRodId;
    @NotNull
    private String lineColor;
    @Nullable
    private ResourceLocation usedRod;
    @NotNull
    private ItemStack bobberBait;
    private boolean isCast;
    private float lastSpinAngle;
    private float randomPitch;
    private float randomYaw;
    @Nullable
    private Vec3 lastBobberPos;
    @Nullable
    private ItemStack rodStack;
    private static final EntityDataAccessor<String> POKEROD_ID = SynchedEntityData.defineId(PokeRodFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<ItemStack> POKEBOBBER_BAIT = SynchedEntityData.defineId(PokeRodFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> HOOK_ENTITY_ID = SynchedEntityData.defineId(PokeRodFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CAUGHT_FISH = SynchedEntityData.defineId(PokeRodFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ResourceKey<LootTable> LOOT_TABLE_ID = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)MiscUtilsKt.cobblemonResource("fishing/pokerod"));

    public PokeRodFishingBobberEntity(@NotNull EntityType<? extends PokeRodFishingBobberEntity> type, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.rippleCooldown = 20L;
        this.velocityRandom = RandomSource.create();
        this.inOpenWater = true;
        this.state = State.FLYING;
        this.typeCaught = TypeCaught.ITEM;
        this.pokemonSpawnChance = 85;
        this.castingSound = CobblemonSounds.FISHING_ROD_CAST;
        this.lineColor = "000000";
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.bobberBait = itemStack;
    }

    @Nullable
    public final SpawnAction<?> getPlannedSpawnAction() {
        return this.plannedSpawnAction;
    }

    public final void setPlannedSpawnAction(@Nullable SpawnAction<?> spawnAction) {
        this.plannedSpawnAction = spawnAction;
    }

    public final boolean getInOpenWater() {
        return this.inOpenWater;
    }

    public final void setInOpenWater(boolean bl) {
        this.inOpenWater = bl;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    public final int getLuckOfTheSeaLevel() {
        return this.luckOfTheSeaLevel;
    }

    public final void setLuckOfTheSeaLevel(int n) {
        this.luckOfTheSeaLevel = n;
    }

    public final int getLureLevel() {
        return this.lureLevel;
    }

    public final void setLureLevel(int n) {
        this.lureLevel = n;
    }

    @Nullable
    public final ResourceLocation getPokeRodId() {
        return this.pokeRodId;
    }

    public final void setPokeRodId(@Nullable ResourceLocation resourceLocation) {
        this.pokeRodId = resourceLocation;
    }

    @NotNull
    public final String getLineColor() {
        return this.lineColor;
    }

    public final void setLineColor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lineColor = string;
    }

    @Nullable
    public final ResourceLocation getUsedRod() {
        return this.usedRod;
    }

    public final void setUsedRod(@Nullable ResourceLocation resourceLocation) {
        this.usedRod = resourceLocation;
    }

    @NotNull
    public final ItemStack getBobberBait() {
        return this.bobberBait;
    }

    public final void setBobberBait(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.bobberBait = itemStack;
    }

    public final boolean isCast() {
        return this.isCast;
    }

    public final void setCast(boolean bl) {
        this.isCast = bl;
    }

    public final float getLastSpinAngle() {
        return this.lastSpinAngle;
    }

    public final void setLastSpinAngle(float f) {
        this.lastSpinAngle = f;
    }

    public final float getRandomPitch() {
        return this.randomPitch;
    }

    public final void setRandomPitch(float f) {
        this.randomPitch = f;
    }

    public final float getRandomYaw() {
        return this.randomYaw;
    }

    public final void setRandomYaw(float f) {
        this.randomYaw = f;
    }

    @Nullable
    public final Vec3 getLastBobberPos() {
        return this.lastBobberPos;
    }

    public final void setLastBobberPos(@Nullable Vec3 vec3) {
        this.lastBobberPos = vec3;
    }

    @Nullable
    public final ItemStack getRodStack() {
        return this.rodStack;
    }

    public final void setRodStack(@Nullable ItemStack itemStack) {
        this.rodStack = itemStack;
    }

    public PokeRodFishingBobberEntity(@NotNull Player thrower, @NotNull ResourceLocation pokeRodId, @NotNull ItemStack bait, @NotNull Level world, int luckOfTheSea, int lure, @NotNull ItemStack rodItemStack) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)pokeRodId, (String)"pokeRodId");
        Intrinsics.checkNotNullParameter((Object)bait, (String)"bait");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rodItemStack, (String)"rodItemStack");
        this(CobblemonEntities.POKE_BOBBER, world);
        this.setOwner((Entity)thrower);
        this.rodStack = rodItemStack;
        this.luckOfTheSeaLevel = luckOfTheSea;
        this.lureLevel = lure;
        this.pokeRodId = pokeRodId;
        this.bobberBait = bait;
        this.entityData.set(POKEROD_ID, (Object)pokeRodId.toString());
        this.entityData.set(POKEBOBBER_BAIT, (Object)this.bobberBait);
        this.entityData.set(HOOK_ENTITY_ID, (Object)0);
        this.entityData.set(CAUGHT_FISH, (Object)false);
        this.usedRod = pokeRodId;
        float throwerPitch = thrower.getXRot();
        float throwerYaw = thrower.getYRot();
        float cosYaw = Mth.cos((float)(-throwerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.sin((float)(-throwerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -Mth.cos((float)(-throwerPitch * ((float)Math.PI / 180)));
        float sinPitch = Mth.sin((float)(-throwerPitch * ((float)Math.PI / 180)));
        double posX = thrower.getX() - (double)sinYaw * 0.3;
        double posY = thrower.getEyeY();
        double posZ = thrower.getZ() - (double)cosYaw * 0.3;
        this.moveTo(posX, posY, posZ, throwerYaw, throwerPitch);
        Vec3 vec3d = new Vec3((double)(-sinYaw), (double)Mth.clamp((float)(-(sinPitch / cosPitch)), (float)-5.0f, (float)5.0f), (double)(-cosYaw));
        double m = vec3d.length();
        Vec3 vec3 = vec3d.multiply(0.6 / m + this.random.triangle(0.5, 0.0103365), 0.6 / m + this.random.triangle(0.5, 0.0103365), 0.6 / m + this.random.triangle(0.5, 0.0103365));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"multiply(...)");
        vec3d = vec3;
        this.setDeltaMovement(vec3d);
        this.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3d.y, (double)vec3d.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(HOOK_ENTITY_ID, (Object)0);
        builder.define(CAUGHT_FISH, (Object)false);
        builder.define(POKEROD_ID, (Object)"");
        builder.define(POKEBOBBER_BAIT, (Object)ItemStack.EMPTY);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (Intrinsics.areEqual(HOOK_ENTITY_ID, data)) {
            Object object = this.entityData.get(HOOK_ENTITY_ID);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            int i = (Integer)object;
            Entity entity = this.hookedEntity = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (Intrinsics.areEqual(CAUGHT_FISH, data)) {
            Object object = this.entityData.get(CAUGHT_FISH);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.caughtFish = (Boolean)object;
            if (this.caughtFish) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat((RandomSource)this.velocityRandom, (float)0.3f, (float)0.5f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(data);
    }

    @NotNull
    public final Pair<Integer, Integer> calculateMinMaxCountdown(float weight) {
        int minAtMaxWeight = 20;
        int maxAtMaxWeight = 40;
        int minAtMinWeight = 15;
        int maxAtMinWeight = 20;
        float minFactor = (float)(minAtMaxWeight - minAtMinWeight) / 100.0f * weight + (float)minAtMinWeight;
        float maxFactor = (float)(maxAtMaxWeight - maxAtMinWeight) / 100.0f * weight + (float)maxAtMinWeight;
        int min = RangesKt.coerceIn((int)((int)minFactor), (int)minAtMinWeight, (int)minAtMaxWeight);
        int max = RangesKt.coerceIn((int)((int)maxFactor), (int)maxAtMinWeight, (int)maxAtMaxWeight);
        return new Pair((Object)min, (Object)max);
    }

    public final boolean isOpenOrWaterAround(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        PositionType positionType = PositionType.INVALID;
        for (int i = -1; i < 3; ++i) {
            PositionType positionType2;
            BlockPos blockPos = pos.offset(-2, i, -2);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            BlockPos blockPos2 = pos.offset(2, i, 2);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
            PositionType positionType3 = positionType2 = this.getPositionType(blockPos, blockPos2);
            switch (positionType3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[positionType3.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    if (positionType != PositionType.INVALID) break;
                    return false;
                }
                case 3: {
                    if (positionType != PositionType.ABOVE_WATER) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            positionType = positionType2;
        }
        return true;
    }

    private final PositionType getPositionType(BlockPos start, BlockPos end) {
        return BlockPos.betweenClosedStream((BlockPos)start, (BlockPos)end).map(arg_0 -> PokeRodFishingBobberEntity.getPositionType$lambda$1(arg_0 -> PokeRodFishingBobberEntity.getPositionType$lambda$0(this, arg_0), arg_0)).reduce(PokeRodFishingBobberEntity::getPositionType$lambda$2).orElse(PositionType.INVALID);
    }

    private final PositionType getPositionType(BlockPos pos) {
        FluidState fluidState;
        BlockState blockState = this.level().getBlockState(pos);
        return !blockState.isAir() && !blockState.is(Blocks.LILY_PAD) ? ((fluidState = blockState.getFluidState()).is(FluidTags.WATER) && fluidState.isSource() && blockState.getCollisionShape((BlockGetter)this.level(), pos).isEmpty() ? PositionType.INSIDE_WATER : PositionType.INVALID) : PositionType.ABOVE_WATER;
    }

    private final void setPlayerFishHook(FishingHook fishingBobber) {
        Player playerEntity = this.getPlayerOwner();
        if (playerEntity != null) {
            playerEntity.fishing = fishingBobber;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tickFishingLogic(BlockPos pos) {
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverWorld = (ServerLevel)level;
        int i = 1;
        BlockPos blockPos = pos.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockPos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockPos)) {
            --i;
        }
        if (this.hookCountdown > 0) {
            this.hookCountdown += -1;
            if (this.hookCountdown <= 0) {
                this.waitCountdown = 0;
                this.fishTravelCountdown = 0;
                this.entityData.set(CAUGHT_FISH, (Object)false);
            }
        } else if (this.fishTravelCountdown > 0) {
            this.fishTravelCountdown -= i;
            if (this.fishTravelCountdown > 0) {
                double j;
                double offsetY;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float g = Mth.sin((float)f);
                float h = Mth.cos((float)f);
                double offsetX = this.getX() + (double)(g * (float)this.fishTravelCountdown * 0.1f);
                BlockState blockState = serverWorld.getBlockState(BlockPos.containing((double)offsetX, (double)((offsetY = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(j = this.getZ() + (double)(h * (float)this.fishTravelCountdown * 0.1f))));
                if (blockState.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverWorld.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, offsetX, offsetY - 0.1, j, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    Entity entity = (Entity)this;
                    ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"fishing_wake");
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                    this.particleCatchHandler(offsetX, offsetY, j, entity, resourceLocation);
                }
            } else {
                this.level().playSound(null, this.blockPosition(), CobblemonSounds.FISHING_NOTIFICATION, SoundSource.BLOCKS, 1.0f, 1.0f);
                Entity entity = (Entity)this;
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"bob_splash");
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                this.particleEntityHandler(entity, resourceLocation);
                Entity entity2 = (Entity)this;
                ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"fishing_bobber_big_ripple");
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
                this.particleEntityHandler(entity2, resourceLocation2);
                double m = this.getY() + 0.5;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), m, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), 0.2);
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), m, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), 0.2);
                ItemStack itemStack = this.rodStack;
                if (itemStack == null) {
                    return;
                }
                ItemStack rodStack = itemStack;
                if (Mth.nextInt((RandomSource)this.random, (int)0, (int)100) < this.getPokemonSpawnChance(rodStack)) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Object offsetY = this.getPlayerOwner();
                    ServerPlayer serverPlayer = offsetY instanceof ServerPlayer ? (ServerPlayer)offsetY : null;
                    if (serverPlayer == null) {
                        return;
                    }
                    ServerPlayer player = serverPlayer;
                    this.typeCaught = TypeCaught.POKEMON;
                    offsetY = SpawnBaitEffects.getEffectsFromItemStack(this.bobberBait);
                    boolean $i$f$filter22 = false;
                    void j = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        SpawnBait.Effect it = (SpawnBait.Effect)element$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getRARITY_BUCKET())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    double $i$f$filter22 = 0.0;
                    for (Object $i$f$filterTo2 : $this$filter$iv) {
                        void it;
                        SpawnBait.Effect effect = (SpawnBait.Effect)$i$f$filterTo2;
                        double d = $i$f$filter22;
                        boolean bl = false;
                        double d2 = it.getValue();
                        $i$f$filter22 = d + d2;
                    }
                    int stackedLureTier = (int)$i$f$filter22;
                    this.planSpawn(player, rodStack, stackedLureTier);
                    SpawnAction<?> spawnAction = this.plannedSpawnAction;
                    float selectedWeight = spawnAction != null && (spawnAction = spawnAction.getBucket()) != null ? ((SpawnBucket)((Object)spawnAction)).getWeight() : 50.0f;
                    Pair<Integer, Integer> reactionMinMax = this.calculateMinMaxCountdown(selectedWeight);
                    this.hookCountdown = Mth.nextInt((RandomSource)this.random, (int)((Number)reactionMinMax.getFirst()).intValue(), (int)((Number)reactionMinMax.getSecond()).intValue());
                } else {
                    this.typeCaught = TypeCaught.ITEM;
                    this.hookCountdown = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                }
                this.entityData.set(CAUGHT_FISH, (Object)true);
            }
        } else if (this.waitCountdown > 0) {
            this.waitCountdown -= i + this.lureLevel;
            float f = 0.15f;
            if (this.waitCountdown < 20) {
                f += (float)(20 - this.waitCountdown) * 0.05f;
            } else if (this.waitCountdown < 40) {
                f += (float)(40 - this.waitCountdown) * 0.02f;
            } else if (this.waitCountdown < 60) {
                f += (float)(60 - this.waitCountdown) * 0.01f;
            }
            if (this.random.nextFloat() < f) {
                double j;
                double e;
                float g = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float h = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double d = this.getX() + (double)(Mth.sin((float)g) * h) * 0.1;
                BlockState blockState = serverWorld.getBlockState(BlockPos.containing((double)d, (double)((e = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(j = this.getZ() + (double)(Mth.cos((float)g) * h) * 0.1)));
                if (blockState.is(Blocks.WATER)) {
                    long currentTime = serverWorld.getGameTime();
                    if (currentTime - this.lastRippleSpawnTime >= this.rippleCooldown) {
                        Entity entity = (Entity)this;
                        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"fishing_bobber_ripple");
                        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                        this.particleEntityHandler(entity, resourceLocation);
                        this.lastRippleSpawnTime = currentTime;
                    }
                    Entity entity = (Entity)this;
                    ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"fishing_surface_ripple");
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                    this.particleEntityHandler(entity, resourceLocation);
                }
            }
            if (this.waitCountdown <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.fishTravelCountdown = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            if (!this.isCast) {
                this.level().playSound(null, this.blockPosition(), CobblemonSounds.FISHING_BOBBER_LAND, SoundSource.NEUTRAL, 1.0f, 1.0f);
                Entity entity = (Entity)this;
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"bob_splash");
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                this.particleEntityHandler(entity, resourceLocation);
                this.isCast = true;
            }
            this.waitCountdown = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            if (this.waitCountdown <= 0) {
                this.waitCountdown = 1;
            } else {
                ItemStack itemStack = this.rodStack;
                if (itemStack == null) {
                    itemStack = this.bobberBait;
                }
                if (this.checkReduceBiteTime(itemStack)) {
                    ItemStack itemStack2 = this.rodStack;
                    if (itemStack2 == null) {
                        itemStack2 = this.bobberBait;
                    }
                    this.waitCountdown = this.alterBiteTimeAttempt(this.waitCountdown, itemStack2);
                }
            }
        }
    }

    public final void stopCastingAudio() {
        block1: {
            if (!this.level().isClientSide) {
                return;
            }
            Entity entity = this.getOwner();
            if (entity == null) break block1;
            Entity it = entity;
            boolean bl = false;
            Integer n = it.getId();
            ResourceLocation resourceLocation = this.castingSound.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            EntitySoundTracker.INSTANCE.stop(n, resourceLocation);
        }
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket clientboundAddEntityPacket) {
        Intrinsics.checkNotNullParameter((Object)clientboundAddEntityPacket, (String)"clientboundAddEntityPacket");
        super.recreateFromPacket(clientboundAddEntityPacket);
        Entity owner = this.getOwner();
        if (this.state == State.FLYING && owner != null) {
            EntityBoundSoundInstance toPlay = new EntityBoundSoundInstance(this.castingSound, SoundSource.PLAYERS, 1.0f, 1.0f, owner, this.random.nextLong());
            EntitySoundTracker.INSTANCE.play(owner.getId(), (SoundInstance)toPlay);
        }
    }

    public void onClientRemoval() {
        this.stopCastingAudio();
        super.onClientRemoval();
    }

    private final boolean removeIfInvalid(Player player) {
        ItemStack itemStack = player.getMainHandItem();
        ItemStack itemStack2 = player.getOffhandItem();
        boolean bl = Intrinsics.areEqual((Object)BuiltInRegistries.ITEM.get(this.usedRod), (Object)itemStack.getItem());
        boolean bl2 = Intrinsics.areEqual((Object)BuiltInRegistries.ITEM.get(this.usedRod), (Object)itemStack2.getItem());
        if (player.isRemoved() || !player.isAlive() || !bl && !bl2 || this.distanceToSqr((Entity)player) > 1024.0) {
            this.discard();
            this.isCast = false;
            return true;
        }
        return false;
    }

    private final void checkForCollision() {
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)((Entity)this), arg_0 -> PokeRodFishingBobberEntity.checkForCollision$lambda$0(this, arg_0));
        this.onHit(hitResult);
    }

    protected void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        Intrinsics.checkNotNullParameter((Object)entityHitResult, (String)"entityHitResult");
        if (!this.level().isClientSide) {
            this.updateHookedEntityId(entityHitResult.getEntity());
        }
    }

    private final void updateHookedEntityId(Entity entity) {
        this.hookedEntity = entity;
        Entity entity2 = entity;
        this.entityData.set(HOOK_ENTITY_ID, (Object)(entity2 == null ? 0 : entity2.getId() + 1));
    }

    /*
     * Unable to fully structure code
     */
    public void tick() {
        block19: {
            block21: {
                block25: {
                    block24: {
                        block22: {
                            block23: {
                                block20: {
                                    block18: {
                                        this.velocityRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
                                        playerEntity = this.getPlayerOwner();
                                        if (playerEntity != null) break block18;
                                        this.discard();
                                        break block19;
                                    }
                                    if (!this.level().isClientSide && this.removeIfInvalid(playerEntity)) break block19;
                                    if (this.onGround()) {
                                        ++this.removalTimer;
                                        if (this.removalTimer >= 1200) {
                                            this.discard();
                                            return;
                                        }
                                    } else {
                                        this.removalTimer = 0;
                                    }
                                    f = 0.0f;
                                    blockPos = this.blockPosition();
                                    fluidState = this.level().getFluidState(blockPos);
                                    if (fluidState.is(FluidTags.WATER)) {
                                        f = fluidState.getHeight((BlockGetter)this.level(), blockPos);
                                    }
                                    v0 = bl = f > 0.0f;
                                    if (Intrinsics.areEqual((Object)this.lastBobberPos, (Object)this.position())) {
                                        this.stopCastingAudio();
                                    }
                                    this.lastBobberPos = this.position();
                                    if (this.state != State.FLYING) break block20;
                                    if (this.hookedEntity != null) {
                                        this.setDeltaMovement(Vec3.ZERO);
                                        this.state = State.HOOKED_IN_ENTITY;
                                        return;
                                    }
                                    if (bl) {
                                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                                        this.state = State.BOBBING;
                                        return;
                                    }
                                    this.checkForCollision();
                                    break block21;
                                }
                                if (this.state != State.HOOKED_IN_ENTITY) break block22;
                                if (this.hookedEntity == null) break block23;
                                v1 = this.hookedEntity;
                                Intrinsics.checkNotNull((Object)v1);
                                if (v1.isRemoved()) ** GOTO lbl-1000
                                v2 = this.hookedEntity;
                                Intrinsics.checkNotNull((Object)v2);
                                if (v2.level().dimension() == this.level().dimension()) {
                                    v3 = this.hookedEntity;
                                    Intrinsics.checkNotNull((Object)v3);
                                    v4 = v3.getX();
                                    v5 = this.hookedEntity;
                                    Intrinsics.checkNotNull((Object)v5);
                                    v6 = v5.getY(0.8);
                                    v7 = this.hookedEntity;
                                    Intrinsics.checkNotNull((Object)v7);
                                    this.setPos(v4, v6, v7.getZ());
                                } else lbl-1000:
                                // 2 sources

                                {
                                    this.updateHookedEntityId(null);
                                    this.state = State.FLYING;
                                }
                            }
                            return;
                        }
                        if (this.state != State.BOBBING) break block21;
                        this.stopCastingAudio();
                        vec3d = this.getDeltaMovement();
                        d = this.getY() + vec3d.y - (double)blockPos.getY() - (double)f;
                        if (Math.abs(d) < 0.01) {
                            d += Math.signum(d) * 0.1;
                        }
                        this.setDeltaMovement(vec3d.x * 0.9, vec3d.y - d * (double)this.random.nextFloat() * 0.2, vec3d.z * 0.9);
                        if (this.hookCountdown > 0 || this.fishTravelCountdown > 0) break block24;
                        v8 = true;
                        break block25;
                    }
                    if (!this.inOpenWater || this.outOfOpenWaterTicks >= 10) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)blockPos);
                    if (this.isOpenOrWaterAround(blockPos)) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = this.inOpenWater = false;
                    }
                }
                if (bl) {
                    this.outOfOpenWaterTicks = Math.max(0, this.outOfOpenWaterTicks - 1);
                    if (this.caughtFish) {
                        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.velocityRandom.nextFloat() * (double)this.velocityRandom.nextFloat(), 0.0));
                    }
                    if (!this.level().isClientSide) {
                        Intrinsics.checkNotNull((Object)blockPos);
                        this.tickFishingLogic(blockPos);
                    }
                } else {
                    this.outOfOpenWaterTicks = Math.min(10, this.outOfOpenWaterTicks + 1);
                }
            }
            if (!fluidState.is(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.state == State.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int retrieve(@NotNull ItemStack usedItem) {
        int n;
        Intrinsics.checkNotNullParameter((Object)usedItem, (String)"usedItem");
        this.stopCastingAudio();
        Player playerEntity = this.getPlayerOwner();
        this.isCast = false;
        if (!this.level().isClientSide && playerEntity != null && !this.removeIfInvalid(playerEntity)) {
            void var3_3;
            this.isCast = false;
            int i = 0;
            if (this.hookedEntity != null) {
                Entity entity = this.hookedEntity;
                Intrinsics.checkNotNull((Object)entity);
                this.pullEntity(entity);
                ServerPlayer it = (ServerPlayer)playerEntity;
                boolean bl = false;
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger(it, usedItem, (FishingHook)this, (Collection)CollectionsKt.emptyList());
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.hookCountdown > 0) {
                if (this.typeCaught == TypeCaught.ITEM) {
                    Entity owner = this.getOwner();
                    if (owner != null) {
                        LootParams.Builder it;
                        Level level = this.level();
                        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        LootParams.Builder it2 = it = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)usedItem).withParameter(LootContextParams.THIS_ENTITY, (Object)this);
                        boolean bl = false;
                        if (Cobblemon.INSTANCE.getImplementation().getModAPI() != ModAPI.FABRIC) {
                            it2.withParameter(LootContextParams.ATTACKING_ENTITY, (Object)owner);
                        }
                        LootParams lootContextParameterSet = it.create(LootContextParamSets.FISHING);
                        MinecraftServer minecraftServer = this.level().getServer();
                        Intrinsics.checkNotNull((Object)minecraftServer);
                        LootTable lootTable = minecraftServer.reloadableRegistries().getLootTable(LOOT_TABLE_ID);
                        ObjectArrayList objectArrayList = lootTable.getRandomItems(lootContextParameterSet);
                        Intrinsics.checkNotNullExpressionValue((Object)objectArrayList, (String)"getRandomItems(...)");
                        List list = (List)objectArrayList;
                        CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)playerEntity, usedItem, (FishingHook)this, (Collection)list);
                        for (Object e : list) {
                            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type net.minecraft.world.item.ItemStack");
                            ItemStack itemStack2 = (ItemStack)e;
                            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack2);
                            double d = ((ServerPlayer)playerEntity).getX() - this.getX();
                            double e2 = ((ServerPlayer)playerEntity).getY() - this.getY();
                            double f = ((ServerPlayer)playerEntity).getZ() - this.getZ();
                            itemEntity.setDeltaMovement(d * 0.1, e2 * 0.1 + Math.sqrt(Math.sqrt(d * d + e2 * e2 + f * f)) * 0.08, f * 0.1);
                            this.level().addFreshEntity((Entity)itemEntity);
                            ((ServerPlayer)playerEntity).level().addFreshEntity((Entity)new ExperienceOrb(((ServerPlayer)playerEntity).level(), ((ServerPlayer)playerEntity).getX(), ((ServerPlayer)playerEntity).getY() + 0.5, ((ServerPlayer)playerEntity).getZ() + 0.5, this.random.nextInt(6) + 1));
                            if (!itemStack2.is(ItemTags.FISHES)) continue;
                            ((ServerPlayer)playerEntity).awardStat(Stats.FISH_CAUGHT, 1);
                        }
                        i = 1;
                    }
                } else {
                    Player player = this.getPlayerOwner();
                    Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                    ServerPlayer bobberOwner = (ServerPlayer)player;
                    SpawnAction<?> spawnAction = this.plannedSpawnAction;
                    if (spawnAction == null) {
                        this.noBite(bobberOwner);
                    } else {
                        void this_$iv$iv;
                        void event$iv;
                        void this_$iv;
                        CancelableObservable<BobberSpawnPokemonEvent.Pre> lootTable = CobblemonEvents.BOBBER_SPAWN_POKEMON_PRE;
                        ItemStack itemStack = this.rodStack;
                        Intrinsics.checkNotNull((Object)itemStack);
                        Cancelable list = new BobberSpawnPokemonEvent.Pre(this, spawnAction, itemStack);
                        boolean $i$f$postThen = false;
                        EventObservable itemStack2 = (EventObservable)this_$iv;
                        Cancelable[] itemEntity = new Cancelable[]{event$iv};
                        Cancelable[] events$iv$iv = itemEntity;
                        boolean $i$f$post = false;
                        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
                        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
                        boolean $i$f$forEach = false;
                        int n2 = $this$forEach$iv$iv$iv.length;
                        for (int j = 0; j < n2; ++j) {
                            BobberSpawnPokemonEvent.Pre event;
                            Cancelable element$iv$iv$iv;
                            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                            boolean bl = false;
                            if (it$iv.isCanceled()) {
                                event = (BobberSpawnPokemonEvent.Pre)it$iv;
                                boolean bl2 = false;
                                return 0;
                            }
                            event = (BobberSpawnPokemonEvent.Pre)it$iv;
                            boolean bl3 = false;
                            ItemStack itemStack3 = this.rodStack;
                            Intrinsics.checkNotNull((Object)itemStack3);
                            if (this.spawnPokemonFromFishing(bobberOwner, itemStack3, spawnAction)) {
                                ItemStack itemStack4 = this.rodStack;
                                Intrinsics.checkNotNull((Object)itemStack4);
                                PokerodItem.Companion.consumeBait(itemStack4);
                            }
                            Level level = this.level();
                            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            ServerLevel serverWorld = (ServerLevel)level;
                            float g = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                            float h = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                            double partX = this.getX() + (double)(Mth.sin((float)g) * h) * 0.1;
                            serverWorld.sendParticles((ParticleOptions)ParticleTypes.SPLASH, partX, this.getY(), this.getZ(), 6 + this.random.nextInt(4), 0.0, 0.2, 0.0, 0.0);
                            playerEntity.level().addFreshEntity((Entity)new ExperienceOrb(playerEntity.level(), playerEntity.getX(), playerEntity.getY() + 0.5, playerEntity.getZ() + 0.5, this.random.nextInt(6) + 1));
                            i = 1;
                        }
                    }
                }
            }
            if (this.onGround()) {
                i = 2;
            }
            this.discard();
            n = var3_3;
        } else {
            this.isCast = false;
            n = 0;
        }
        return n;
    }

    public final void lobPokemonTowardsTarget(@NotNull Player player, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double rad = Math.toRadians(player.getYRot());
        Vec3 targetDirection = new Vec3(-Math.sin(rad), 0.0, Math.cos(rad));
        Vec3 targetPos = player.position().add(targetDirection.scale(5.0));
        Vec3 delta = targetPos.subtract(entity.position());
        double horizontalDistance = Math.sqrt(delta.x * delta.x + delta.z * delta.z);
        double dampingFactor = 1.0 - RangesKt.coerceIn((double)(horizontalDistance / (double)80), (double)0.0, (double)0.8);
        double verticalVelocity = 0.3;
        double horizontalVelocityFactor = 0.13;
        double adjustedHorizontalVelocity = horizontalDistance * horizontalVelocityFactor * dampingFactor;
        double adjustedVerticalVelocity = (verticalVelocity + horizontalDistance * 0.05) * dampingFactor;
        double velocityX = delta.x / horizontalDistance * adjustedHorizontalVelocity;
        double velocityZ = delta.z / horizontalDistance * adjustedHorizontalVelocity;
        double velocityY = adjustedVerticalVelocity;
        Vec3 tossVelocity = new Vec3(velocityX, velocityY, velocityZ);
        entity.setDeltaMovement(tossVelocity);
    }

    private final void planSpawn(ServerPlayer player, ItemStack rodItemStack, int lureLevel) {
        BasicSpawner spawner = BestSpawner.INSTANCE.getFishingSpawner();
        BucketNormalizingInfluence bucketInfluence = new BucketNormalizingInfluence(lureLevel + this.luckOfTheSeaLevel, 0.0f, 0.0f, 6, null);
        FishingSpawnCause spawnCause = new FishingSpawnCause((Spawner)spawner, (Entity)player, rodItemStack, lureLevel);
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Object[] objectArray = new SpawningInfluence[]{new PlayerLevelRangeInfluence(player, PlayerLevelRangeInfluence.Companion.getTYPICAL_VARIATION(), null, 0L, 12, null), bucketInfluence};
        FishingSpawnablePosition spawnablePosition = new FishingSpawnablePosition(spawnCause, serverLevel, Vec3ExtensionsKt.toBlockPos(vec3), CollectionsKt.mutableListOf((Object[])objectArray));
        SpawnAction<?> result = spawner.calculateSpawnActionForPosition(spawnCause, spawnablePosition);
        this.plannedSpawnAction = result;
    }

    private final void noBite(ServerPlayer player) {
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("fishing.no_bite", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        player.sendSystemMessage((Component)TextKt.red(mutableComponent));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean spawnPokemonFromFishing(@NotNull ServerPlayer player, @NotNull ItemStack rodItemStack, @NotNull SpawnAction<?> spawnAction) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rodItemStack, (String)"rodItemStack");
        Intrinsics.checkNotNullParameter(spawnAction, (String)"spawnAction");
        Integer hookedEntityID = null;
        spawnAction.complete();
        CompletableFuture<?> result = spawnAction.getFuture();
        if (result.isCompletedExceptionally()) {
            this.noBite(player);
            return false;
        }
        Ref.ObjectRef spawnedPokemon = new Ref.ObjectRef();
        Object resultingSpawn = result.get();
        if (resultingSpawn instanceof EntitySpawnResult) {
            for (Entity entity : ((EntitySpawnResult)resultingSpawn).getEntities()) {
                void events$iv;
                void $this$iv;
                hookedEntityID = entity.getId();
                Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.entity.pokemon.PokemonEntity");
                spawnedPokemon.element = (PokemonEntity)entity;
                Entity entity2 = (Entity)this;
                ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"accessory_fish_splash");
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
                this.particleEntityHandler(entity2, resourceLocation);
                ResourceLocation baitId = this.bobberBait.isEmpty() ? ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default("empty_bait", null, 1, null) : this.bobberBait.getItemHolder().unwrapKey().map(arg_0 -> PokeRodFishingBobberEntity.spawnPokemonFromFishing$lambda$1(PokeRodFishingBobberEntity::spawnPokemonFromFishing$lambda$0, arg_0)).orElse(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default("empty_bait", null, 1, null));
                ResourceLocation pokemonId = ((PokemonEntity)spawnedPokemon.element).getPokemon().getSpecies().getResourceIdentifier();
                Intrinsics.checkNotNull((Object)baitId);
                CobblemonCriteria.REEL_IN_POKEMON.trigger(player, new ReelInPokemonContext(pokemonId, baitId));
                if ((double)((PokemonEntity)spawnedPokemon.element).getPokemon().getSpecies().getWeight() < 900.0) {
                    this.level().playSound(null, this.blockPosition(), CobblemonSounds.FISHING_SPLASH_SMALL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    Entity entity3 = (Entity)this;
                    ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"small_fish_splash");
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
                    this.particleEntityHandler(entity3, resourceLocation2);
                    this.lobPokemonTowardsTarget((Player)player, entity);
                } else {
                    Entity entity4 = (Entity)this;
                    ResourceLocation resourceLocation3 = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"big_fish_splash");
                    Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"fromNamespaceAndPath(...)");
                    this.particleEntityHandler(entity4, resourceLocation3);
                    this.level().playSound(null, this.blockPosition(), CobblemonSounds.FISHING_SPLASH_BIG, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                EventObservable<BobberSpawnPokemonEvent.Post> eventObservable = CobblemonEvents.BOBBER_SPAWN_POKEMON_POST;
                BobberSpawnPokemonEvent.Post[] postArray = new BobberSpawnPokemonEvent.Post[]{new BobberSpawnPokemonEvent.Post(this, spawnAction, this.bobberBait, (PokemonEntity)entity)};
                boolean $i$f$post = false;
                $this$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
                void $this$forEach$iv$iv = events$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void var20_20 = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl = false;
                    void it = var20_20;
                }
            }
        }
        if (hookedEntityID != null) {
            this.hookedEntity = this.level().getEntity(hookedEntityID.intValue());
        }
        SchedulingFunctionsKt.afterOnServer(1.0f, (Function0<Unit>)((Function0)() -> PokeRodFishingBobberEntity.spawnPokemonFromFishing$lambda$2(player, spawnedPokemon)));
        return true;
    }

    public final boolean checkReduceBiteTime(@NotNull ItemStack stack) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            List<SpawnBait.Effect> effects = SpawnBaitEffects.getEffectsFromRodItemStack(stack);
            Iterable $this$any$iv = effects;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SpawnBait.Effect it = (SpawnBait.Effect)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getBITE_TIME())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int alterBiteTimeAttempt(int waitCountdown, @NotNull ItemStack stack) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List<SpawnBait.Effect> effects = SpawnBaitEffects.getEffectsFromRodItemStack(stack);
        Iterable $this$filter$iv = effects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawnBait.Effect it = (SpawnBait.Effect)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getBITE_TIME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        SpawnBait.Effect effect = (SpawnBait.Effect)CollectionsKt.random((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default));
        if (Math.random() > effect.getChance()) {
            return waitCountdown;
        }
        return (double)waitCountdown - (double)waitCountdown * effect.getValue() <= 0.0 ? 1 : (int)((double)waitCountdown - (double)waitCountdown * effect.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public final int getPokemonSpawnChance(@NotNull ItemStack stack) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List<SpawnBait.Effect> effects = SpawnBaitEffects.getEffectsFromRodItemStack(stack);
        Iterable $this$filter$iv = effects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpawnBait.Effect it = (SpawnBait.Effect)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getPOKEMON_CHANCE())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List effectList = (List)destination$iv$iv;
        if (effectList.isEmpty()) {
            return this.pokemonSpawnChance;
        }
        SpawnBait.Effect effect = (SpawnBait.Effect)CollectionsKt.random((Collection)effectList, (Random)((Random)Random.Default));
        return effect.getChance() >= 0.0 && effect.getChance() <= 100.0 ? (int)(effect.getChance() * (double)100) : this.pokemonSpawnChance;
    }

    private final void particleEntityHandler(Entity entity, ResourceLocation particle) {
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        SpawnSnowstormParticlePacket spawnSnowstormParticlePacket = new SpawnSnowstormParticlePacket(particle, vec3);
        NetworkPacket networkPacket = spawnSnowstormParticlePacket;
        double d = entity.getX();
        double d2 = entity.getY();
        double d3 = entity.getZ();
        ResourceKey resourceKey = entity.level().dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 64.0, resourceKey, null, 32, null);
    }

    private final void particleCatchHandler(double x, double y, double z, Entity entity, ResourceLocation particle) {
        Vec3 particlePosition = new Vec3(x, y, z);
        SpawnSnowstormParticlePacket spawnSnowstormParticlePacket = new SpawnSnowstormParticlePacket(particle, particlePosition);
        NetworkPacket networkPacket = spawnSnowstormParticlePacket;
        double d = entity.getX();
        double d2 = entity.getY();
        double d3 = entity.getZ();
        ResourceKey resourceKey = entity.level().dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 64.0, resourceKey, null, 32, null);
    }

    private static final PositionType getPositionType$lambda$0(PokeRodFishingBobberEntity this$0, BlockPos pos) {
        Intrinsics.checkNotNull((Object)pos);
        return this$0.getPositionType(pos);
    }

    private static final PositionType getPositionType$lambda$1(Function1 $tmp0, Object p0) {
        return (PositionType)((Object)$tmp0.invoke(p0));
    }

    private static final PositionType getPositionType$lambda$2(PositionType positionType, PositionType positionType2) {
        return positionType == positionType2 ? positionType : PositionType.INVALID;
    }

    private static final boolean checkForCollision$lambda$0(PokeRodFishingBobberEntity this$0, Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this$0.canHitEntity(entity);
    }

    private static final ResourceLocation spawnPokemonFromFishing$lambda$0(ResourceKey it) {
        return it.location();
    }

    private static final ResourceLocation spawnPokemonFromFishing$lambda$1(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final Unit spawnPokemonFromFishing$lambda$2(ServerPlayer $player, Ref.ObjectRef $spawnedPokemon) {
        block1: {
            List list = $player.level().players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            if (!CollectionsKt.contains((Iterable)list, (Object)$player)) {
                return Unit.INSTANCE;
            }
            PokemonEntity pokemonEntity = (PokemonEntity)$spawnedPokemon.element;
            if (pokemonEntity == null) break block1;
            pokemonEntity.forceBattle($player);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR;\u0010\f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\b\u001a\u0004\b\r\u0010\nR;\u0010\u000f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\nR8\u0010\u0012\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00110\u0011 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\bR8\u0010\u0015\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u0014 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00130\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "POKEROD_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getPOKEROD_ID", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/item/ItemStack;", "POKEBOBBER_BAIT", "getPOKEBOBBER_BAIT", "", "HOOK_ENTITY_ID", "getHOOK_ENTITY_ID", "", "CAUGHT_FISH", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/storage/loot/LootTable;", "LOOT_TABLE_ID", "Lnet/minecraft/resources/ResourceKey;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final EntityDataAccessor<String> getPOKEROD_ID() {
            return POKEROD_ID;
        }

        public final EntityDataAccessor<ItemStack> getPOKEBOBBER_BAIT() {
            return POKEBOBBER_BAIT;
        }

        public final EntityDataAccessor<Integer> getHOOK_ENTITY_ID() {
            return HOOK_ENTITY_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$PositionType;", "", "<init>", "(Ljava/lang/String;I)V", "ABOVE_WATER", "INSIDE_WATER", "INVALID", "common"})
    public static final class PositionType
    extends Enum<PositionType> {
        public static final /* enum */ PositionType ABOVE_WATER = new PositionType();
        public static final /* enum */ PositionType INSIDE_WATER = new PositionType();
        public static final /* enum */ PositionType INVALID = new PositionType();
        private static final /* synthetic */ PositionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PositionType[] values() {
            return (PositionType[])$VALUES.clone();
        }

        public static PositionType valueOf(String value) {
            return Enum.valueOf(PositionType.class, value);
        }

        @NotNull
        public static EnumEntries<PositionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionTypeArray = new PositionType[]{PositionType.ABOVE_WATER, PositionType.INSIDE_WATER, PositionType.INVALID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$State;", "", "<init>", "(Ljava/lang/String;I)V", "FLYING", "HOOKED_IN_ENTITY", "BOBBING", "common"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State FLYING = new State();
        public static final /* enum */ State HOOKED_IN_ENTITY = new State();
        public static final /* enum */ State BOBBING = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.FLYING, State.HOOKED_IN_ENTITY, State.BOBBING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/cobblemon/mod/common/entity/fishing/PokeRodFishingBobberEntity$TypeCaught;", "", "<init>", "(Ljava/lang/String;I)V", "ITEM", "POKEMON", "common"})
    public static final class TypeCaught
    extends Enum<TypeCaught> {
        public static final /* enum */ TypeCaught ITEM = new TypeCaught();
        public static final /* enum */ TypeCaught POKEMON = new TypeCaught();
        private static final /* synthetic */ TypeCaught[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TypeCaught[] values() {
            return (TypeCaught[])$VALUES.clone();
        }

        public static TypeCaught valueOf(String value) {
            return Enum.valueOf(TypeCaught.class, value);
        }

        @NotNull
        public static EnumEntries<TypeCaught> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeCaughtArray = new TypeCaught[]{TypeCaught.ITEM, TypeCaught.POKEMON};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PositionType.values().length];
            try {
                nArray[PositionType.INVALID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionType.ABOVE_WATER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PositionType.INSIDE_WATER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

