/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.datafixer.fix;

import com.cobblemon.mod.common.datafixer.fix.PokemonFix;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000b\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/datafixer/fix/NicknameFix;", "Lcom/cobblemon/mod/common/datafixer/fix/PokemonFix;", "Lcom/mojang/datafixers/schemas/Schema;", "outputSchema", "<init>", "(Lcom/mojang/datafixers/schemas/Schema;)V", "Lcom/mojang/serialization/Dynamic;", "dynamic", "fixPokemonData", "(Lcom/mojang/serialization/Dynamic;)Lcom/mojang/serialization/Dynamic;", "T", "Lcom/mojang/serialization/DynamicOps;", "ops", "Lcom/google/gson/JsonElement;", "asJsonOps", "(Lcom/mojang/serialization/DynamicOps;)Lcom/mojang/serialization/DynamicOps;", "common"})
public final class NicknameFix
extends PokemonFix {
    public NicknameFix(@NotNull Schema outputSchema) {
        Intrinsics.checkNotNullParameter((Object)outputSchema, (String)"outputSchema");
        super(outputSchema);
    }

    @Override
    @NotNull
    protected Dynamic<?> fixPokemonData(@NotNull Dynamic<?> dynamic) {
        Intrinsics.checkNotNullParameter(dynamic, (String)"dynamic");
        Optional nickname = dynamic.get("Nickname").asString().result();
        if (!nickname.isPresent()) {
            return dynamic;
        }
        JsonElement jsonElement = null;
        try {
            JsonElement jsonElement2 = JsonParser.parseString((String)((String)nickname.get()));
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"parseString(...)");
            jsonElement = jsonElement2;
        }
        catch (JsonParseException jsonParseException) {
            return dynamic;
        }
        DynamicOps dynamicOps = dynamic.getOps();
        Intrinsics.checkNotNullExpressionValue((Object)dynamicOps, (String)"getOps(...)");
        ComponentSerialization.CODEC.parse(this.asJsonOps(dynamicOps), (Object)jsonElement).result().ifPresent(arg_0 -> NicknameFix.fixPokemonData$lambda$1(arg_0 -> NicknameFix.fixPokemonData$lambda$0(dynamic, this, arg_0), arg_0));
        return dynamic;
    }

    private final <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> ops) {
        DynamicOps dynamicOps;
        if (ops instanceof RegistryOps) {
            RegistryOps registryOps = ((RegistryOps)ops).withParent((DynamicOps)JsonOps.INSTANCE);
            Intrinsics.checkNotNull((Object)registryOps);
            dynamicOps = (DynamicOps)registryOps;
        } else {
            JsonOps jsonOps = JsonOps.INSTANCE;
            Intrinsics.checkNotNull((Object)jsonOps);
            dynamicOps = (DynamicOps)jsonOps;
        }
        return dynamicOps;
    }

    private static final Unit fixPokemonData$lambda$0(Dynamic $dynamic, NicknameFix this$0, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($dynamic.getValue() instanceof CompoundTag) {
            Object object = $dynamic.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            CompoundTag rootTag = (CompoundTag)object;
            DynamicOps dynamicOps = $dynamic.getOps();
            Intrinsics.checkNotNull((Object)dynamicOps, (String)"null cannot be cast to non-null type net.minecraft.resources.RegistryOps<net.minecraft.nbt.CompoundTag>");
            rootTag.put("Nickname", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)((RegistryOps)dynamicOps), (Object)it).result().get());
        } else if ($dynamic.getValue() instanceof JsonElement) {
            Object object = $dynamic.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.gson.JsonElement");
            JsonObject rootTag = ((JsonElement)object).getAsJsonObject();
            rootTag.remove("Nickname");
            DynamicOps dynamicOps = $dynamic.getOps();
            Intrinsics.checkNotNullExpressionValue((Object)dynamicOps, (String)"getOps(...)");
            rootTag.add("Nickname", (JsonElement)ComponentSerialization.CODEC.encodeStart(this$0.asJsonOps(dynamicOps), (Object)it).result().get());
        }
        return Unit.INSTANCE;
    }

    private static final void fixPokemonData$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

