/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.datafixer.fix;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatureProvider;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeatures;
import com.cobblemon.mod.common.datafixer.fix.FeatureFix;
import com.cobblemon.mod.common.datafixer.fix.PokemonFix;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0014\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/datafixer/fix/FeatureFix;", "Lcom/cobblemon/mod/common/datafixer/fix/PokemonFix;", "Lcom/mojang/datafixers/schemas/Schema;", "output", "<init>", "(Lcom/mojang/datafixers/schemas/Schema;)V", "Lcom/mojang/serialization/Dynamic;", "dynamic", "fixPokemonData", "(Lcom/mojang/serialization/Dynamic;)Lcom/mojang/serialization/Dynamic;", "common"})
@SourceDebugExtension(value={"SMAP\nFeatureFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureFix.kt\ncom/cobblemon/mod/common/datafixer/fix/FeatureFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1869#2,2:73\n1869#2,2:75\n*S KotlinDebug\n*F\n+ 1 FeatureFix.kt\ncom/cobblemon/mod/common/datafixer/fix/FeatureFix\n*L\n39#1:73,2\n57#1:75,2\n*E\n"})
public final class FeatureFix
extends PokemonFix {
    public FeatureFix(@NotNull Schema output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super(output);
    }

    @Override
    @NotNull
    protected Dynamic<?> fixPokemonData(@NotNull Dynamic<?> dynamic) {
        Intrinsics.checkNotNullParameter(dynamic, (String)"dynamic");
        DataResult features2 = dynamic.get("Features").asListOpt((Function)fixPokemonData.features.1.INSTANCE);
        if (features2.result().isPresent()) {
            return dynamic;
        }
        List featureTag = null;
        featureTag = new ArrayList();
        if (dynamic.getValue() instanceof CompoundTag) {
            CompoundTag rootTag = null;
            Object object = dynamic.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            rootTag = (CompoundTag)object;
            String string = rootTag.getString("Species");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            ResourceLocation resourceLocation = MiscUtilsKt.asResource(string);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"asResource(...)");
            Species species = PokemonSpecies.getByIdentifier(resourceLocation);
            if (species == null) {
                return dynamic;
            }
            Iterable $this$forEach$iv = SpeciesFeatures.getFeaturesFor(species);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object feature;
                SpeciesFeatureProvider it = (SpeciesFeatureProvider)element$iv;
                boolean bl = false;
                if (it.invoke(rootTag) == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.putString("cobblemon:feature_id", feature.getName());
                feature.saveToNBT(tag);
                ((Collection)featureTag).add(tag);
            }
            if (featureTag.isEmpty()) {
                return dynamic;
            }
            rootTag.put("Features", (Tag)Codec.list((Codec)CompoundTag.CODEC).encode((Object)featureTag, (DynamicOps)NbtOps.INSTANCE, (Object)NbtOps.INSTANCE.empty()).result().get());
        } else if (dynamic.getValue() instanceof JsonElement) {
            JsonObject rootTag = null;
            Object object = dynamic.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.gson.JsonElement");
            rootTag = ((JsonElement)object).getAsJsonObject();
            String string = rootTag.get("Species").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            ResourceLocation resourceLocation = MiscUtilsKt.asResource(string);
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"asResource(...)");
            Species species = PokemonSpecies.getByIdentifier(resourceLocation);
            if (species == null) {
                return dynamic;
            }
            Iterable $this$forEach$iv = SpeciesFeatures.getFeaturesFor(species);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object feature;
                SpeciesFeatureProvider it = (SpeciesFeatureProvider)element$iv;
                boolean bl = false;
                JsonObject jsonObject = rootTag;
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"element");
                if (it.invoke(jsonObject) == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.putString("cobblemon:feature_id", feature.getName());
                feature.saveToNBT(tag);
                ((Collection)featureTag).add(tag);
            }
            if (featureTag.isEmpty()) {
                return dynamic;
            }
            rootTag.add("Features", (JsonElement)Codec.list((Codec)CompoundTag.CODEC).encode((Object)featureTag, (DynamicOps)JsonOps.COMPRESSED, (Object)JsonOps.COMPRESSED.empty()).result().get());
        }
        return dynamic;
    }
}

