/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.compat.lambdynamiclights;

import com.cobblemon.mod.common.compat.lambdynamiclights.CustomLuminance;
import com.cobblemon.mod.common.compat.lambdynamiclights.LambDynamicLightsInitializer;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class PokemonLuminance
extends CustomLuminance
implements EntityLuminance {
    public static final PokemonLuminance INSTANCE = new PokemonLuminance();

    private PokemonLuminance() {
    }

    @NotNull
    public EntityLuminance.Type type() {
        return LambDynamicLightsInitializer.POKEMON_LUMINANCE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull Entity entity) {
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemon = (PokemonEntity)entity;
            boolean underwater = pokemon.isUnderWater();
            ItemStack item = pokemon.getShownItem();
            int itemLightLevel = item.isEmpty() ? 0 : itemLightSourceManager.getLuminance(item, underwater);
            int formLightLevel = PokemonLuminance.extractFormLightLevel(pokemon.getForm(), underwater).orElse(0);
            return Math.max(itemLightLevel, formLightLevel);
        }
        return 0;
    }
}

