/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.callback.PartySelectCallbacks;
import com.cobblemon.mod.common.api.callback.PartySelectPokemonDTO;
import com.cobblemon.mod.common.api.item.ability.AbilityChanger;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCClasses;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.scheduling.ScheduledTask;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.scheduling.ServerTaskTracker;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.command.TestCommand;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.trade.TradeStartedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.trade.ActiveTrade;
import com.cobblemon.mod.common.trade.DummyTradeParticipant;
import com.cobblemon.mod.common.trade.PlayerTradeParticipant;
import com.cobblemon.mod.common.trade.TradeParticipant;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.StringExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J\r\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u001d\u0010\u0017\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u000f\u0010\u001e\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\u000f\u0010\u001f\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u001d\u0010 \u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b \u0010\u0010J\u001d\u0010!\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b!\u0010\u0010J\u0017\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b#\u0010\u0014R$\u0010%\u001a\u0004\u0018\u00010$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010+\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/command/TestCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "testClosestBattle", "(Lcom/mojang/brigadier/context/CommandContext;)V", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "testTrade", "(Lnet/minecraft/server/level/ServerPlayer;)V", "testUpdate", "readBerryDataFromCSV", "testAbilitiesBetweenEvolution", "Lnet/minecraft/network/chat/Component;", "testHiddenAbilityThroughoutEvolutions", "()Lnet/minecraft/network/chat/Component;", "testMiddleStageSingleAbility", "testForcedAbility", "testIllegalAbilityNonForced", "testAbilityCapsule", "testAbilityPatch", "testCodecOutput", "testPartySelectHoverText", "player", "tryTamePokemon", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "trade", "Lcom/cobblemon/mod/common/trade/ActiveTrade;", "getTrade", "()Lcom/cobblemon/mod/common/trade/ActiveTrade;", "setTrade", "(Lcom/cobblemon/mod/common/trade/ActiveTrade;)V", "lastDebugId", "I", "getLastDebugId", "()I", "setLastDebugId", "(I)V", "common"})
@SourceDebugExtension(value={"SMAP\nTestCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestCommand.kt\ncom/cobblemon/mod/common/command/TestCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1869#2,2:456\n1869#2,2:458\n1563#2:460\n1634#2,3:461\n*S KotlinDebug\n*F\n+ 1 TestCommand.kt\ncom/cobblemon/mod/common/command/TestCommand\n*L\n79#1:456,2\n150#1:458,2\n429#1:460\n429#1:461,3\n*E\n"})
public final class TestCommand {
    @NotNull
    public static final TestCommand INSTANCE = new TestCommand();
    @Nullable
    private static ActiveTrade trade;
    private static int lastDebugId;

    private TestCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"testcommand").requires(TestCommand::register$lambda$0)).executes(this::execute);
        dispatcher.register(command);
    }

    private final int execute(CommandContext<CommandSourceStack> context) {
        if (!(((CommandSourceStack)context.getSource()).getEntity() instanceof ServerPlayer)) {
            return 1;
        }
        try {
            Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            ServerPlayer player = (ServerPlayer)entity;
            Iterable $this$forEach$iv = PlayerExtensionsKt.party(player);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pokemon it = (Pokemon)element$iv;
                boolean bl = false;
                it.setCurrentHealth(it.getHp() / 2);
            }
            Level level = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            NPCEntity npc = new NPCEntity(level);
            npc.setPos(player.getX(), player.getY(), player.getZ());
            NPCClass nPCClass = NPCClasses.INSTANCE.getByName("standard");
            Intrinsics.checkNotNull((Object)nPCClass);
            npc.setNpc(nPCClass);
            npc.initialize(50);
            player.level().addFreshEntity((Entity)npc);
        }
        catch (Exception e) {
            Cobblemon.LOGGER.error((Object)e);
        }
        return 1;
    }

    @Nullable
    public final ActiveTrade getTrade() {
        return trade;
    }

    public final void setTrade(@Nullable ActiveTrade activeTrade) {
        trade = activeTrade;
    }

    public final int getLastDebugId() {
        return lastDebugId;
    }

    public final void setLastDebugId(int n) {
        lastDebugId = n;
    }

    private final void testClosestBattle(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        List cloneTeam = PartyStore.toBattleTeam$default(PlayerExtensionsKt.party(player), true, false, null, 6, null);
        Iterable $this$forEach$iv = cloneTeam;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BattlePokemon it = (BattlePokemon)element$iv;
            boolean bl = false;
            it.getEffectedPokemon().setLevel(100);
        }
        AABB scanBox = AABB.ofSize((Vec3)player.position(), (double)9.0, (double)9.0, (double)9.0);
        List results = player.level().getEntities((EntityTypeTest)CobblemonEntities.POKEMON, scanBox, arg_0 -> TestCommand.testClosestBattle$lambda$2(TestCommand::testClosestBattle$lambda$1, arg_0));
        Intrinsics.checkNotNull((Object)results);
        PokemonEntity pokemonEntity = (PokemonEntity)CollectionsKt.firstOrNull((List)results);
        if (pokemonEntity == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Cannot find any wild Pok\u00e9mon in a 9x9x9 area"));
            return;
        }
        BattleFormat battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        BattleActor[] battleActorArray = new BattleActor[1];
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        battleActorArray[0] = new PlayerBattleActor(uUID, cloneTeam);
        BattleSide battleSide = new BattleSide(battleActorArray);
        battleActorArray = new BattleActor[1];
        UUID uUID2 = pokemonEntity.getPokemon().getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"<get-uuid>(...)");
        battleActorArray[0] = new PokemonBattleActor(uUID2, new BattlePokemon(pokemonEntity.getPokemon(), null, null, 6, null), Cobblemon.INSTANCE.getConfig().getDefaultFleeDistance(), null, 8, null);
        BattleRegistry.startBattle$default(battleFormat, battleSide, new BattleSide(battleActorArray), false, 8, null);
    }

    private final void testTrade(ServerPlayer playerEntity) {
        ActiveTrade trade;
        Object[] objectArray = new Pokemon[]{StringExtensionsKt.toPokemon("pikachu level=30 shiny"), StringExtensionsKt.toPokemon("machop level=15")};
        TestCommand.trade = trade = new ActiveTrade(new PlayerTradeParticipant(playerEntity), new DummyTradeParticipant(CollectionsKt.mutableListOf((Object[])objectArray)));
        UUID uUID = trade.getPlayer2().getUuid();
        MutableComponent mutableComponent = trade.getPlayer2().getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        CobblemonNetwork.INSTANCE.sendPacket(playerEntity, new TradeStartedPacket(uUID, mutableComponent, trade.getPlayer2().getParty().mapNullPreserving(testTrade.1.INSTANCE)));
        SchedulingFunctionsKt.taskBuilder().interval(0.5f).execute((Function1<? super ScheduledTask, Unit>)((Function1)arg_0 -> TestCommand.testTrade$lambda$0(trade, arg_0))).tracker(ServerTaskTracker.INSTANCE).iterations(Integer.MAX_VALUE).build();
    }

    private final void testUpdate() {
        ActiveTrade activeTrade = trade;
        if (activeTrade == null) {
            return;
        }
        ActiveTrade trade = activeTrade;
        TradeParticipant tradeParticipant = trade.getPlayer2();
        Intrinsics.checkNotNull((Object)tradeParticipant, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.trade.DummyTradeParticipant");
        DummyTradeParticipant dummy2 = (DummyTradeParticipant)tradeParticipant;
        int currentDebugId = 0;
        if (lastDebugId != 0) {
            lastDebugId = currentDebugId;
        }
    }

    public final void readBerryDataFromCSV() {
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        List csv = FilesKt.readLines$default((File)new File("scripty/berries.csv"), null, (int)1, null);
        Iterator iterator = csv.iterator();
        iterator.next();
        iterator.next();
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String line = (String)iterator2.next();
            String[] stringArray = new String[]{","};
            List cols = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string = ((String)cols.get(1)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String berryName = string + "_berry";
            File file = new File("scripty/old/" + berryName + ".json");
            Charset charset = Charsets.UTF_8;
            JsonObject json = (JsonObject)gson2.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset), JsonObject.class);
            List growthPoints = new ArrayList();
            for (int index = 7; cols.size() > index && !StringsKt.isBlank((CharSequence)((CharSequence)cols.get(index))); index += 6) {
                float posX = Float.parseFloat((String)cols.get(index));
                float posY = Float.parseFloat((String)cols.get(index + 1));
                float posZ = Float.parseFloat((String)cols.get(index + 2));
                float rotX = Float.parseFloat((String)cols.get(index + 3));
                float rotY = Float.parseFloat((String)cols.get(index + 4));
                float rotZ = Float.parseFloat((String)cols.get(index + 5));
                JsonObject position = new JsonObject();
                position.addProperty("x", (Number)Float.valueOf(posX));
                position.addProperty("y", (Number)Float.valueOf(posY));
                position.addProperty("z", (Number)Float.valueOf(posZ));
                JsonObject rotation = new JsonObject();
                rotation.addProperty("x", (Number)Float.valueOf(rotX));
                rotation.addProperty("y", (Number)Float.valueOf(rotY));
                rotation.addProperty("z", (Number)Float.valueOf(rotZ));
                JsonObject obj = new JsonObject();
                obj.add("position", (JsonElement)position);
                obj.add("rotation", (JsonElement)rotation);
                growthPoints.add(obj);
            }
            JsonArray arr = json.getAsJsonArray("growthPoints");
            Intrinsics.checkNotNull((Object)arr);
            CollectionsKt.removeAll((Iterable)((Iterable)arr), TestCommand::readBerryDataFromCSV$lambda$0);
            for (JsonObject point : growthPoints) {
                arr.add((JsonElement)point);
            }
            File file2 = new File("scripty/new/" + berryName + ".json");
            PrintWriter pw = new PrintWriter(file2);
            gson2.toJson((JsonElement)json, (Appendable)pw);
            pw.flush();
            pw.close();
        }
    }

    private final void testAbilitiesBetweenEvolution(CommandContext<CommandSourceStack> context) {
        MutableComponent results = Component.literal((String)"Ability test results (Assumed default assets)").append((Component)Component.literal((String)"\n")).append(this.testHiddenAbilityThroughoutEvolutions()).append((Component)Component.literal((String)"\n")).append(this.testMiddleStageSingleAbility()).append((Component)Component.literal((String)"\n")).append(this.testForcedAbility()).append((Component)Component.literal((String)"\n")).append(this.testIllegalAbilityNonForced()).append((Component)Component.literal((String)"\n")).append(this.testAbilityCapsule()).append((Component)Component.literal((String)"\n")).append(this.testAbilityPatch());
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)results);
    }

    private final Component testHiddenAbilityThroughoutEvolutions() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "dragonair level=" + Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel() + " hiddenability=true", null, null, 6, null), null, 1, null);
        Evolution evolution = (Evolution)CollectionsKt.firstOrNull(pokemon.getEvolutions());
        if (evolution == null) {
            MutableComponent mutableComponent = Component.literal((String)"\u2716 Failed to find Dragonair \u00bb Dragonite evolution");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return (Component)TextKt.red(mutableComponent);
        }
        Evolution dragonite = evolution;
        dragonite.evolutionMethod(pokemon);
        boolean failed = pokemon.getAbility().getIndex() != 0 || pokemon.getAbility().getPriority() != Priority.LOW || pokemon.getAbility().getForced();
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Dratini line final Ability(name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final Component testMiddleStageSingleAbility() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "scatterbug level=" + Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel() + " ability=compoundeyes", null, null, 6, null), null, 1, null);
        Evolution evolution = (Evolution)CollectionsKt.firstOrNull(pokemon.getEvolutions());
        if (evolution == null) {
            MutableComponent mutableComponent = Component.literal((String)"\u2716 Failed to find Scatterbug \u00bb Spewpa evolution");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return (Component)TextKt.red(mutableComponent);
        }
        Evolution spewpa = evolution;
        spewpa.evolutionMethod(pokemon);
        Evolution evolution2 = (Evolution)CollectionsKt.firstOrNull(pokemon.getEvolutions());
        if (evolution2 == null) {
            MutableComponent mutableComponent = Component.literal((String)"\u2716 Failed to find Spewpa \u00bb Vivillon evolution");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return (Component)TextKt.red(mutableComponent);
        }
        Evolution vivillon = evolution2;
        vivillon.evolutionMethod(pokemon);
        boolean failed = pokemon.getAbility().getIndex() != 1 || pokemon.getAbility().getPriority() != Priority.LOWEST || pokemon.getAbility().getForced();
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Scatterbug line final Ability(name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final Component testForcedAbility() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "magikarp level=" + Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel() + " ability=adaptability", null, null, 6, null), null, 1, null);
        Evolution evolution = (Evolution)CollectionsKt.firstOrNull(pokemon.getEvolutions());
        if (evolution == null) {
            MutableComponent mutableComponent = Component.literal((String)"\u2716 Failed to find Magikarp \u00bb Gyarados evolution");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return (Component)TextKt.red(mutableComponent);
        }
        Evolution gyarados = evolution;
        gyarados.evolutionMethod(pokemon);
        boolean failed = !pokemon.getAbility().getForced() || !Intrinsics.areEqual((Object)pokemon.getAbility().getTemplate().getName(), (Object)"adaptability");
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Magikarp line forced Ability(name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final Component testIllegalAbilityNonForced() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "rattata", null, null, 6, null), null, 1, null);
        pokemon.updateAbility(AbilityTemplate.create$default(Abilities.getOrException("adaptability"), false, null, 2, null));
        boolean failed = !pokemon.getAbility().getForced();
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Rattata illegal non-forced (name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final Component testAbilityCapsule() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "rattata", null, null, 6, null), null, 1, null);
        boolean failed = !AbilityChanger.Companion.getCOMMON_ABILITY().performChange(pokemon);
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Rattata capsule Ability(name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final Component testAbilityPatch() {
        Component component;
        Pokemon pokemon = PokemonProperties.create$default(PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "magikarp ha=true", null, null, 6, null), null, 1, null);
        boolean failed = AbilityChanger.Companion.getHIDDEN_ABILITY().performChange(pokemon);
        String symbol = failed ? "\u2716" : "\u2714";
        MutableComponent result = Component.literal((String)(" " + symbol + " Magikarp patch Ability(name=" + pokemon.getAbility().getName() + ", priority=" + pokemon.getAbility().getPriority() + ", index=" + pokemon.getAbility().getIndex() + ", forced=" + pokemon.getAbility().getForced() + ")"));
        if (failed) {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.red(result);
        } else {
            Intrinsics.checkNotNull((Object)result);
            component = (Component)TextKt.green(result);
        }
        return component;
    }

    private final void testCodecOutput(CommandContext<CommandSourceStack> context) {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        Pokemon pokemon = PlayerExtensionsKt.party(serverPlayer).get(0);
        if (pokemon == null) {
            pokemon = new Pokemon();
        }
        Pokemon pokemon2 = pokemon;
        pokemon2.setNickname(pokemon2.getSpecies().getTranslatedName().withStyle(arg_0 -> TestCommand.testCodecOutput$lambda$0(pokemon2, arg_0)));
        JsonElement jsonElement = (JsonElement)Pokemon.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pokemon2).getOrThrow();
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)jsonElement.toString()));
    }

    /*
     * WARNING - void declaration
     */
    private final void testPartySelectHoverText(CommandContext<CommandSourceStack> context) {
        Collection<PartySelectPokemonDTO> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Intrinsics.checkNotNull((Object)player);
        PlayerPartyStore party = PlayerExtensionsKt.party(player);
        Iterable iterable = CollectionsKt.toList((Iterable)party);
        Component component = null;
        ServerPlayer serverPlayer = player;
        PartySelectCallbacks partySelectCallbacks = PartySelectCallbacks.INSTANCE;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pokemon pokemon = (Pokemon)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new MutableComponent[2];
            MutableComponent mutableComponent = Component.literal((String)"Nature: ");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            MutableComponent mutableComponent2 = TextKt.gray(mutableComponent);
            MutableComponent mutableComponent3 = MiscUtilsKt.asTranslated(it.getNature().getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"asTranslated(...)");
            objectArray[0] = mutableComponent2.append((Component)TextKt.green(mutableComponent3));
            MutableComponent mutableComponent4 = Component.literal((String)"Ability: ");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"literal(...)");
            MutableComponent mutableComponent5 = TextKt.gray(mutableComponent4);
            MutableComponent mutableComponent6 = MiscUtilsKt.asTranslated(it.getAbility().getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"asTranslated(...)");
            objectArray[1] = mutableComponent5.append((Component)TextKt.aqua(mutableComponent6));
            collection.add(new PartySelectPokemonDTO((Pokemon)it, true, CollectionsKt.listOf((Object[])objectArray)));
        }
        collection = (List)destination$iv$iv;
        PartySelectCallbacks.create$default(partySelectCallbacks, serverPlayer, component, CollectionsKt.toList((Iterable)collection), null, TestCommand::testPartySelectHoverText$lambda$1, 10, null);
    }

    private final void tryTamePokemon(ServerPlayer player) {
        PokemonEntity pokemon = (PokemonEntity)PlayerExtensionsKt.traceFirstEntityCollision$default((LivingEntity)player, 0.0f, 0.0f, PokemonEntity.class, null, null, 27, null);
        if (pokemon == null) {
            player.sendSystemMessage((Component)TextKt.text("Not looking at pokemon"));
            return;
        }
        if (pokemon.isTame()) {
            player.sendSystemMessage((Component)TextKt.text("Cant tame an owned pokemon"));
            return;
        }
        pokemon.tame((Player)player);
        player.sendSystemMessage((Component)TextKt.text("Pokemon tamed"));
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(4);
    }

    private static final boolean testClosestBattle$lambda$1(PokemonEntity entityPokemon) {
        return entityPokemon.getPokemon().isWild();
    }

    private static final boolean testClosestBattle$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit testTrade$lambda$0(ActiveTrade $trade, ScheduledTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!Intrinsics.areEqual((Object)trade, (Object)$trade)) {
            task.expire();
            return Unit.INSTANCE;
        }
        INSTANCE.testUpdate();
        return Unit.INSTANCE;
    }

    private static final boolean readBerryDataFromCSV$lambda$0(JsonElement it) {
        return true;
    }

    private static final Style testCodecOutput$lambda$0(Pokemon $pokemon, Style it) {
        return it.withColor($pokemon.getForm().getPrimaryType().getHue()).withBold(Boolean.valueOf(true));
    }

    private static final Unit testPartySelectHoverText$lambda$1(ServerPlayer player, int index) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Unit.INSTANCE;
    }
}

