/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.NPCClassArgumentType;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0010\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/mod/common/command/SpawnNPCCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "level", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/world/phys/Vec3;I)I", "", "NAME", "Ljava/lang/String;", "CLASS", "POSITION", "LEVEL", "ALIAS", "AT_NAME", "AT_ALIAS", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "INVALID_POS_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "FAILED_SPAWN_EXCEPTION", "common"})
public final class SpawnNPCCommand {
    @NotNull
    public static final SpawnNPCCommand INSTANCE = new SpawnNPCCommand();
    @NotNull
    private static final String NAME = "spawnnpc";
    @NotNull
    private static final String CLASS = "class";
    @NotNull
    private static final String POSITION = "pos";
    @NotNull
    private static final String LEVEL = "level";
    @NotNull
    private static final String ALIAS = "npcspawn";
    @NotNull
    private static final String AT_NAME = "spawnnpcat";
    @NotNull
    private static final String AT_ALIAS = "npcspawnat";
    @NotNull
    private static final SimpleCommandExceptionType INVALID_POS_EXCEPTION;
    @NotNull
    private static final SimpleCommandExceptionType FAILED_SPAWN_EXCEPTION;

    private SpawnNPCCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode contextPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getSPAWN_NPC(), false, 2, null)).then(((RequiredArgumentBuilder)Commands.argument((String)CLASS, (ArgumentType)NPCClassArgumentType.Companion.npcClass()).then(Commands.argument((String)LEVEL, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(SpawnNPCCommand::register$lambda$0))).executes(SpawnNPCCommand::register$lambda$1)));
        Intrinsics.checkNotNull((Object)contextPositionCommand);
        dispatcher.register(CommandUtilsKt.alias(contextPositionCommand, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)AT_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        LiteralCommandNode argumentPositionCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.getSPAWN_NPC(), false, 2, null)).then(Commands.argument((String)POSITION, (ArgumentType)((ArgumentType)Vec3Argument.vec3())).then(((RequiredArgumentBuilder)Commands.argument((String)CLASS, (ArgumentType)NPCClassArgumentType.Companion.npcClass()).then(Commands.argument((String)LEVEL, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(SpawnNPCCommand::register$lambda$2))).executes(SpawnNPCCommand::register$lambda$3))));
        Intrinsics.checkNotNull((Object)argumentPositionCommand);
        dispatcher.register(CommandUtilsKt.alias(argumentPositionCommand, AT_ALIAS));
    }

    private final int execute(CommandContext<CommandSourceStack> context, Vec3 pos, int level) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        BlockPos blockPos = Vec3ExtensionsKt.toBlockPos(pos);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            CommandSyntaxException commandSyntaxException = INVALID_POS_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        NPCClass npcClass = NPCClassArgumentType.Companion.getNPCClass(context, CLASS);
        Intrinsics.checkNotNull((Object)world);
        NPCEntity npc = new NPCEntity((Level)world);
        npc.moveTo(pos.x, pos.y, pos.z, npc.getYRot(), npc.getXRot());
        npc.setNpc(npcClass);
        npc.initialize(level);
        if (world.addFreshEntity((Entity)npc)) {
            return 1;
        }
        CommandSyntaxException commandSyntaxException = FAILED_SPAWN_EXCEPTION.create();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
        throw (Throwable)commandSyntaxException;
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = ((CommandSourceStack)context.getSource()).getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3, IntegerArgumentType.getInteger((CommandContext)context, (String)LEVEL));
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = ((CommandSourceStack)context.getSource()).getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3, 1);
    }

    private static final int register$lambda$2(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = Vec3Argument.getVec3((CommandContext)context, (String)POSITION);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getVec3(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3, IntegerArgumentType.getInteger((CommandContext)context, (String)LEVEL));
    }

    private static final int register$lambda$3(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        Vec3 vec3 = Vec3Argument.getVec3((CommandContext)context, (String)POSITION);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getVec3(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)context, vec3, 1);
    }

    static {
        MutableComponent mutableComponent = Component.literal((String)"Invalid position");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        INVALID_POS_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent));
        MutableComponent mutableComponent2 = Component.literal((String)"Unable to spawn at the given position");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
        FAILED_SPAWN_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent2));
    }
}

