/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/command/SpawnAllPokemon;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lkotlin/ranges/IntRange;", "range", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lkotlin/ranges/IntRange;)I", "common"})
public final class SpawnAllPokemon {
    @NotNull
    public static final SpawnAllPokemon INSTANCE = new SpawnAllPokemon();

    private SpawnAllPokemon() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"spawnallpokemon");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.requiresWithPermission((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getSPAWN_ALL_POKEMON(), (Function1<? super CommandSourceStack, Boolean>)((Function1)SpawnAllPokemon::register$lambda$0))).then(((RequiredArgumentBuilder)Commands.argument((String)"min", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(Commands.argument((String)"max", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(SpawnAllPokemon::register$lambda$1))).executes(SpawnAllPokemon::register$lambda$2))).executes(SpawnAllPokemon::register$lambda$3));
    }

    private final int execute(CommandContext<CommandSourceStack> context, IntRange range) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        for (Species species : PokemonSpecies.getImplemented()) {
            int n = range.getFirst();
            int n2 = range.getLast();
            int n3 = species.getNationalPokedexNumber();
            boolean bl = n <= n3 ? n3 <= n2 : false;
            if (!bl) continue;
            Cobblemon.LOGGER.debug(species.getName());
            PokemonProperties pokemonProperties = PokemonProperties.Companion.parse$default(PokemonProperties.Companion, "species=" + species.getName() + " level=10", null, null, 6, null);
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"getLevel(...)");
            PokemonEntity pokemonEntity = PokemonProperties.createEntity$default(pokemonProperties, (Level)serverLevel, null, 2, null);
            BlockPos blockPos = player.blockPosition();
            pokemonEntity.moveTo(player.getX(), player.getY(), player.getZ(), pokemonEntity.getYRot(), pokemonEntity.getXRot());
            pokemonEntity.getEntityData().set(PokemonEntity.Companion.getSPAWN_DIRECTION(), (Object)Float.valueOf(pokemonEntity.getRandom().nextFloat() * 360.0f));
            pokemonEntity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(blockPos), MobSpawnType.COMMAND, null);
            ((CommandSourceStack)context.getSource()).getLevel().addFreshEntity((Entity)pokemonEntity);
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPlayer() != null;
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(IntegerArgumentType.getInteger((CommandContext)it, (String)"min"), IntegerArgumentType.getInteger((CommandContext)it, (String)"max")));
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(IntegerArgumentType.getInteger((CommandContext)it, (String)"min"), Integer.MAX_VALUE));
    }

    private static final int register$lambda$3(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, new IntRange(1, Integer.MAX_VALUE));
    }
}

