/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0013R\u0014\u0010\u0019\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/command/PokemonEditCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;)I", "", "NAME", "Ljava/lang/String;", "NAME_OTHER", "PLAYER", "SLOT", "PROPERTIES", "ALIAS", "ALIAS_OTHER", "common"})
public final class PokemonEditCommand {
    @NotNull
    public static final PokemonEditCommand INSTANCE = new PokemonEditCommand();
    @NotNull
    private static final String NAME = "pokemonedit";
    @NotNull
    private static final String NAME_OTHER = "pokemoneditother";
    @NotNull
    private static final String PLAYER = "player";
    @NotNull
    private static final String SLOT = "slot";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String ALIAS = "pokeedit";
    @NotNull
    private static final String ALIAS_OTHER = "pokeeditother";

    private PokemonEditCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode selfCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getPOKEMON_EDIT_SELF(), false, 2, null)).then(Commands.argument((String)SLOT, (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PokemonEditCommand::register$lambda$0))));
        Intrinsics.checkNotNull((Object)selfCommand);
        dispatcher.register(CommandUtilsKt.alias(selfCommand, ALIAS));
        LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)NAME_OTHER);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder2, (String)"literal(...)");
        LiteralCommandNode otherCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder2, CobblemonPermissions.getPOKEMON_EDIT_OTHER(), false, 2, null)).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)SLOT, (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PokemonEditCommand::register$lambda$1)))));
        Intrinsics.checkNotNull((Object)otherCommand);
        dispatcher.register(CommandUtilsKt.alias(otherCommand, ALIAS_OTHER));
    }

    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(context, SLOT, player);
        MutableComponent oldName = pokemon.getSpecies().getTranslatedName();
        PokemonProperties properties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, PROPERTIES);
        properties.apply(pokemon);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> PokemonEditCommand.execute$lambda$0(oldName, player), true);
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    private static final Component execute$lambda$0(MutableComponent $oldName, ServerPlayer $player) {
        Object[] objectArray = new Object[2];
        objectArray[0] = $oldName;
        Intrinsics.checkNotNullExpressionValue((Object)$player.getName(), (String)"getName(...)");
        return (Component)LocalizationUtilsKt.commandLang(NAME, objectArray);
    }
}

