/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.command.argument.PokemonPropertiesArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/cobblemon/mod/common/command/PcSearchCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/network/chat/MutableComponent;", "label", "value", "formatField", "(Lnet/minecraft/network/chat/MutableComponent;Lnet/minecraft/network/chat/MutableComponent;)Lnet/minecraft/network/chat/MutableComponent;", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;)I", "", "NAME", "Ljava/lang/String;", "PROPERTIES", "OTHER", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "IN_BATTLE_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "common"})
@SourceDebugExtension(value={"SMAP\nPcSearchCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PcSearchCommand.kt\ncom/cobblemon/mod/common/command/PcSearchCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1878#2,3:121\n1869#2,2:124\n*S KotlinDebug\n*F\n+ 1 PcSearchCommand.kt\ncom/cobblemon/mod/common/command/PcSearchCommand\n*L\n70#1:121,3\n113#1:124,2\n*E\n"})
public final class PcSearchCommand {
    @NotNull
    public static final PcSearchCommand INSTANCE = new PcSearchCommand();
    @NotNull
    private static final String NAME = "pcsearch";
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String OTHER = "other";
    @NotNull
    private static final SimpleCommandExceptionType IN_BATTLE_EXCEPTION;

    private PcSearchCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getPC_SEARCH(), false, 2, null)).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PcSearchCommand::register$lambda$0))).then(Commands.literal((String)OTHER).then(Commands.argument((String)OTHER, (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)PROPERTIES, (ArgumentType)PokemonPropertiesArgumentType.Companion.properties()).executes(PcSearchCommand::register$lambda$1)))));
    }

    private final MutableComponent formatField(MutableComponent label, MutableComponent value) {
        return TextKt.add(TextKt.aqua(TextKt.add(label, ": ")), (Component)TextKt.yellow(value));
    }

    /*
     * WARNING - void declaration
     */
    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        if (PlayerExtensionsKt.isInBattle(player)) {
            CommandSyntaxException commandSyntaxException = IN_BATTLE_EXCEPTION.create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        PokemonProperties pokemonProperties = PokemonPropertiesArgumentType.Companion.getPokemonProperties(context, PROPERTIES);
        PCStore pc = PlayerExtensionsKt.pc(player);
        List matchingPokemon = new ArrayList();
        Object[] $this$forEachIndexed$iv = (Object[])pc.getBoxes();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object t : $this$forEachIndexed$iv) {
            void box;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PCBox pCBox = (PCBox)t;
            int boxIndex = n;
            boolean bl = false;
            Map<Integer, Pokemon> nonEmptySlots = box.getNonEmptySlots();
            for (Map.Entry<Integer, Pokemon> entry : nonEmptySlots.entrySet()) {
                int slotIndex = ((Number)entry.getKey()).intValue();
                Pokemon pokemon = entry.getValue();
                if (!pokemonProperties.matches(pokemon)) continue;
                int boxNumber = boxIndex + 1;
                MutableComponent displayName = pokemon.getSpecies().getTranslatedName();
                int level = pokemon.getLevel();
                Object[] objectArray = new Object[2];
                objectArray[0] = displayName;
                Object[] objectArray2 = new Object[]{level};
                Intrinsics.checkNotNullExpressionValue((Object)LocalizationUtilsKt.lang("label.lv", objectArray2), (String)"lang(...)");
                MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("pcsearch.entry", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
                MutableComponent baseText = TextKt.yellow(mutableComponent);
                MutableComponent mutableComponent2 = Component.literal((String)"");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
                MutableComponent mutableComponent3 = LocalizationUtilsKt.lang("ui.info.species", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"lang(...)");
                MutableComponent mutableComponent4 = TextKt.add(TextKt.add(mutableComponent2, (Component)INSTANCE.formatField(mutableComponent3, displayName)), " ");
                Object[] objectArray3 = new Object[]{level};
                MutableComponent mutableComponent5 = LocalizationUtilsKt.lang("label.lv", objectArray3);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"lang(...)");
                MutableComponent mutableComponent6 = TextKt.add(TextKt.add(mutableComponent4, (Component)mutableComponent5), "\n");
                MutableComponent mutableComponent7 = LocalizationUtilsKt.lang("ui.info.gender", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent7, (String)"lang(...)");
                String string = pokemon.getGender().name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                MutableComponent mutableComponent8 = LocalizationUtilsKt.lang("gender." + string, new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent8, (String)"lang(...)");
                MutableComponent mutableComponent9 = TextKt.add(TextKt.add(mutableComponent6, (Component)INSTANCE.formatField(mutableComponent7, mutableComponent8)), "\n");
                MutableComponent mutableComponent10 = LocalizationUtilsKt.lang("ui.info.nature", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent10, (String)"lang(...)");
                MutableComponent mutableComponent11 = MiscUtilsKt.asTranslated(pokemon.getNature().getDisplayName());
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent11, (String)"asTranslated(...)");
                MutableComponent mutableComponent12 = TextKt.add(TextKt.add(mutableComponent9, (Component)INSTANCE.formatField(mutableComponent10, mutableComponent11)), "\n");
                MutableComponent mutableComponent13 = LocalizationUtilsKt.lang("ui.info.ability", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent13, (String)"lang(...)");
                MutableComponent mutableComponent14 = MiscUtilsKt.asTranslated(pokemon.getAbility().getDisplayName());
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent14, (String)"asTranslated(...)");
                MutableComponent mutableComponent15 = TextKt.add(TextKt.add(mutableComponent12, (Component)INSTANCE.formatField(mutableComponent13, mutableComponent14)), "\n");
                MutableComponent mutableComponent16 = LocalizationUtilsKt.lang("ui.stats.ivs", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent16, (String)"lang(...)");
                MutableComponent mutableComponent17 = TextKt.add(TextKt.add(mutableComponent15, (Component)TextKt.add(TextKt.aqua(TextKt.add(mutableComponent16, ": ")), (Component)TextKt.yellow(pokemon.getIvs().get(Stats.HP) + "/" + pokemon.getIvs().get(Stats.ATTACK) + "/" + pokemon.getIvs().get(Stats.DEFENCE) + "/" + pokemon.getIvs().get(Stats.SPEED) + "/" + pokemon.getIvs().get(Stats.SPECIAL_ATTACK) + "/" + pokemon.getIvs().get(Stats.SPECIAL_DEFENCE)))), "\n");
                MutableComponent mutableComponent18 = LocalizationUtilsKt.lang("ui.stats.evs", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent18, (String)"lang(...)");
                MutableComponent hoverText = TextKt.add(mutableComponent17, (Component)TextKt.add(TextKt.aqua(TextKt.add(mutableComponent18, ": ")), (Component)TextKt.yellow(pokemon.getEvs().get(Stats.HP) + "/" + pokemon.getEvs().get(Stats.ATTACK) + "/" + pokemon.getEvs().get(Stats.DEFENCE) + "/" + pokemon.getEvs().get(Stats.SPEED) + "/" + pokemon.getEvs().get(Stats.SPECIAL_ATTACK) + "/" + pokemon.getEvs().get(Stats.SPECIAL_DEFENCE))));
                if (pokemon.getShiny()) {
                    MutableComponent mutableComponent19 = TextKt.add(hoverText, "\n");
                    MutableComponent mutableComponent20 = LocalizationUtilsKt.commandLang("pcsearch.tooltip.shiny", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent20, (String)"commandLang(...)");
                    TextKt.add(mutableComponent19, (Component)TextKt.gold(mutableComponent20));
                }
                TextKt.onHover(baseText, hoverText);
                objectArray2 = new Object[]{boxNumber, slotIndex + 1};
                MutableComponent mutableComponent21 = LocalizationUtilsKt.commandLang("pcsearch.location", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent21, (String)"commandLang(...)");
                MutableComponent mutableComponent22 = TextKt.green(mutableComponent21);
                MutableComponent mutableComponent23 = LocalizationUtilsKt.commandLang("pcsearch.takepokemon", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent23, (String)"commandLang(...)");
                MutableComponent locationText = TextKt.suggest(TextKt.onHover(mutableComponent22, mutableComponent23), "/pctake " + player.getName().getString() + " " + boxNumber + " " + (slotIndex + 1));
                matchingPokemon.add(TextKt.add(baseText, (Component)locationText));
            }
        }
        if (matchingPokemon.isEmpty()) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            $this$forEachIndexed$iv = new Object[2];
            $this$forEachIndexed$iv[0] = pokemonProperties.getOriginalString();
            Intrinsics.checkNotNullExpressionValue((Object)player.getName().getString(), (String)"getString(...)");
            commandSourceStack.sendSystemMessage((Component)LocalizationUtilsKt.commandLang("pcsearch.nomatch", $this$forEachIndexed$iv));
        } else {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            $this$forEachIndexed$iv = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)player.getName().getString(), (String)"getString(...)");
            commandSourceStack.sendSystemMessage((Component)LocalizationUtilsKt.commandLang("pcsearch.found", $this$forEachIndexed$iv));
            Iterable $this$forEach$iv = matchingPokemon;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MutableComponent mutableComponent = (MutableComponent)element$iv;
                boolean bl = false;
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)mutableComponent);
            }
        }
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    private static final int register$lambda$1(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = EntityArgument.getPlayer((CommandContext)it, (String)OTHER);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    static {
        MutableComponent mutableComponent = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
        IN_BATTLE_EXCEPTION = new SimpleCommandExceptionType((Message)TextKt.red(mutableComponent));
    }
}

