/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/command/NPCDeleteCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "source", "", "execute", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/commands/CommandSourceStack;)I", "common"})
public final class NPCDeleteCommand {
    @NotNull
    public static final NPCDeleteCommand INSTANCE = new NPCDeleteCommand();

    private NPCDeleteCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"npcdelete");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getNPC_DELETE(), false, 2, null)).then(Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entity())).executes(NPCDeleteCommand::register$lambda$0))).executes(NPCDeleteCommand::register$lambda$1));
    }

    private final int execute(Entity entity, CommandSourceStack source) {
        if (!(entity instanceof NPCEntity)) {
            MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("npcedit.non_npc", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
            source.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return 0;
        }
        entity.discard();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)((NPCEntity)entity).getName().getString(), (String)"getString(...)");
        MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("npcdelete.deleted", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
        source.sendSystemMessage((Component)TextKt.green(mutableComponent));
        return 1;
    }

    private static final int register$lambda$0(CommandContext context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"target");
        Intrinsics.checkNotNull((Object)entity);
        Intrinsics.checkNotNull((Object)source);
        return INSTANCE.execute(entity, source);
    }

    private static final int register$lambda$1(CommandContext context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("npcdelete.not_player", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
            source.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return 0;
        }
        NPCEntity targetEntity = (NPCEntity)PlayerExtensionsKt.traceFirstEntityCollision$default((LivingEntity)player, 0.0f, 0.0f, NPCEntity.class, null, null, 27, null);
        if (targetEntity == null) {
            MutableComponent mutableComponent = LocalizationUtilsKt.commandLang("npcedit.non_npc", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"commandLang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return 0;
        }
        Entity entity = (Entity)targetEntity;
        Intrinsics.checkNotNull((Object)source);
        return INSTANCE.execute(entity, source);
    }
}

