/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.pokemon.experience.CommandExperienceSource;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/command/LevelUp;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/server/level/ServerPlayer;)I", "common"})
public final class LevelUp {
    @NotNull
    public static final LevelUp INSTANCE = new LevelUp();

    private LevelUp() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"levelup");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralArgumentBuilder literalArgumentBuilder2 = (LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getLEVEL_UP_SELF(), false, 2, null);
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player()));
        Intrinsics.checkNotNullExpressionValue((Object)requiredArgumentBuilder, (String)"argument(...)");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder2.then(((RequiredArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)requiredArgumentBuilder, CobblemonPermissions.getLEVEL_UP_OTHER(), false, 2, null)).then(Commands.argument((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)99))).executes(LevelUp::register$lambda$0)))).then(((RequiredArgumentBuilder)Commands.argument((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)99))).requires(LevelUp::register$lambda$1)).executes(LevelUp::register$lambda$2));
        dispatcher.register(command);
    }

    private final int execute(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        PlayerPartyStore party;
        int slot = IntegerArgumentType.getInteger(context, (String)"slot");
        if (slot > (party = PlayerExtensionsKt.party(player)).size()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TextKt.text("Your party only has " + party.size() + " slots."));
            return 0;
        }
        Pokemon pokemon = party.get(slot - 1);
        if (pokemon == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TextKt.text("There is no Pok\u00e9mon in slot " + slot));
            return 0;
        }
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandExperienceSource source = new CommandExperienceSource((CommandSourceStack)object);
        pokemon.addExperienceWithPlayer(player, source, pokemon.getExperienceToNextLevel());
        return 1;
    }

    private static final int register$lambda$0(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = CommandContextExtensionsKt.player$default(it, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"player$default(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }

    private static final boolean register$lambda$1(CommandSourceStack it) {
        return it.getEntity() instanceof ServerPlayer && it.getPlayer() != null;
    }

    private static final int register$lambda$2(CommandContext it) {
        Intrinsics.checkNotNull((Object)it);
        ServerPlayer serverPlayer = ((CommandSourceStack)it.getSource()).getPlayerOrException();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayerOrException(...)");
        return INSTANCE.execute((CommandContext<CommandSourceStack>)it, serverPlayer);
    }
}

