/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.command.argument.PartySlotArgumentType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/command/HeldItemCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "Lnet/minecraft/commands/CommandBuildContext;", "commandRegistryAccess", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/commands/CommandBuildContext;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "", "NAME", "Ljava/lang/String;", "TARGET", "SLOT", "ITEM", "common"})
public final class HeldItemCommand {
    @NotNull
    public static final HeldItemCommand INSTANCE = new HeldItemCommand();
    @NotNull
    private static final String NAME = "held_item";
    @NotNull
    private static final String TARGET = "target";
    @NotNull
    private static final String SLOT = "slot";
    @NotNull
    private static final String ITEM = "item";

    private HeldItemCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandBuildContext commandRegistryAccess) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)commandRegistryAccess, (String)"commandRegistryAccess");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getHELD_ITEM(), false, 2, null)).then(Commands.argument((String)TARGET, (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)SLOT, (ArgumentType)PartySlotArgumentType.Companion.partySlot()).then(Commands.argument((String)ITEM, (ArgumentType)((ArgumentType)ItemArgument.item((CommandBuildContext)commandRegistryAccess))).executes(this::execute)))));
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)TARGET);
        Intrinsics.checkNotNull((Object)player);
        Pokemon pokemon = PartySlotArgumentType.Companion.getPokemonOf(ctx, SLOT, player);
        ItemInput stackArgument = ItemArgument.getItem(ctx, (String)ITEM);
        ItemStack stack = stackArgument.createItemStack(1, false);
        Intrinsics.checkNotNull((Object)stack);
        pokemon.swapHeldItem(stack, true, false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> HeldItemCommand.execute$lambda$0(player, pokemon, stack), true);
        return 1;
    }

    private static final Component execute$lambda$0(ServerPlayer $player, Pokemon $pokemon, ItemStack $stack) {
        Object[] objectArray = new Object[3];
        Intrinsics.checkNotNullExpressionValue((Object)$player.getName(), (String)"getName(...)");
        objectArray[1] = $pokemon.getSpecies().getTranslatedName();
        Intrinsics.checkNotNullExpressionValue((Object)$stack.getDisplayName(), (String)"getDisplayName(...)");
        return (Component)LocalizationUtilsKt.commandLang(NAME, objectArray);
    }
}

