/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.storage.ChangePCBoxWallpaperEvent;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.reactive.CancelableObservable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.net.messages.client.storage.pc.wallpaper.ChangePCBoxWallpaperPacket;
import com.cobblemon.mod.common.util.CommandContextExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R(\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R(\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/command/ChangeBoxWallpaperCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "box", "Lnet/minecraft/resources/ResourceLocation;", "wallpaper", "execute", "(Lnet/minecraft/server/level/ServerPlayer;ILnet/minecraft/resources/ResourceLocation;)I", "Lkotlin/Function1;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "BOX_DOES_NOT_EXIST", "Lkotlin/jvm/functions/Function1;", "", "WALLPAPER_DOES_NOT_EXIST", "CANNOT_CHANGE_WALLPAPER", "common"})
@SourceDebugExtension(value={"SMAP\nChangeBoxWallpaperCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeBoxWallpaperCommand.kt\ncom/cobblemon/mod/common/command/ChangeBoxWallpaperCommand\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/CancelableObservable\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n40#2:91\n41#2,4:95\n46#2:108\n47#2:111\n17#3,2:92\n14#3,5:99\n19#3:107\n19#3:110\n13805#4:94\n13805#4:104\n13806#4:106\n13806#4:109\n14#5:105\n1869#6,2:112\n*S KotlinDebug\n*F\n+ 1 ChangeBoxWallpaperCommand.kt\ncom/cobblemon/mod/common/command/ChangeBoxWallpaperCommand\n*L\n76#1:91\n76#1:95,4\n76#1:108\n76#1:111\n76#1:92,2\n80#1:99,5\n80#1:107\n76#1:110\n76#1:94\n80#1:104\n80#1:106\n76#1:109\n80#1:105\n45#1:112,2\n*E\n"})
public final class ChangeBoxWallpaperCommand {
    @NotNull
    public static final ChangeBoxWallpaperCommand INSTANCE = new ChangeBoxWallpaperCommand();
    @NotNull
    private static final Function1<Integer, MutableComponent> BOX_DOES_NOT_EXIST = ChangeBoxWallpaperCommand::BOX_DOES_NOT_EXIST$lambda$0;
    @NotNull
    private static final Function1<String, MutableComponent> WALLPAPER_DOES_NOT_EXIST = ChangeBoxWallpaperCommand::WALLPAPER_DOES_NOT_EXIST$lambda$0;
    @NotNull
    private static final Function1<String, MutableComponent> CANNOT_CHANGE_WALLPAPER = ChangeBoxWallpaperCommand::CANNOT_CHANGE_WALLPAPER$lambda$0;

    private ChangeBoxWallpaperCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"changewallpaper");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getCHANGE_WALLPAPER(), false, 2, null)).then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)"box", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).then(Commands.argument((String)"wallpaper", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).suggests(ChangeBoxWallpaperCommand::register$lambda$0).executes(ChangeBoxWallpaperCommand::register$lambda$1)))));
    }

    /*
     * WARNING - void declaration
     */
    private final int execute(ServerPlayer player, int box, ResourceLocation wallpaper) {
        void this_$iv$iv;
        void event$iv;
        void this_$iv;
        PCStore playerPc;
        block8: {
            block7: {
                playerPc = PlayerExtensionsKt.pc(player);
                if (playerPc.getBoxes().size() < box) {
                    Object object = BOX_DOES_NOT_EXIST.invoke((Object)box);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                    throw (Throwable)commandSyntaxException;
                }
                if (wallpaper == null) break block7;
                Set<ResourceLocation> set = Cobblemon.INSTANCE.getWallpapers().get(player.getUUID());
                boolean bl = set != null ? !set.contains(wallpaper) : false;
                if (!bl) break block8;
            }
            Object object = WALLPAPER_DOES_NOT_EXIST.invoke((Object)String.valueOf(wallpaper));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
            CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
            throw (Throwable)commandSyntaxException;
        }
        PCBox pcBox = playerPc.getBoxes().get(box - 1);
        CancelableObservable<ChangePCBoxWallpaperEvent.Pre> cancelableObservable = CobblemonEvents.CHANGE_PC_BOX_WALLPAPER_EVENT_PRE;
        ChangePCBoxWallpaperEvent.Pre pre = new ChangePCBoxWallpaperEvent.Pre(player, pcBox, wallpaper, null);
        CancelableObservable<ChangePCBoxWallpaperEvent.Pre> cancelableObservable2 = cancelableObservable;
        Cancelable cancelable = pre;
        boolean $i$f$postThen = false;
        EventObservable eventObservable = (EventObservable)this_$iv;
        Cancelable[] cancelableArray = new Cancelable[]{event$iv};
        Cancelable[] events$iv$iv = cancelableArray;
        boolean $i$f$post = false;
        this_$iv$iv.emit(Arrays.copyOf(events$iv$iv, events$iv$iv.length));
        Cancelable[] $this$forEach$iv$iv$iv = events$iv$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$iv;
            ChangePCBoxWallpaperEvent.Pre it;
            Cancelable element$iv$iv$iv;
            Cancelable it$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            if (it$iv.isCanceled()) {
                it = (ChangePCBoxWallpaperEvent.Pre)it$iv;
                boolean bl2 = false;
                String string = wallpaper.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Object object = CANNOT_CHANGE_WALLPAPER.invoke((Object)string);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType((Message)TextKt.red((MutableComponent)object)).create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            it = (ChangePCBoxWallpaperEvent.Pre)it$iv;
            boolean bl3 = false;
            pcBox.setWallpaper(it.getWallpaper());
            EventObservable<ChangePCBoxWallpaperEvent.Post> eventObservable2 = CobblemonEvents.CHANGE_PC_BOX_WALLPAPER_EVENT_POST;
            ChangePCBoxWallpaperEvent.Post[] postArray = new ChangePCBoxWallpaperEvent.Post[]{new ChangePCBoxWallpaperEvent.Post(player, pcBox, it.getWallpaper(), null)};
            ChangePCBoxWallpaperEvent.Post[] events$iv = postArray;
            boolean $i$f$post2 = false;
            $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
            ChangePCBoxWallpaperEvent.Post[] $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv$iv.length;
            for (int j = 0; j < n2; ++j) {
                ChangePCBoxWallpaperEvent.Post element$iv$iv;
                ChangePCBoxWallpaperEvent.Post post2 = element$iv$iv = $this$forEach$iv$iv[j];
                boolean bl4 = false;
                ChangePCBoxWallpaperEvent.Post it2 = post2;
            }
            new ChangePCBoxWallpaperPacket(playerPc.getUuid(), pcBox.getBoxNumber(), it.getWallpaper()).sendToPlayer(player);
        }
        return 1;
    }

    private static final MutableComponent BOX_DOES_NOT_EXIST$lambda$0(int boxNo) {
        Object[] objectArray = new Object[]{boxNo};
        return LocalizationUtilsKt.commandLang("pokebox.box_does_not_exist", objectArray);
    }

    private static final MutableComponent WALLPAPER_DOES_NOT_EXIST$lambda$0(String wallpaper) {
        Intrinsics.checkNotNullParameter((Object)wallpaper, (String)"wallpaper");
        Object[] objectArray = new Object[]{wallpaper};
        return LocalizationUtilsKt.commandLang("changewallpaper.wallpaper_does_not_exist", objectArray);
    }

    private static final MutableComponent CANNOT_CHANGE_WALLPAPER$lambda$0(String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new Object[]{name};
        return LocalizationUtilsKt.commandLang("changewallpaper.cannot_change_wallpaper", objectArray);
    }

    private static final CompletableFuture register$lambda$0(CommandContext context, SuggestionsBuilder builder) {
        block1: {
            Set<ResourceLocation> set = Cobblemon.INSTANCE.getWallpapers().get(EntityArgument.getPlayer((CommandContext)context, (String)"player").getUUID());
            if (set == null) break block1;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceLocation it = (ResourceLocation)element$iv;
                boolean bl = false;
                builder.suggest(it.toString());
            }
        }
        return builder.buildFuture();
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        ServerPlayer player = CommandContextExtensionsKt.player$default(context, null, 1, null);
        int box = IntegerArgumentType.getInteger((CommandContext)context, (String)"box");
        ResourceLocation wallpaper = ResourceLocation.tryParse((String)StringArgumentType.getString((CommandContext)context, (String)"wallpaper"));
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.execute(player, box, wallpaper);
    }
}

