/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormParticlePacket;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J=\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/cobblemon/mod/common/command/BedrockParticleCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "source", "Lnet/minecraft/resources/ResourceLocation;", "effectId", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/world/phys/Vec3;", "target", "", "execute", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;)I", "Lnet/minecraft/world/entity/Entity;", "", "", "locator", "(Lnet/minecraft/commands/CommandSourceStack;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Ljava/util/List;)I", "common"})
@SourceDebugExtension(value={"SMAP\nBedrockParticleCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockParticleCommand.kt\ncom/cobblemon/mod/common/command/BedrockParticleCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1869#2,2:89\n1869#2,2:91\n1#3:93\n*S KotlinDebug\n*F\n+ 1 BedrockParticleCommand.kt\ncom/cobblemon/mod/common/command/BedrockParticleCommand\n*L\n77#1:89,2\n84#1:91,2\n*E\n"})
public final class BedrockParticleCommand {
    @NotNull
    public static final BedrockParticleCommand INSTANCE = new BedrockParticleCommand();

    private BedrockParticleCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)"bedrockparticle");
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getBEDROCK_PARTICLE(), false, 2, null)).then(((RequiredArgumentBuilder)Commands.argument((String)"effect", (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(BedrockParticleCommand::register$lambda$0)).then(Commands.argument((String)"locator", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(BedrockParticleCommand::register$lambda$1)))).then(Commands.argument((String)"world", (ArgumentType)((ArgumentType)DimensionArgument.dimension())).then(Commands.argument((String)"pos", (ArgumentType)((ArgumentType)Vec3Argument.vec3())).executes(BedrockParticleCommand::register$lambda$2)))));
        Intrinsics.checkNotNull((Object)command);
        dispatcher.register(CommandUtilsKt.alias(command, "bedrockparticle"));
    }

    private final int execute(CommandSourceStack source, ResourceLocation effectId, ServerLevel world, Vec3 target) {
        BlockPos pos = Vec3ExtensionsKt.toBlockPos(target);
        List nearbyPlayers = world.getPlayers(arg_0 -> BedrockParticleCommand.execute$lambda$1(arg_0 -> BedrockParticleCommand.execute$lambda$0(pos, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)nearbyPlayers);
        Iterable $this$forEach$iv = nearbyPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            CobblemonNetwork.INSTANCE.sendPacket(player, new SpawnSnowstormParticlePacket(effectId, target));
        }
        return 1;
    }

    private final int execute(CommandSourceStack source, ResourceLocation effectId, ServerLevel world, Entity target, List<String> locator) {
        BlockPos pos = target.blockPosition();
        List nearbyPlayers = world.getPlayers(arg_0 -> BedrockParticleCommand.execute$lambda$4(arg_0 -> BedrockParticleCommand.execute$lambda$3(pos, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)nearbyPlayers);
        Iterable $this$forEach$iv = nearbyPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer player = (ServerPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)player);
            CobblemonNetwork.INSTANCE.sendPacket(player, new SpawnSnowstormEntityParticlePacket(effectId, target.getId(), locator, null, null, 24, null));
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int register$lambda$0(CommandContext it) {
        ResourceLocation effectId = ResourceLocationArgument.getId((CommandContext)it, (String)"effect");
        Collection entities = EntityArgument.getEntities((CommandContext)it, (String)"target");
        Intrinsics.checkNotNull((Object)entities);
        Iterable iterable = entities;
        int n = 0;
        for (Object t : iterable) {
            void entity;
            Entity entity2 = (Entity)t;
            int n2 = n;
            boolean bl = false;
            Object object = it.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            CommandSourceStack commandSourceStack = (CommandSourceStack)object;
            Intrinsics.checkNotNull((Object)effectId);
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = entity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            int n3 = INSTANCE.execute(commandSourceStack, effectId, serverLevel, vec3);
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final int register$lambda$1(CommandContext it) {
        ResourceLocation effectId = ResourceLocationArgument.getId((CommandContext)it, (String)"effect");
        Collection entities = EntityArgument.getEntities((CommandContext)it, (String)"target");
        String locator = StringArgumentType.getString((CommandContext)it, (String)"locator");
        Intrinsics.checkNotNull((Object)entities);
        Iterable iterable = entities;
        int n = 0;
        for (Object t : iterable) {
            void entity;
            Entity entity2 = (Entity)t;
            int n2 = n;
            boolean bl = false;
            Object object = it.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
            CommandSourceStack commandSourceStack = (CommandSourceStack)object;
            Intrinsics.checkNotNull((Object)effectId);
            Level level = entity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            Intrinsics.checkNotNull((Object)entity);
            int n3 = INSTANCE.execute(commandSourceStack, effectId, serverLevel, (Entity)entity, CollectionsKt.listOf((Object)locator));
            n = n2 + n3;
        }
        return n;
    }

    private static final int register$lambda$2(CommandContext it) {
        ResourceLocation effectId = ResourceLocationArgument.getId((CommandContext)it, (String)"effect");
        ServerLevel world = DimensionArgument.getDimension((CommandContext)it, (String)"world");
        Vec3 pos = Vec3Argument.getVec3((CommandContext)it, (String)"pos");
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)effectId);
        Intrinsics.checkNotNull((Object)world, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        Intrinsics.checkNotNull((Object)pos);
        return INSTANCE.execute(commandSourceStack, effectId, world, pos);
    }

    private static final boolean execute$lambda$0(BlockPos $pos, ServerPlayer it) {
        Intrinsics.checkNotNull((Object)it);
        return EntityExtensionsKt.distanceTo((Entity)it, $pos) < 1000.0;
    }

    private static final boolean execute$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean execute$lambda$3(BlockPos $pos, ServerPlayer it) {
        Intrinsics.checkNotNull((Object)it);
        Entity entity = (Entity)it;
        Intrinsics.checkNotNull((Object)$pos);
        return EntityExtensionsKt.distanceTo(entity, $pos) < 1000.0;
    }

    private static final boolean execute$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

