/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.tooltips;

import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.tooltips.TooltipGenerator;
import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/client/tooltips/CobblemonTooltipGenerator;", "Lcom/cobblemon/mod/common/client/tooltips/TooltipGenerator;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "Lnet/minecraft/network/chat/Component;", "lines", "generateTooltip", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)Ljava/util/List;", "", "baseLangKeyForItem", "(Lnet/minecraft/world/item/ItemStack;)Ljava/lang/String;", "common"})
public final class CobblemonTooltipGenerator
extends TooltipGenerator {
    @NotNull
    public static final CobblemonTooltipGenerator INSTANCE = new CobblemonTooltipGenerator();

    private CobblemonTooltipGenerator() {
    }

    @Override
    @Nullable
    public List<Component> generateTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List resultLines = new ArrayList();
        if (stack.getItem().builtInRegistryHolder().unwrapKey().isPresent() && Intrinsics.areEqual((Object)((ResourceKey)stack.getItem().builtInRegistryHolder().unwrapKey().get()).location().getNamespace(), (Object)"cobblemon")) {
            String key;
            Language language = Language.getInstance();
            if (language.has(key = this.baseLangKeyForItem(stack))) {
                MutableComponent mutableComponent = MiscUtilsKt.asTranslated(key);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTranslated(...)");
                resultLines.add(TextKt.gray(mutableComponent));
            }
            int i = 1;
            String listKey = key + "_" + i;
            while (language.has(listKey)) {
                MutableComponent mutableComponent = MiscUtilsKt.asTranslated(listKey);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTranslated(...)");
                resultLines.add(TextKt.gray(mutableComponent));
                listKey = key + "_" + ++i;
            }
        }
        return resultLines;
    }

    private final String baseLangKeyForItem(ItemStack stack) {
        if (stack.getItem() instanceof PokeBallItem) {
            Item item = stack.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.item.PokeBallItem");
            PokeBallItem asPokeball = (PokeBallItem)item;
            return "item." + asPokeball.getPokeBall().getName().getNamespace() + "." + asPokeball.getPokeBall().getName().getPath() + ".tooltip";
        }
        return stack.getDescriptionId() + ".tooltip";
    }
}

